/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.visualizers.VisualizerToolbarComponentAccessor;
import org.netbeans.modules.dlight.visualizers.api.VisualizerToolbarComponent;
import org.netbeans.modules.dlight.visualizers.api.VisualizerToolbarComponentsProvider;
import org.netbeans.modules.dlight.visualizers.util.TimeIntervalPanel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class VisualizerTopComponentTopComponent
extends TopComponent
implements VisualizerContainer,
DLightSessionListener {
    private static VisualizerTopComponentTopComponent instance;
    private static final String PREFERRED_ID = "VisualizerTopComponentTopComponent";
    private JComponent visualizerContent;
    private final TimeIntervalPanel timeFilterPanel = new TimeIntervalPanel(null);
    private final JPanel eastToolbarContent = new JPanel(new FlowLayout(3));
    private final JPanel westToolbarContent = new JPanel(new FlowLayout(3));
    private JPanel toolbarPanel;
    private JPanel visualizerPanel;

    private VisualizerTopComponentTopComponent() {
        this.initComponents();
        this.toolbarPanel.add(this.westToolbarContent);
        this.toolbarPanel.add(this.timeFilterPanel);
        this.toolbarPanel.add(this.eastToolbarContent);
        this.updateToolbar(null);
        this.setName(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"CTL_VisualizerTopComponentTopComponent"));
        this.setToolTipText(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"HINT_VisualizerTopComponentTopComponent"));
    }

    private void initComponents() {
        this.toolbarPanel = new JPanel();
        this.visualizerPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.toolbarPanel.setLayout(new FlowLayout(0, 3, 3));
        this.add(this.toolbarPanel, "First");
        this.visualizerPanel.setLayout(new BorderLayout());
        this.add(this.visualizerPanel, "Center");
    }

    public static synchronized VisualizerTopComponentTopComponent getDefault() {
        if (instance == null) {
            instance = new VisualizerTopComponentTopComponent();
        }
        return instance;
    }

    public static synchronized VisualizerTopComponentTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(VisualizerTopComponentTopComponent.class.getName()).warning("Cannot find VisualizerTopComponentTopComponent component. It will not be located properly in the window system.");
            return VisualizerTopComponentTopComponent.getDefault();
        }
        if (win instanceof VisualizerTopComponentTopComponent) {
            return (VisualizerTopComponentTopComponent)win;
        }
        Logger.getLogger(VisualizerTopComponentTopComponent.class.getName()).warning("There seem to be multiple components with the 'VisualizerTopComponentTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return VisualizerTopComponentTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        DLightManager.getDefault().removeDLightSessionListener((DLightSessionListener)this);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void setContent(String toolName, JComponent viewComponent) {
        DLightLogger.assertTrue((boolean)SwingUtilities.isEventDispatchThread());
        if (this.visualizerContent == viewComponent) {
            return;
        }
        this.visualizerContent = viewComponent;
        this.visualizerPanel.removeAll();
        this.visualizerPanel.add(viewComponent);
        this.eastToolbarContent.removeAll();
        this.westToolbarContent.removeAll();
        if (viewComponent instanceof VisualizerToolbarComponentsProvider) {
            Component comp;
            VisualizerToolbarComponentAccessor vcompAccess = VisualizerToolbarComponentAccessor.getDefault();
            VisualizerToolbarComponentsComparator cmp = new VisualizerToolbarComponentsComparator();
            TreeSet<VisualizerToolbarComponent> eastComponents = new TreeSet<VisualizerToolbarComponent>(cmp);
            TreeSet<VisualizerToolbarComponent> westComponents = new TreeSet<VisualizerToolbarComponent>(cmp);
            VisualizerToolbarComponentsProvider p = (VisualizerToolbarComponentsProvider)((Object)viewComponent);
            for (VisualizerToolbarComponent c : p.getToolbarComponents()) {
                switch (vcompAccess.getConstraints(c)) {
                    case EAST: {
                        eastComponents.add(c);
                        break;
                    }
                    case WEST: {
                        westComponents.add(c);
                        break;
                    }
                }
            }
            for (VisualizerToolbarComponent c : westComponents) {
                comp = vcompAccess.getComponent(c);
                this.westToolbarContent.add(comp);
            }
            for (VisualizerToolbarComponent c : eastComponents) {
                comp = vcompAccess.getComponent(c);
                this.eastToolbarContent.add(comp);
            }
        }
        this.updateToolbar(DLightManager.getDefault().getActiveSession());
        this.setName(toolName);
        this.setToolTipText(toolName);
        this.validate();
        this.repaint();
    }

    public void addVisualizer(String toolID, String toolName, Visualizer<?> view) {
        this.setContent(toolName, view.getComponent());
        view.refresh();
    }

    public void showup() {
        DLightLogger.assertTrue((boolean)SwingUtilities.isEventDispatchThread());
        this.open();
        this.requestActive();
    }

    public void removeVisualizer(Visualizer<?> v) {
        this.closePerformanceMonitor(v);
    }

    public void addContent(String toolName, JComponent viewComponent) {
        this.setContent(toolName, viewComponent);
    }

    public void activeSessionChanged(DLightSession oldSession, DLightSession newSession) {
        this.updateToolbar(newSession);
    }

    public void sessionAdded(DLightSession newSession) {
    }

    public void sessionRemoved(DLightSession removedSession) {
    }

    private void updateToolbar(DLightSession session) {
        this.timeFilterPanel.setVisible(session != null);
        this.timeFilterPanel.update((DataFilterManager)session);
        this.eastToolbarContent.setVisible(this.eastToolbarContent.getComponentCount() > 0);
        this.westToolbarContent.setVisible(this.westToolbarContent.getComponentCount() > 0);
    }

    public void closePerformanceMonitor(Visualizer<?> visualizer) {
        DLightLogger.assertTrue((boolean)SwingUtilities.isEventDispatchThread());
        if (this.visualizerContent != visualizer.getComponent()) {
            return;
        }
        this.visualizerPanel.removeAll();
        this.updateToolbar(null);
        this.setName(NbBundle.getMessage(VisualizerTopComponentTopComponent.class, (String)"RunMonitorDetailes"));
        this.repaint();
    }

    private static class VisualizerToolbarComponentsComparator
    implements Comparator<VisualizerToolbarComponent> {
        private final VisualizerToolbarComponentAccessor vcompAccess = VisualizerToolbarComponentAccessor.getDefault();

        private VisualizerToolbarComponentsComparator() {
        }

        @Override
        public int compare(VisualizerToolbarComponent o1, VisualizerToolbarComponent o2) {
            return Integer.valueOf(this.vcompAccess.getPosition(o1)).compareTo(this.vcompAccess.getPosition(o2));
        }
    }

    private static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private ResolvableHelper() {
        }

        public Object readResolve() {
            return VisualizerTopComponentTopComponent.getDefault();
        }
    }
}

