/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.javame.DeviceListener;
import org.netbeans.modules.vmd.api.io.javame.MidpProjectPropertiesSupport;
import org.netbeans.modules.vmd.screen.ScreenViewController;
import org.openide.awt.UndoRedo;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ScreenEditorView
implements DataEditorView,
DeviceListener {
    private static final long serialVersionUID = -1L;
    public static final String SCREEN_EDITOR_VIEW_DISPLAY_NAME = NbBundle.getMessage(ScreenEditorView.class, (String)"TITLE_ScreenView");
    private DataObjectContext context;
    private transient ScreenViewController controller;

    public ScreenEditorView(DataObjectContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        this.controller = new ScreenViewController(this.context);
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.MODEL;
    }

    public boolean canShowSideWindows() {
        return true;
    }

    public Collection<String> getTags() {
        return Collections.emptySet();
    }

    public String preferredID() {
        return "screen";
    }

    public String getDisplayName() {
        return SCREEN_EDITOR_VIEW_DISPLAY_NAME;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ScreenEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.controller.getVisualRepresentation();
    }

    public JComponent getToolbarRepresentation() {
        return this.controller.getToolbarRepresentation();
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public void componentShowing() {
        MidpProjectPropertiesSupport.addDeviceListener((DataObjectContext)this.context, (DeviceListener)this);
        this.deviceChanged();
    }

    public void componentHidden() {
        MidpProjectPropertiesSupport.removeDeviceChangedListener((DataObjectContext)this.context, (DeviceListener)this);
    }

    public void componentActivated() {
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return this.getOrder();
    }

    public int getEditPriority() {
        return -this.getOrder();
    }

    public int getOrder() {
        return 1000;
    }

    public void deviceChanged() {
        this.controller.setScreenSize(MidpProjectPropertiesSupport.getDeviceScreenSizeFromProject((DataObjectContext)this.context));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.context);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }
}

