/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptorException;
import org.netbeans.modules.web.jsf.editor.facelets.TldProxyLibraryDescriptor;
import org.netbeans.modules.web.jsfapi.api.LibraryType;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class ClassBasedFaceletsLibrary
extends FaceletsLibrary {
    private final Collection<FaceletsLibrary.NamedComponent> components = new ArrayList<FaceletsLibrary.NamedComponent>();
    private LibraryDescriptor libraryDescriptor;
    private final String defaultPrefix;
    private final URL libraryDescriptorSource;

    public ClassBasedFaceletsLibrary(URL libraryDescriptorSourceURL, FaceletsLibrarySupport support, String namespace) {
        super(support, namespace);
        assert (libraryDescriptorSourceURL != null);
        this.defaultPrefix = this.generateDefaultPrefix();
        this.libraryDescriptorSource = libraryDescriptorSourceURL;
        FileObject libraryDescriptorFile = URLMapper.findFileObject((URL)libraryDescriptorSourceURL);
        try {
            this.libraryDescriptor = new TldProxyLibraryDescriptor(FaceletsLibraryDescriptor.create(libraryDescriptorFile), support.getJsfSupport().getIndex());
        }
        catch (LibraryDescriptorException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void setComponents(Collection<FaceletsLibrary.NamedComponent> components) {
        this.components.addAll(components);
    }

    @Override
    public URL getLibraryDescriptorSource() {
        return this.libraryDescriptorSource;
    }

    public LibraryType getType() {
        return LibraryType.CLASS;
    }

    public String getDefaultNamespace() {
        return null;
    }

    @Override
    public String getDefaultPrefix() {
        String superdefaultPrefix = super.getDefaultPrefix();
        return superdefaultPrefix != null ? superdefaultPrefix : this.defaultPrefix;
    }

    public Collection<FaceletsLibrary.NamedComponent> getComponents() {
        return Collections.unmodifiableCollection(this.components);
    }

    @Override
    public LibraryDescriptor getLibraryDescriptor() {
        return this.libraryDescriptor;
    }

    public void putConverter(String name, String id) {
        this.components.add(new FaceletsLibrary.Converter(this, name, id, null));
    }

    public void putConverter(String name, String id, Class handlerClass) {
        this.components.add(new FaceletsLibrary.Converter(this, name, id, handlerClass));
    }

    public void putValidator(String name, String id) {
        this.components.add(new FaceletsLibrary.Validator(this, name, id, null));
    }

    public void putValidator(String name, String id, Class handlerClass) {
        this.components.add(new FaceletsLibrary.Validator(this, name, id, handlerClass));
    }

    public void putBehavior(String name, String id) {
        this.components.add(new FaceletsLibrary.Behavior(this, name, id, null));
    }

    public void putBehavior(String name, String id, Class handlerClass) {
        this.components.add(new FaceletsLibrary.Behavior(this, name, id, handlerClass));
    }

    public void putTagHandler(String name, Class type) {
        this.components.add(new FaceletsLibrary.TagHandler(this, name, type));
    }

    public void putComponent(String name, String componentType, String rendererType) {
        this.components.add(new FaceletsLibrary.Component(this, name, componentType, rendererType, null));
    }

    public void putComponent(String name, String componentType, String rendererType, Class handlerClass) {
        this.components.add(new FaceletsLibrary.Component(this, name, componentType, rendererType, handlerClass));
    }

    public void putUserTag(String name, URL source) {
        this.components.add(new FaceletsLibrary.UserTag(this, name, source));
    }

    public void putFunction(String name, Method method) {
        this.components.add(new FaceletsLibrary.Function(this, name, method));
    }

    public FaceletsLibrary.NamedComponent createNamedComponent(String name) {
        return new FaceletsLibrary.NamedComponent(this, name);
    }

    public FaceletsLibrary.Function createFunction(String name, Method method) {
        return new FaceletsLibrary.Function(this, name, method);
    }

    private String generateDefaultPrefix() {
        String ns = this.getNamespace();
        String HTTP_PREFIX = "http://";
        if (ns.startsWith("http://")) {
            ns = ns.substring("http://".length());
        }
        StringTokenizer st = new StringTokenizer(ns, "/.");
        LinkedList<String> tokens = new LinkedList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.length() <= 0) continue;
            tokens.add(token);
        }
        if (tokens.isEmpty()) {
            return "lib";
        }
        if (tokens.size() == 1) {
            return (String)tokens.iterator().next();
        }
        StringBuilder buf = new StringBuilder();
        for (String token : tokens) {
            buf.append(token.charAt(0));
        }
        return buf.toString();
    }
}

