/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTBuilder;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;

public class APTDriverImpl {
    private final ConcurrentHashMap<CharSequence, APTSyncCreator> file2creator = new ConcurrentHashMap();
    private Map<CharSequence, Reference<APTFile>> file2ref2apt = new ConcurrentHashMap<CharSequence, Reference<APTFile>>();
    private Map<CharSequence, APTFile> file2apt = new ConcurrentHashMap<CharSequence, APTFile>();

    public APTFile findAPT(APTFileBuffer buffer, boolean withTokens, String lang) throws IOException {
        CharSequence path = buffer.getAbsolutePath();
        APTFile apt = this._getAPTFile(path, withTokens);
        if (apt == null) {
            APTSyncCreator old;
            APTSyncCreator creator = this.file2creator.get(path);
            if (creator == null && (old = this.file2creator.putIfAbsent(path, creator = new APTSyncCreator())) != null) {
                creator = old;
            }
            assert (creator != null);
            apt = creator.findAPT(buffer, withTokens, lang);
            this.file2creator.remove(path);
        }
        return apt;
    }

    public void invalidateAPT(APTFileBuffer buffer) {
        CharSequence path = buffer.getAbsolutePath();
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            this.file2ref2apt.remove(path);
        } else {
            this.file2apt.remove(path);
        }
    }

    public void invalidateAll() {
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            this.file2ref2apt.clear();
        } else {
            this.file2apt.clear();
        }
    }

    private APTFile _getAPTFile(CharSequence path, boolean withTokens) {
        Reference<APTFile> aptRef;
        if (withTokens) {
            return null;
        }
        APTFile apt = APTTraceFlags.APT_USE_SOFT_REFERENCE ? ((aptRef = this.file2ref2apt.get(path)) == null ? null : aptRef.get()) : this.file2apt.get(path);
        return apt;
    }

    private void _putAPTFile(CharSequence path, APTFile apt, boolean withTokens) {
        if (withTokens) {
            return;
        }
        if (APTTraceFlags.APT_USE_SOFT_REFERENCE) {
            this.file2ref2apt.put(path, new SoftReference<APTFile>(apt));
        } else {
            this.file2apt.put(path, apt);
        }
    }

    public void close() {
        this.invalidateAll();
    }

    private class APTSyncCreator {
        private APTFile fullAPT = null;
        private APTFile lightAPT = null;

        private TokenStream getTokenStream(APTFileBuffer buffer, String lang, boolean isLight) throws IOException {
            if (isLight) {
                return APTTokenStreamBuilder.buildLightTokenStream((CharSequence)((Object)buffer.getAbsolutePath()).toString(), buffer.getCharBuffer(), lang);
            }
            return APTTokenStreamBuilder.buildTokenStream((CharSequence)((Object)buffer.getAbsolutePath()).toString(), buffer.getCharBuffer(), lang);
        }

        public synchronized APTFile findAPT(APTFileBuffer buffer, boolean withTokens, String lang) throws IOException {
            CharSequence path = buffer.getAbsolutePath();
            if (withTokens && this.fullAPT != null) {
                return this.fullAPT;
            }
            if (!withTokens && this.lightAPT != null) {
                return this.lightAPT;
            }
            APTFile apt = APTDriverImpl.this._getAPTFile(path, withTokens);
            if (apt == null) {
                TokenStream ts = this.getTokenStream(buffer, lang, !withTokens);
                apt = APTBuilder.buildAPT(buffer.getFileSystem(), path, ts);
                if (!withTokens) {
                    this.fullAPT = null;
                    if (apt != null) {
                        if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                            APTFile test = (APTFile)APTSerializeUtils.testAPTSerialization(buffer, apt);
                            if (test != null) {
                                apt = test;
                            } else {
                                System.err.println("error on serialization apt for file " + path);
                            }
                        }
                        this.lightAPT = apt;
                        APTDriverImpl.this._putAPTFile(path, this.lightAPT, false);
                    }
                } else {
                    this.fullAPT = apt;
                    if (apt != null) {
                        if (APTTraceFlags.TEST_APT_SERIALIZATION) {
                            APTFile test = (APTFile)APTSerializeUtils.testAPTSerialization(buffer, apt);
                            if (test != null) {
                                apt = test;
                            } else {
                                System.err.println("error on serialization apt for file " + path);
                            }
                        }
                        APTDriverImpl.this._putAPTFile(path, this.fullAPT, true);
                        this.lightAPT = (APTFile)APTBuilder.buildAPTLight(apt);
                        APTDriverImpl.this._putAPTFile(path, this.lightAPT, false);
                    }
                }
            }
            return apt;
        }
    }
}

