/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.loader;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javacard.ri.platform.RIPlatform;
import org.netbeans.modules.javacard.ri.platform.installer.RIPlatformFactory;
import org.netbeans.modules.javacard.ri.platform.installer.ServersPanel;
import org.netbeans.modules.javacard.ri.platform.loader.AddHandler;
import org.netbeans.modules.javacard.ri.platform.loader.PlatformCustomizerPanel;
import org.netbeans.modules.javacard.spi.DeviceManagerDialogProvider;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.propdos.ObservableProperties;
import org.netbeans.modules.propdos.PropertiesBasedDataObject;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class JavacardPlatformDataObject
extends PropertiesBasedDataObject<JavacardPlatform>
implements DeviceManagerDialogProvider {
    private static final String ICON_BASE = "org/netbeans/modules/javacard/ri/platform/ri.png";

    public JavacardPlatformDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader, JavacardPlatform.class);
    }

    protected Node createNodeDelegate() {
        return new ND(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDelete(FileObject parentFolder) throws Exception {
        JavacardPlatform pform = (JavacardPlatform)this.getLookup().lookup(JavacardPlatform.class);
        try {
            pform.onDelete();
        }
        catch (Throwable throwable) {
            EditableProperties props = PropertyUtils.getGlobalProperties();
            props.remove((Object)("jcplatform." + this.getName()));
            props.remove((Object)("jcplatform." + this.getName() + ".devicespath"));
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(props){
                final /* synthetic */ EditableProperties val$props;
                {
                    this.val$props = editableProperties;
                }

                public Void run() throws Exception {
                    PropertyUtils.putGlobalProperties((EditableProperties)this.val$props);
                    return null;
                }
            });
            throw throwable;
        }
        EditableProperties props = PropertyUtils.getGlobalProperties();
        props.remove((Object)("jcplatform." + this.getName()));
        props.remove((Object)("jcplatform." + this.getName() + ".devicespath"));
        ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new /* invalid duplicate definition of identical inner class */);
    }

    protected JavacardPlatform createFrom(ObservableProperties properties) {
        String old = properties.getProperty("javacard.instance.id");
        boolean idPropMatch = this.getName().equals(old);
        boolean empty = properties.isEmpty();
        if (!idPropMatch) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "javacard.instance.id in " + this.getPrimaryFile().getPath() + " was set to " + old + " - resetting to default, triggering save");
            }
            properties.setProperty("javacard.instance.id", this.getName());
        }
        if (empty) {
            return JavacardPlatform.createBrokenJavacardPlatform((String)this.getName());
        }
        try {
            RIPlatform result = RIPlatformFactory.createPlatform(properties, (DataObject)this);
            return result;
        }
        catch (IOException ioe) {
            return JavacardPlatform.createBrokenJavacardPlatform((String)this.getName());
        }
    }

    public void showManageDevicesDialog(Component parent) {
        new ServersPanel((JavacardPlatform)this.getLookup().lookup(JavacardPlatform.class)).showDialog();
    }

    private static final class ND
    extends DataNode {
        ND(JavacardPlatformDataObject ob) {
            super((DataObject)ob, Children.LEAF, ob.getLookup());
            this.setIconBaseWithExtension(JavacardPlatformDataObject.ICON_BASE);
        }

        public String getDisplayName() {
            JavacardPlatform platform = (JavacardPlatform)this.getLookup().lookup(JavacardPlatform.class);
            return platform == null ? super.getDisplayName() : platform.getDisplayName();
        }

        public String getHtmlDisplayName() {
            JavacardPlatform platform = (JavacardPlatform)this.getLookup().lookup(JavacardPlatform.class);
            if (!platform.isValid()) {
                return "<font color='!nb.errorForeground'>" + NbBundle.getMessage(JavacardPlatformDataObject.class, (String)"MSG_INVALID_PLATFORM", (Object)platform.getDisplayName());
            }
            return null;
        }

        public Action[] getActions(boolean ignored) {
            Action[] supers = super.getActions(ignored);
            JavacardPlatform p = (JavacardPlatform)this.getLookup().lookup(JavacardPlatform.class);
            if (p != null) {
                Action[] result = new Action[supers.length + 1];
                System.arraycopy(supers, 0, result, 1, supers.length);
                result[0] = AddHandler.createAddDeviceAction((DataObject)this.getDataObject(), (JavacardPlatform)p, null);
                return result;
            }
            return supers;
        }

        protected Sheet createSheet() {
            Sheet sheet = super.createSheet();
            Sheet.Set set = new Sheet.Set();
            set.setName(NbBundle.getMessage(JavacardPlatformDataObject.class, (String)"PROPERTY_SET_CLASSPATH"));
            set.put((Node.Property)new CPProp(ProjectKind.CLASSIC_APPLET));
            set.put((Node.Property)new CPProp(ProjectKind.EXTENDED_APPLET));
            JavacardPlatform pl = (JavacardPlatform)this.getLookup().lookup(JavacardPlatform.class);
            try {
                PropertySupport.Reflection isValid = new PropertySupport.Reflection((Object)pl, Boolean.class, "isValid", null);
                isValid.setName("isValid");
                isValid.setDisplayName(NbBundle.getMessage(JavacardPlatformDataObject.class, (String)"PROP_IS_VALID"));
                set.put((Node.Property)isValid);
                PropertySupport.Reflection kindProp = new PropertySupport.Reflection((Object)pl, String.class, "getPlatformKind", null);
                kindProp.setName("kind");
                kindProp.setDisplayName(NbBundle.getMessage(JavacardPlatformDataObject.class, (String)"PROP_KIND"));
                set.put((Node.Property)kindProp);
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            sheet.put(set);
            set.setDisplayName(set.getName());
            PropertiesBasedDataObject ob = (PropertiesBasedDataObject)this.getLookup().lookup(PropertiesBasedDataObject.class);
            sheet.put(ob.getPropertiesAsPropertySet());
            return sheet;
        }

        private static String propNameForKind(ProjectKind kind) {
            switch (kind) {
                case CLASSIC_APPLET: 
                case CLASSIC_LIBRARY: {
                    return NbBundle.getMessage(JavacardPlatformDataObject.class, (String)"PROP_NAME_CLASSIC_CLASSPATH");
                }
            }
            return NbBundle.getMessage(JavacardPlatformDataObject.class, (String)"PROP_NAME_EXT_CLASSPATH");
        }

        public Image getIcon(int ignored) {
            return ImageUtilities.loadImage((String)JavacardPlatformDataObject.ICON_BASE);
        }

        public Image getOpenedIcon(int kind) {
            return this.getIcon(kind);
        }

        public boolean hasCustomizer() {
            return true;
        }

        public Component getCustomizer() {
            PlatformCustomizerPanel result = new PlatformCustomizerPanel((JavacardPlatformDataObject)((Object)this.getLookup().lookup(JavacardPlatformDataObject.class)));
            int i = (Utilities.getOperatingSystem() & 0x1000) == 0 ? 12 : 5;
            result.setBorder(BorderFactory.createEmptyBorder(i, i, i, i));
            return result;
        }

        private final class CPProp
        extends PropertySupport.ReadOnly<String> {
            private final ProjectKind kind;

            CPProp(ProjectKind kind) {
                super(ND.propNameForKind(kind), String.class, ND.propNameForKind(kind), null);
                this.kind = kind;
            }

            public String getValue() throws IllegalAccessException, InvocationTargetException {
                JavacardPlatform p = (JavacardPlatform)ND.this.getLookup().lookup(JavacardPlatform.class);
                ClassPath cp = p.getBootstrapLibraries(this.kind);
                StringBuilder sb = new StringBuilder();
                for (FileObject fo : cp.getRoots()) {
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparator);
                    }
                    sb.append(fo.getPath());
                }
                return sb.toString();
            }
        }
    }
}

