/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.sps.impl;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.security.acl.NotOwnerException;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.api.extexecution.input.LineProcessor;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ShellScriptRunner;
import org.netbeans.modules.nativeexecution.sps.impl.SPSCommonImpl;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public final class SPSRemoteImpl
extends SPSCommonImpl {
    private final ExecutionEnvironment execEnv;
    private String pid = null;

    private SPSRemoteImpl(ExecutionEnvironment execEnv) {
        super(execEnv);
        this.execEnv = execEnv;
    }

    public static SPSCommonImpl getNewInstance(ExecutionEnvironment execEnv) {
        return new SPSRemoteImpl(execEnv);
    }

    @Override
    synchronized String getPID() {
        if (this.pid != null) {
            return this.pid;
        }
        ShellScriptRunner.BufferedLineProcessor blp = new ShellScriptRunner.BufferedLineProcessor();
        ShellScriptRunner scriptRunner = new ShellScriptRunner(this.execEnv, "/bin/ptree $$", (LineProcessor)blp);
        try {
            if (scriptRunner.execute() != 0) {
                throw new IOException("Unable to get sshd pid");
            }
        }
        catch (IOException ex) {
            Logger.getInstance().fine(ex.toString());
        }
        String pidCandidate = null;
        for (String line : blp.getBuffer()) {
            if (!(line = line.trim()).endsWith("sshd")) continue;
            try {
                pidCandidate = line.substring(0, line.indexOf(32));
            }
            catch (NumberFormatException ex) {}
        }
        this.pid = pidCandidate;
        return this.pid;
    }

    @Override
    public synchronized void invalidate() {
        super.invalidate();
        this.pid = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean requestPrivileges(Collection<String> requestedPrivileges, String user, char[] passwd) throws NotOwnerException, InterruptedException {
        StringBuilder sb = new StringBuilder();
        for (String priv : requestedPrivileges) {
            sb.append(priv).append(",");
        }
        String requestedPrivs = sb.toString();
        OutputStream out = null;
        InputStream in = null;
        String script = "/usr/bin/ppriv -s I+" + requestedPrivs + " " + this.getPID();
        StringBuilder cmd = new StringBuilder("/sbin/su - ");
        cmd.append(user).append(" -c \"");
        cmd.append(script).append("\"; echo ExitStatus:$?\n");
        ChannelShell channel = null;
        PrintWriter w = null;
        int status = 1;
        try {
            channel = (ChannelShell)ConnectionManagerAccessor.getDefault().openAndAcquireChannel(this.execEnv, "shell", true);
            if (channel == null) {
                boolean bl = false;
                return bl;
            }
            channel.setPty(true);
            channel.setPtyType("ldterm");
            out = channel.getOutputStream();
            in = channel.getInputStream();
            channel.connect();
            w = new PrintWriter(out);
            w.write(cmd.toString());
            w.flush();
            SPSRemoteImpl.expect(in, "Password:");
            w.println(passwd);
            w.flush();
            String exitStatus = SPSRemoteImpl.expect(in, "ExitStatus:%");
            status = Integer.valueOf(exitStatus);
            boolean bl = status == 0;
            return bl;
        }
        catch (InterruptedIOException ex) {
            throw new CancellationException();
        }
        catch (IOException ex) {
            Logger.getInstance().log(Level.FINE, "", ex);
        }
        catch (JSchException ex) {
            Logger.getInstance().log(Level.FINE, "", ex);
        }
        finally {
            if (status != 0 && !Boolean.getBoolean("nativeexecution.mode.unittest")) {
                NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(SPSRemoteImpl.class, (String)"TaskPrivilegesSupport_GrantPrivileges_Failed"));
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getInstance().log(Level.FINE, "", ex);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getInstance().log(Level.FINE, "", ex);
                }
            }
            if (w != null) {
                w.close();
            }
        }
        return false;
    }

    private static String expect(InputStream in, String expectedString) throws IOException {
        int pos = 0;
        int len = expectedString.length();
        char[] cbuf = new char[2];
        StringBuilder sb = new StringBuilder();
        InputStreamReader r = new InputStreamReader(in);
        while (pos != len && ((Reader)r).read(cbuf, 0, 1) != -1) {
            char currentChar = expectedString.charAt(pos);
            if (currentChar == '%') {
                ++pos;
                sb.append(cbuf[0]);
                continue;
            }
            if (currentChar == cbuf[0]) {
                ++pos;
                continue;
            }
            pos = 0;
        }
        return sb.toString();
    }
}

