/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.InstalledFileLocatorProvider;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;

public class UnbufferSupport {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final boolean UNBUFFER_DISABLED = Boolean.getBoolean("execution.no_unbuffer");
    private static final HashMap<ExecutionEnvironment, String> cache = new HashMap();

    private UnbufferSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initUnbuffer(ExecutionEnvironment execEnv, MacroMap env) throws IOException {
        boolean isMacOS;
        if (UNBUFFER_DISABLED) {
            return;
        }
        HostInfo hinfo = HostInfoUtils.getHostInfo(execEnv);
        boolean bl = isMacOS = hinfo.getOSFamily() == HostInfo.OSFamily.MACOSX;
        if (isMacOS) {
            return;
        }
        boolean isWindows = hinfo.getOSFamily() == HostInfo.OSFamily.WINDOWS;
        MacroExpanderFactory.MacroExpander macroExpander = MacroExpanderFactory.getExpander(execEnv);
        String unbufferPath = null;
        String unbufferLib = null;
        try {
            unbufferPath = macroExpander.expandPredefinedMacros("bin/nativeexecution/$osname-$platform");
            unbufferLib = macroExpander.expandPredefinedMacros("unbuffer.$soext");
        }
        catch (ParseException ex) {
            // empty catch block
        }
        if (unbufferLib != null && unbufferPath != null) {
            InstalledFileLocator fl = InstalledFileLocatorProvider.getDefault();
            File file = fl.locate(unbufferPath + "/" + unbufferLib, "org.netbeans.modules.dlight.nativeexecution", false);
            log.fine("Look for unbuffer library here: " + unbufferPath + "/" + unbufferLib);
            if (file != null && file.exists()) {
                String ldPreloadEnv;
                String ldLibraryPathEnv;
                if (execEnv.isRemote()) {
                    String remotePath = null;
                    HashMap<ExecutionEnvironment, String> hashMap = cache;
                    synchronized (hashMap) {
                        remotePath = cache.get(execEnv);
                        if (remotePath == null) {
                            remotePath = hinfo.getTempDir() + "/" + unbufferPath;
                            NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(execEnv);
                            npb.setExecutable("/bin/mkdir").setArguments("-p", remotePath, remotePath + "_64");
                            try {
                                npb.call().waitFor();
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            try {
                                String remoteLib_32 = remotePath + "/" + unbufferLib;
                                String remoteLib_64 = remotePath + "_64/" + unbufferLib;
                                String fullLocalPath = file.getParentFile().getAbsolutePath();
                                Future<Integer> copyTask = CommonTasksSupport.uploadFile(fullLocalPath + "/" + unbufferLib, execEnv, remoteLib_32, 493, null, true);
                                copyTask.get();
                                copyTask = CommonTasksSupport.uploadFile(fullLocalPath + "_64/" + unbufferLib, execEnv, remoteLib_64, 493, null, true);
                                copyTask.get();
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (ExecutionException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            cache.put(execEnv, remotePath);
                        }
                    }
                    unbufferPath = remotePath;
                } else {
                    unbufferPath = new File(file.getParent()).getAbsolutePath();
                }
                if (isWindows) {
                    ldLibraryPathEnv = "PATH";
                    ldPreloadEnv = "LD_PRELOAD";
                } else if (isMacOS) {
                    ldLibraryPathEnv = "DYLD_LIBRARY_PATH";
                    ldPreloadEnv = "DYLD_INSERT_LIBRARIES";
                } else {
                    ldLibraryPathEnv = "LD_LIBRARY_PATH";
                    ldPreloadEnv = "LD_PRELOAD";
                }
                String ldPreload = env.get(ldPreloadEnv);
                if (isWindows) {
                    ldPreload = (ldPreload == null ? "" : ldPreload + ";") + new File(unbufferPath, unbufferLib).getAbsolutePath();
                    ldPreload = WindowsSupport.getInstance().convertToAllShellPaths(ldPreload);
                    if (ldPreload == null) {
                        return;
                    }
                } else {
                    ldPreload = isMacOS ? (ldPreload == null ? "" : ldPreload + ":") + unbufferPath + "/" + unbufferLib : (ldPreload == null ? "" : ldPreload + ":") + unbufferLib;
                }
                env.put(ldPreloadEnv, ldPreload);
                if (isMacOS) {
                    env.put("DYLD_FORCE_FLAT_NAMESPACE", "yes");
                } else if (!isWindows) {
                    String ldLibPath = env.get(ldLibraryPathEnv);
                    ldLibPath = (ldLibPath == null ? "" : ldLibPath + ":") + unbufferPath + ":" + unbufferPath + "_64";
                    env.put(ldLibraryPathEnv, ldLibPath);
                }
            }
        }
    }
}

