/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.LocalNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.RemoteNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.pty.Pty;
import org.netbeans.modules.nativeexecution.api.pty.PtySupport;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.pty.PtyUtility;

public final class PtyNativeProcess
extends AbstractNativeProcess {
    private static final Boolean fixEraseKeyInTerminal = Boolean.valueOf(System.getProperty("fixEraseKeyInTerminal", "true"));
    private String tty;
    private AbstractNativeProcess delegate = null;

    public PtyNativeProcess(NativeProcessInfo info) {
        super(info);
    }

    public String getTTY() {
        return this.tty;
    }

    @Override
    protected void create() throws Throwable {
        ExecutionEnvironment env = this.info.getExecutionEnvironment();
        Pty pty = this.info.getPty();
        String executable = PtyUtility.getInstance().getPath(env);
        ArrayList<String> newArgs = new ArrayList<String>();
        if (pty != null) {
            newArgs.add("-p");
            newArgs.add(pty.getSlaveName());
        }
        String processExecutable = this.info.getExecutable();
        if (this.hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
            processExecutable = WindowsSupport.getInstance().convertToShellPath(processExecutable);
        }
        this.info.setExecutable(executable);
        MacroMap envMap = this.info.getEnvironment();
        HashMap<String, String> removedEntries = new HashMap<String, String>();
        removedEntries.put("LD_PRELOAD", envMap.remove("LD_PRELOAD"));
        removedEntries.put("LD_PRELOAD_32", envMap.remove("LD_PRELOAD_32"));
        removedEntries.put("LD_PRELOAD_64", envMap.remove("LD_PRELOAD_64"));
        removedEntries.put("DYLD_INSERT_LIBRARIES", envMap.remove("DYLD_INSERT_LIBRARIES"));
        Iterator it = removedEntries.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() == null) {
                it.remove();
                continue;
            }
            if (((String)entry.getValue()).isEmpty()) continue;
            newArgs.add("--env");
            newArgs.add(((String)entry.getKey()).trim() + "=" + ((String)entry.getValue()).trim());
        }
        newArgs.add(processExecutable);
        newArgs.addAll(this.info.getArguments());
        this.info.setArguments(newArgs.toArray(new String[0]));
        this.info.setUnbuffer(false);
        if (this.info.getListeners() != null) {
            this.info.getListeners().clear();
        }
        this.delegate = env.isLocal() ? new LocalNativeProcess(this.info) : new RemoteNativeProcess(this.info);
        this.delegate.createAndStart();
        envMap.putAll(removedEntries);
        if (pty != null) {
            this.setInputStream(pty.getInputStream());
            this.setOutputStream(pty.getOutputStream());
        } else {
            this.setInputStream(this.delegate.getInputStream());
            this.setOutputStream(this.delegate.getOutputStream());
        }
        this.setErrorStream(this.delegate.getErrorStream());
        String pidLine = null;
        String ttyLine = null;
        String line = this.readLine(this.delegate.getInputStream());
        if (line != null && line.startsWith("PID=")) {
            pidLine = line.substring(4);
        }
        if ((line = this.readLine(this.delegate.getInputStream())) != null && line.startsWith("TTY=")) {
            ttyLine = line.substring(4);
        }
        if (pidLine == null || ttyLine == null) {
            String error = ProcessUtils.readProcessErrorLine(this);
            throw new IOException("Unable to start pty process: " + error);
        }
        this.tty = ttyLine;
        ByteArrayInputStream bis = new ByteArrayInputStream(pidLine.getBytes());
        this.readPID(bis);
        if (fixEraseKeyInTerminal.booleanValue()) {
            PtySupport.setBackspaceAsEraseChar(env, this.tty);
        }
    }

    @Override
    protected int waitResult() throws InterruptedException {
        if (this.delegate == null) {
            return 1;
        }
        int result = this.delegate.waitResult();
        return result;
    }

    private String readLine(InputStream is) throws IOException {
        int c = -1;
        StringBuilder sb = new StringBuilder(20);
        while (!this.isInterrupted() && (c = is.read()) >= 0 && c != 10) {
            sb.append((char)c);
        }
        return sb.toString().trim();
    }
}

