/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.core.dev.wizard.PortChooser;
import org.netbeans.modules.websvc.core.dev.wizard.WsdlServiceHandler;
import org.netbeans.modules.websvc.core.dev.wizard.nodes.WsdlNode;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.api.WebServiceData;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXException;

public class WebServiceFromWSDLPanel
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static String previousDirectory = "";
    private final FileFilter WSDL_FILE_FILTER = new WsdlFileFilter();
    private boolean isWaitingForScan = false;
    private WsdlModeler wsdlModeler;
    private WsdlModel wsdlModel;
    private WsdlService service;
    private WsdlPort port;
    private WsdlServiceHandler wsdlServiceHandler;
    private Project project;
    private WizardDescriptor wizardDescriptor;
    private JAXWSSupport wss;
    private boolean jsr109Supported;
    private boolean jsr109oldSupported;
    private boolean jaxWsInJ2ee14Supported;
    private WebModule wm;
    private RequestProcessor.Task generateWsdlModelTask;
    private URL wsdlURL;
    private WsdlWrapperHandler wsdlHandler;
    private WSStackUtils wsStackUtils;
    private JButton jButtonBrowsePort;
    private JButton jButtonWSDLFileBrowse;
    private JLabel jLabelPort;
    private JLabel jLabelPortDescription;
    private JLabel jLabelWSDLFile;
    private JTextField jTextFieldPort;
    private JTextField jTextFieldWSDLFile;
    private JCheckBox sessionBeanCB;
    private JCheckBox useProviderBtn;

    public WebServiceFromWSDLPanel(Project project) {
        this.project = project;
        this.initComponents();
        this.initJsr109Info();
        this.jTextFieldWSDLFile.getDocument().addDocumentListener(this);
        if (this.supportsJaxrpc()) {
            this.useProviderBtn.setVisible(false);
        }
        if (JaxWsUtils.isEjbJavaEE5orHigher(project)) {
            this.sessionBeanCB.setSelected(true);
            this.sessionBeanCB.setEnabled(false);
        } else if (WebServiceFromWSDLPanel.isEjbInWebSupported(project)) {
            this.sessionBeanCB.setEnabled(true);
        } else {
            this.sessionBeanCB.setEnabled(false);
        }
        this.generateWsdlModelTask = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                Object object;
                WsdlWrapperHandler wsdlWrapperHandler = null;
                try {
                    wsdlWrapperHandler = WsdlWrapperGenerator.parse((String)WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    ErrorManager.getDefault().notify(1, (Throwable)parserConfigurationException);
                }
                catch (SAXException sAXException) {
                    object = NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_SAXException", (Object)sAXException.getLocalizedMessage());
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message(object, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    ErrorManager.getDefault().notify(1, (Throwable)sAXException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                if (wsdlWrapperHandler != null && !wsdlWrapperHandler.isServiceElement()) {
                    StreamSource streamSource = new StreamSource(WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                    try {
                        object = new File(System.getProperty("java.io.tmpdir"), WsdlWrapperGenerator.getWrapperName((URL)WebServiceFromWSDLPanel.this.wsdlURL));
                        object = ((File)object).getCanonicalFile();
                        if (!((File)object).exists()) {
                            try {
                                ((File)object).createNewFile();
                                ((File)object).deleteOnExit();
                            }
                            catch (IOException iOException) {
                                String string = NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_UnableToCreateTempFile", (Object)((File)object).getPath());
                                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                                return;
                            }
                        }
                        WsdlWrapperGenerator.generateWrapperWSDLContent((File)object, (StreamSource)streamSource, (String)wsdlWrapperHandler.getTargetNsPrefix(), (String)WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                        WebServiceFromWSDLPanel.this.wsdlURL = ((File)object).toURI().toURL();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
                WebServiceFromWSDLPanel.this.wsdlHandler = wsdlWrapperHandler;
                WebServiceFromWSDLPanel.this.wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(WebServiceFromWSDLPanel.this.wsdlURL);
                WebServiceFromWSDLPanel.this.wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel wsdlModel) {
                        Object object;
                        WebServiceFromWSDLPanel.this.wsdlModel = wsdlModel;
                        if (WebServiceFromWSDLPanel.this.wsdlModel == null) {
                            object = null;
                            String string = null;
                            try {
                                WebServiceFromWSDLPanel.this.wsdlServiceHandler = WsdlServiceHandler.parse(WebServiceFromWSDLPanel.this.wsdlURL.toExternalForm());
                                object = WebServiceFromWSDLPanel.this.wsdlServiceHandler.getServiceName();
                                string = WebServiceFromWSDLPanel.this.wsdlServiceHandler.getPortName();
                            }
                            catch (ParserConfigurationException parserConfigurationException) {
                            }
                            catch (SAXException sAXException) {
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            if (object != null && string != null) {
                                WebServiceFromWSDLPanel.this.jTextFieldPort.setText((String)object + "#" + string);
                            } else {
                                RequestProcessor.getDefault().post(new Runnable(){

                                    @Override
                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TXT_CannotGenerateService", (Object)WebServiceFromWSDLPanel.this.wsdlModeler.getCreationException().getLocalizedMessage()), 2));
                                    }
                                });
                            }
                        } else {
                            WebServiceFromWSDLPanel.this.jButtonBrowsePort.setEnabled(true);
                            object = WebServiceFromWSDLPanel.this.wsdlModel.getServices();
                            if (object != null && object.size() > 0) {
                                WebServiceFromWSDLPanel.this.service = (WsdlService)object.get(0);
                                List list = WebServiceFromWSDLPanel.this.service.getPorts();
                                if (list != null && list.size() > 0) {
                                    WebServiceFromWSDLPanel.this.port = (WsdlPort)list.get(0);
                                }
                            }
                        }
                        if (WebServiceFromWSDLPanel.this.service != null && WebServiceFromWSDLPanel.this.port != null) {
                            WebServiceFromWSDLPanel.this.jTextFieldPort.setText(WebServiceFromWSDLPanel.this.service.getName() + "#" + WebServiceFromWSDLPanel.this.port.getName());
                            if (WebServiceFromWSDLPanel.this.wsdlHandler != null && (object = WebServiceFromWSDLPanel.this.wsdlHandler.getBindingTypeForPort(WebServiceFromWSDLPanel.this.port.getName())) != null) {
                                WebServiceFromWSDLPanel.this.port.setSOAPVersion((String)object);
                            }
                        }
                        WebServiceFromWSDLPanel.this.fireChange();
                    }
                });
            }
        });
    }

    private void initComponents() {
        this.jLabelWSDLFile = new JLabel();
        this.jTextFieldWSDLFile = new JTextField();
        this.jButtonWSDLFileBrowse = new JButton();
        this.jLabelPortDescription = new JLabel();
        this.jLabelPort = new JLabel();
        this.jTextFieldPort = new JTextField();
        this.jButtonBrowsePort = new JButton();
        this.useProviderBtn = new JCheckBox();
        this.sessionBeanCB = new JCheckBox();
        this.jLabelWSDLFile.setLabelFor(this.jTextFieldWSDLFile);
        Mnemonics.setLocalizedText((JLabel)this.jLabelWSDLFile, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WSDL_File"));
        this.jLabelWSDLFile.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"HINT_WSDL_File"));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonWSDLFileBrowse, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_Browse"));
        this.jButtonWSDLFileBrowse.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"HINT_WSDL_File"));
        this.jButtonWSDLFileBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebServiceFromWSDLPanel.this.jButtonWSDLFileBrowseActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabelPortDescription, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_PortMessage"));
        this.jLabelPort.setLabelFor(this.jTextFieldPort);
        Mnemonics.setLocalizedText((JLabel)this.jLabelPort, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_WebServicePort"));
        this.jLabelPort.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        this.jTextFieldPort.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBrowsePort, (String)NbBundle.getBundle(WebServiceFromWSDLPanel.class).getString("LBL_BrowsePort"));
        this.jButtonBrowsePort.setToolTipText(NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        this.jButtonBrowsePort.setEnabled(false);
        this.jButtonBrowsePort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WebServiceFromWSDLPanel.this.jButtonBrowsePortActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.useProviderBtn, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_UseProvider"));
        Mnemonics.setLocalizedText((AbstractButton)this.sessionBeanCB, (String)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WsAsSessionBean"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabelWSDLFile).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jTextFieldWSDLFile, -1, 766, Short.MAX_VALUE).add((Component)this.jLabelPortDescription, -1, 766, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelPort).addPreferredGap(0).add((Component)this.jTextFieldPort, -1, 640, Short.MAX_VALUE))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add(2, (Component)this.jButtonWSDLFileBrowse, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jButtonBrowsePort, -1, 141, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.useProviderBtn)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.sessionBeanCB))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabelWSDLFile).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jButtonWSDLFileBrowse).add((Component)this.jTextFieldWSDLFile, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabelPortDescription, -2, 43, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jButtonBrowsePort).add((Component)this.jLabelPort).add((Component)this.jTextFieldPort, -2, -1, -2)).add(57, 57, 57).add((Component)this.useProviderBtn).addPreferredGap(0).add((Component)this.sessionBeanCB, -2, 11, -2).addContainerGap(105, Short.MAX_VALUE)));
        this.jTextFieldWSDLFile.getAccessibleContext().setAccessibleDescription("null");
        this.jButtonWSDLFileBrowse.getAccessibleContext().setAccessibleDescription("null");
        this.jTextFieldPort.getAccessibleContext().setAccessibleDescription("null");
    }

    private void jButtonBrowsePortActionPerformed(ActionEvent actionEvent) {
        WsdlNode wsdlNode = new WsdlNode(this.wsdlModel);
        PortChooser portChooser = new PortChooser((Node)wsdlNode);
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)portChooser, NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"TTL_SelectPort"));
        portChooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (propertyChangeEvent.getPropertyName().equals("portChooser_isValid") && (object = propertyChangeEvent.getNewValue()) != null && object instanceof Boolean) {
                    dialogDescriptor.setValid(((Boolean)object).booleanValue());
                }
            }
        });
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == DialogDescriptor.OK_OPTION) {
            String string;
            if ((Util.isJavaEE5orHigher((Project)this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported) && (string = portChooser.getSelectedPortOwnerName()) != null) {
                String string2;
                this.jTextFieldPort.setText(string + "#" + portChooser.getSelectedNodes()[0].getDisplayName());
                this.service = this.wsdlModel.getServiceByName(string);
                this.port = this.service.getPortByName(portChooser.getSelectedNodes()[0].getDisplayName());
                if (this.wsdlHandler != null && (string2 = this.wsdlHandler.getBindingTypeForPort(this.port.getName())) != null) {
                    this.port.setSOAPVersion(string2);
                }
            }
            this.fireChange();
        }
    }

    private void jButtonWSDLFileBrowseActionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser(previousDirectory);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        jFileChooser.addChoosableFileFilter(this.WSDL_FILE_FILTER);
        jFileChooser.setFileFilter(this.WSDL_FILE_FILTER);
        if (jFileChooser.showOpenDialog(this) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.jTextFieldWSDLFile.setText(file.getAbsolutePath());
            previousDirectory = file.getPath();
        }
    }

    void validate(WizardDescriptor wizardDescriptor) {
    }

    private void initJsr109Info() {
        this.wsStackUtils = new WSStackUtils(this.project);
        this.jsr109Supported = this.wsStackUtils.isJsr109Supported();
        this.jaxWsInJ2ee14Supported = ServerType.JBOSS == this.wsStackUtils.getServerType();
        this.jsr109oldSupported = this.wsStackUtils.isJsr109OldSupported();
        this.wm = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        this.wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
    }

    private boolean projectHasEmbeddedSpaces() {
        FileObject fileObject = this.project.getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        String string = file.getAbsolutePath();
        int n = string.indexOf(" ");
        return n != -1;
    }

    private boolean supportsJaxrpc() {
        boolean bl = this.wm != null && !this.jsr109Supported && !this.jsr109oldSupported;
        boolean bl2 = this.wm != null && this.jaxWsInJ2ee14Supported;
        return !Util.isJavaEE5orHigher((Project)this.project) && !bl && !bl2;
    }

    boolean isValid(WizardDescriptor wizardDescriptor) {
        String string;
        WSStackUtils.ErrorMessage errorMessage = this.wsStackUtils.getErrorMessage(WSStackUtils.WizardType.WS_FROM_WSDL);
        if (errorMessage != null) {
            wizardDescriptor.putProperty(errorMessage.getWizardMessageProperty(), (Object)errorMessage.getText());
            if (errorMessage.isSerious()) {
                return false;
            }
        }
        if ((string = this.jTextFieldWSDLFile.getText().trim()).length() == 0) {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_EnterWsdlName"));
            return false;
        }
        if (!(string.startsWith("http://") || string.startsWith("https://") || string.startsWith("www."))) {
            File file = new File(string);
            if ((file = WebServiceFromWSDLPanel.getCanonicalFile(file)) == null) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_WsdlInvalid"));
                return false;
            }
            if (!file.exists()) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_WsdlDoesNotExist"));
                return false;
            }
        }
        if (Util.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported) {
            if (this.wsdlModel != null) {
                if (this.service == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoService"));
                    return false;
                }
                if (this.port == null) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoPort"));
                    return false;
                }
                if (this.findServiceInProject(this.service.getName(), this.port.getName())) {
                    wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_ServiceNameExists", (Object)this.service.getName(), (Object)this.port.getName()));
                    return false;
                }
            } else {
                if (this.wsdlServiceHandler != null && this.wsdlServiceHandler.getServiceName() != null && this.wsdlServiceHandler.getPortName() != null) {
                    if (this.findServiceInProject(this.wsdlServiceHandler.getServiceName(), this.wsdlServiceHandler.getPortName())) {
                        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"ERR_ServiceNameExists", (Object)this.wsdlServiceHandler.getServiceName(), (Object)this.wsdlServiceHandler.getPortName()));
                        return false;
                    }
                    if (errorMessage != null) {
                        wizardDescriptor.putProperty(errorMessage.getWizardMessageProperty(), (Object)errorMessage.getText());
                    } else {
                        wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
                    }
                    return true;
                }
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_NoPort"));
                return false;
            }
        }
        if (this.projectHasEmbeddedSpaces()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"MSG_SPACE_IN_PROJECT_PATH"));
        } else if (errorMessage != null) {
            wizardDescriptor.putProperty(errorMessage.getWizardMessageProperty(), (Object)errorMessage.getText());
        } else {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)"");
        }
        return true;
    }

    void store(WizardDescriptor wizardDescriptor) {
        String string = this.jTextFieldWSDLFile.getText().trim();
        Boolean bl = this.useProviderBtn.isSelected();
        Boolean bl2 = this.sessionBeanCB.isSelected();
        if (string.startsWith("www.")) {
            string = "http://" + string;
        }
        if (string.startsWith("http://") || string.startsWith("https://")) {
            wizardDescriptor.putProperty("wsdl_url", (Object)string);
        } else {
            wizardDescriptor.putProperty("wsdlFilePath", (Object)string);
        }
        wizardDescriptor.putProperty("wsdlModel", (Object)this.wsdlModel);
        wizardDescriptor.putProperty("wsdlModeler", (Object)this.wsdlModeler);
        wizardDescriptor.putProperty("wsdlService", (Object)this.service);
        wizardDescriptor.putProperty("wsdlPort", (Object)this.port);
        wizardDescriptor.putProperty("wsdlServiceHandler", (Object)this.wsdlServiceHandler);
        wizardDescriptor.putProperty("useProvider", (Object)bl);
        wizardDescriptor.putProperty("endpointAsStatelessBean", (Object)bl2);
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.wizardDescriptor = wizardDescriptor;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(WebServiceFromWSDLPanel.class);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Iterator<ChangeListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().stateChanged(changeEvent);
        }
    }

    private void updatePortBrowseButton() {
        this.wsdlModel = null;
        this.service = null;
        this.port = null;
        this.jTextFieldPort.setText("");
        String string = this.jTextFieldWSDLFile.getText().trim();
        if (string.length() == 0) {
            this.jButtonBrowsePort.setEnabled(false);
        } else {
            if (!(string.startsWith("http://") || string.startsWith("https://") || string.startsWith("www."))) {
                File file = new File(string);
                if ((file = WebServiceFromWSDLPanel.getCanonicalFile(file)) == null) {
                    this.jButtonBrowsePort.setEnabled(false);
                    return;
                }
                if (!file.exists()) {
                    this.jButtonBrowsePort.setEnabled(false);
                    return;
                }
            }
            this.fireChange();
            if (Util.isJavaEE5orHigher((Project)this.project) || JaxWsUtils.isEjbJavaEE5orHigher(this.project) || this.jaxWsInJ2ee14Supported || !this.jsr109Supported && !this.jsr109oldSupported || !this.jsr109Supported && this.jsr109oldSupported) {
                this.createModel();
            }
        }
    }

    private void createModel() {
        String string = this.jTextFieldWSDLFile.getText().trim();
        if (string.startsWith("www.")) {
            string = "http://" + string;
        }
        if (string.startsWith("http://") && string.length() > 7 || string.startsWith("https://") && string.length() > 8) {
            try {
                this.wsdlURL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        } else {
            File file = FileUtil.normalizeFile((File)new File(this.jTextFieldWSDLFile.getText().trim()));
            this.wsdlURL = null;
            try {
                this.wsdlURL = file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                ErrorManager.getDefault().notify((Throwable)malformedURLException);
            }
        }
        this.generateWsdlModelTask.schedule(1000);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updatePortBrowseButton();
        this.fireChange();
    }

    public static File getCanonicalFile(File file) {
        File file2;
        try {
            file2 = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file2 = null;
        }
        return file2;
    }

    private boolean findServiceInProject(String string, String string2) {
        block3: {
            block2: {
                JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
                if (jAXWSSupport == null) break block2;
                for (Object e : jAXWSSupport.getServices()) {
                    Service service = (Service)e;
                    if (service.getWsdlUrl() == null || !string.equals(service.getServiceName()) || !string2.equals(service.getPortName())) continue;
                    return true;
                }
                break block3;
            }
            WebServiceData webServiceData = WebServiceData.getWebServiceData((Project)this.project);
            if (webServiceData == null) break block3;
            List list = webServiceData.getServiceProviders();
            for (WebService webService : list) {
                if (!string.equals(webService.getIdentifier())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isEjbInWebSupported(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            throw new IllegalArgumentException("Passed null to Util.isEjbInWebSupported(Project prj)");
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            J2eeModule.Type type = j2eeModule.getType();
            double d = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.Type.WAR.equals(type) && d >= 3.0) {
                return true;
            }
        }
        return false;
    }

    private static class WsdlFileFilter
    extends FileFilter {
        private WsdlFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string = FileUtil.getExtension((String)file.getName());
            return file.isDirectory() || "wsdl".equalsIgnoreCase(string) || "asmx".equalsIgnoreCase(string);
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(WebServiceFromWSDLPanel.class, (String)"LBL_WsdlFilterDescription");
        }
    }
}

