/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxws.spi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.websvc.api.jaxws.project.JAXWSVersionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOption;
import org.netbeans.modules.websvc.api.jaxws.project.config.WsimportOptions;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperGenerator;
import org.netbeans.modules.websvc.jaxws.api.WsdlWrapperHandler;
import org.netbeans.modules.websvc.jaxws.spi.JAXWSSupportImpl;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public abstract class ProjectJAXWSSupport
implements JAXWSSupportImpl {
    private static final String[] DEFAULT_WSIMPORT_OPTIONS = new String[]{"extension", "verbose"};
    private static final String XNOCOMPILE_OPTION = "xnocompile";
    private static final String XENDORSED_OPTION = "xendorsed";
    private static final String TARGET_OPTION = "target";
    protected static final String JAVA_EE_VERSION_NONE = "java-ee-version-none";
    protected static final String JAVA_EE_VERSION_15 = "java-ee-version-15";
    protected static final String JAVA_EE_VERSION_16 = "java-ee-version-16";
    private Project project;
    private AntProjectHelper antProjectHelper;
    private FileObject serviceArtifactsFolder;

    public ProjectJAXWSSupport(Project project, AntProjectHelper antProjectHelper) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
    }

    @Override
    public void removeService(String string) {
        Service service;
        assert (string != null);
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && string != null && (service = jaxWsModel.findServiceByName(string)) != null) {
            jaxWsModel.removeService(string);
            this.writeJaxWsModel(jaxWsModel);
            WSUtils.removeImplClass((Project)this.project, (String)service.getImplementationClass());
        }
    }

    @Override
    public void serviceFromJavaRemoved(String string) {
    }

    @Override
    public boolean isFromWSDL(String string) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        Service service = jaxWsModel.findServiceByName(string);
        return service != null && service.getWsdlUrl() != null;
    }

    @Override
    public String getServiceImpl(String string) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            Service service = jaxWsModel.findServiceByName(string);
            return service == null ? null : service.getImplementationClass();
        }
        return null;
    }

    @Override
    public AntProjectHelper getAntProjectHelper() {
        return this.antProjectHelper;
    }

    @Override
    public void addService(String string, String string2, boolean bl) {
        if (!bl) {
            try {
                this.addJaxwsArtifacts(this.project, string, string2);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        } else {
            try {
                this.addServletElement(this.project, string, string2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    protected abstract void addJaxwsArtifacts(Project var1, String var2, String var3) throws Exception;

    protected void addServletElement(Project project, String string, String string2) throws IOException {
    }

    @Override
    public String addService(String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null) {
            WsdlWrapperHandler wsdlWrapperHandler;
            FileObject fileObject;
            boolean bl3;
            String string7;
            block39: {
                string7 = WSUtils.findProperServiceName((String)string, (JaxWsModel)jaxWsModel);
                bl3 = false;
                FileObject fileObject2 = null;
                try {
                    WsimportOptions wsimportOptions;
                    File file;
                    Object object;
                    fileObject = this.getLocalWsdlFolderForService(string7, true);
                    fileObject2 = WSUtils.retrieveResource((FileObject)fileObject, (URI)new URI(string3));
                    if (fileObject2 == null) break block39;
                    wsdlWrapperHandler = null;
                    try {
                        wsdlWrapperHandler = WsdlWrapperGenerator.parse(fileObject2.getURL().toExternalForm());
                    }
                    catch (ParserConfigurationException parserConfigurationException) {
                        ErrorManager.getDefault().notify(1, (Throwable)parserConfigurationException);
                    }
                    catch (SAXException sAXException) {
                        ErrorManager.getDefault().notify(1, (Throwable)sAXException);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                    if (!wsdlWrapperHandler.isServiceElement()) {
                        object = new StreamSource(fileObject2.getURL().toExternalForm());
                        try {
                            file = new File(FileUtil.toFile((FileObject)fileObject2.getParent()), WsdlWrapperGenerator.getWrapperName(fileObject2.getURL()));
                            if (!file.exists()) {
                                try {
                                    file.createNewFile();
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                                }
                            }
                            if (file.exists()) {
                                WsdlWrapperGenerator.generateWrapperWSDLContent(file, (StreamSource)object, wsdlWrapperHandler.getTargetNsPrefix(), fileObject2.getNameExt());
                                fileObject2 = FileUtil.toFileObject((File)file);
                            }
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                    if ((object = jaxWsModel.getJsr109()) == null) {
                        jaxWsModel.setJsr109(Boolean.valueOf(bl));
                    } else if (Boolean.TRUE.equals(object) && !bl) {
                        jaxWsModel.setJsr109(Boolean.FALSE);
                    } else if (Boolean.FALSE.equals(object) && bl) {
                        jaxWsModel.setJsr109(Boolean.TRUE);
                    }
                    file = null;
                    try {
                        file = jaxWsModel.addService(string7, string2, string3, string4, string5, string6);
                    }
                    catch (ServiceAlreadyExistsExeption serviceAlreadyExistsExeption) {
                        ErrorManager.getDefault().notify((Throwable)serviceAlreadyExistsExeption);
                    }
                    file.setUseProvider(bl2);
                    String string8 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                    file.setLocalWsdlFile(string8);
                    FileObject fileObject3 = this.getCatalogFileObject();
                    if (fileObject3 != null) {
                        file.setCatalogFile("catalog.xml");
                    }
                    if ((wsimportOptions = file.getWsImportOptions()) != null) {
                        WsimportOption wsimportOption;
                        for (String string9 : DEFAULT_WSIMPORT_OPTIONS) {
                            WsimportOption wsimportOption2 = wsimportOptions.newWsimportOption();
                            wsimportOption2.setWsimportOptionName(string9);
                            wsimportOption2.setWsimportOptionValue("true");
                            wsimportOptions.addWsimportOption(wsimportOption2);
                        }
                        if (ProjectJAXWSSupport.isXnocompile(this.project)) {
                            wsimportOption = wsimportOptions.newWsimportOption();
                            wsimportOption.setWsimportOptionName(XNOCOMPILE_OPTION);
                            wsimportOption.setWsimportOptionValue("true");
                            wsimportOptions.addWsimportOption(wsimportOption);
                        }
                        if (ProjectJAXWSSupport.isXendorsed(this.project)) {
                            wsimportOption = wsimportOptions.newWsimportOption();
                            wsimportOption.setWsimportOptionName(XENDORSED_OPTION);
                            wsimportOption.setWsimportOptionValue("true");
                            wsimportOptions.addWsimportOption(wsimportOption);
                        }
                        if (JAVA_EE_VERSION_15.equals(this.getProjectJavaEEVersion())) {
                            wsimportOption = wsimportOptions.newWsimportOption();
                            wsimportOption.setWsimportOptionName(TARGET_OPTION);
                            wsimportOption.setWsimportOptionValue("2.1");
                            wsimportOptions.addWsimportOption(wsimportOption);
                        }
                    }
                    this.writeJaxWsModel(jaxWsModel);
                    bl3 = true;
                }
                catch (URISyntaxException uRISyntaxException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)uRISyntaxException);
                }
                catch (UnknownHostException unknownHostException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)unknownHostException);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(4096, (Throwable)iOException);
                }
            }
            if (bl3) {
                if (!bl) {
                    try {
                        this.addJaxwsArtifacts(this.project, string4, string2);
                    }
                    catch (Exception exception) {
                        ErrorManager.getDefault().notify((Throwable)exception);
                    }
                } else {
                    try {
                        this.addServletElement(this.project, string4, string2);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                }
                fileObject = this.project.getProjectDirectory().getFileObject("build.xml");
                try {
                    wsdlWrapperHandler = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"wsimport-service-" + string7}, null);
                    wsdlWrapperHandler.waitFinished();
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(iOException.getLocalizedMessage());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
                }
                return string7;
            }
        }
        return null;
    }

    @Override
    public List<Service> getServices() {
        Service[] serviceArray;
        JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
        if (jaxWsModel != null && (serviceArray = jaxWsModel.getServices()) != null) {
            ArrayList<Service> arrayList = new ArrayList<Service>();
            for (int i = 0; i < serviceArray.length; ++i) {
                arrayList.add(serviceArray[i]);
            }
            return arrayList;
        }
        return new ArrayList<Service>();
    }

    private void writeJaxWsModel(final JaxWsModel jaxWsModel) {
        try {
            final FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
            if (fileObject != null) {
                fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FileLock fileLock = null;
                        OutputStream outputStream = null;
                        try {
                            fileLock = fileObject.lock();
                            outputStream = fileObject.getOutputStream(fileLock);
                            jaxWsModel.write(outputStream);
                            outputStream.close();
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify((Throwable)iOException);
                        }
                        finally {
                            if (outputStream != null) {
                                try {
                                    outputStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (fileLock != null) {
                                fileLock.releaseLock();
                            }
                        }
                    }
                });
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    @Override
    public FileObject getLocalWsdlFolderForService(String string, boolean bl) {
        return this.getArtifactsFolder(string, bl, true);
    }

    @Override
    public FileObject getBindingsFolderForService(String string, boolean bl) {
        return this.getArtifactsFolder(string, bl, false);
    }

    private FileObject getArtifactsFolder(String string, boolean bl, boolean bl2) {
        String string2 = bl2 ? "wsdl" : "bindings";
        FileObject fileObject = this.getXmlArtifactsRoot();
        if (fileObject == null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ProjectJAXWSSupport.class, (String)"MSG_MISSING_SRC_CONF")));
            return null;
        }
        FileObject fileObject2 = fileObject.getFileObject("xml-resources/web-services/" + string + "/" + string2);
        if (fileObject2 == null && bl) {
            try {
                FileObject fileObject3;
                FileObject fileObject4;
                FileObject fileObject5 = fileObject.getFileObject("xml-resources");
                if (fileObject5 == null) {
                    fileObject5 = fileObject.createFolder("xml-resources");
                }
                if ((fileObject4 = fileObject5.getFileObject("web-services")) == null) {
                    fileObject4 = fileObject5.createFolder("web-services");
                }
                if ((fileObject3 = fileObject4.getFileObject(string)) == null) {
                    fileObject3 = fileObject4.createFolder(string);
                }
                if ((fileObject2 = fileObject3.getFileObject(string2)) == null) {
                    fileObject2 = fileObject3.createFolder(string2);
                }
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return fileObject2;
    }

    protected FileObject getXmlArtifactsRoot() {
        return this.project.getProjectDirectory();
    }

    private FileObject getCatalogFileObject() {
        return this.project.getProjectDirectory().getFileObject("catalog.xml");
    }

    @Override
    public URL getCatalog() {
        try {
            FileObject fileObject = this.getCatalogFileObject();
            return fileObject == null ? null : fileObject.getURL();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForService(String string) throws IOException {
        FileObject fileObject = this.getWsdlFolder(true);
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            FileLock fileLock = fileObject2.lock();
            try {
                fileObject2.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        return fileObject.createFolder(string);
    }

    private static boolean isXnocompile(Project project) {
        String string;
        JAXWSVersionProvider jAXWSVersionProvider = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class);
        if (jAXWSVersionProvider != null && (string = jAXWSVersionProvider.getJAXWSVersion()) != null) {
            return ProjectJAXWSSupport.isVersionSatisfied(string, "2.1.3");
        }
        return true;
    }

    private static boolean isXendorsed(Project project) {
        String string;
        JAXWSVersionProvider jAXWSVersionProvider = (JAXWSVersionProvider)project.getLookup().lookup(JAXWSVersionProvider.class);
        if (jAXWSVersionProvider != null && (string = jAXWSVersionProvider.getJAXWSVersion()) != null) {
            return ProjectJAXWSSupport.isVersionSatisfied(string, "2.1.1");
        }
        return false;
    }

    private static boolean isVersionSatisfied(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        for (int i = 0; i < Math.min(n, n2); ++i) {
            if (string.charAt(i) < string2.charAt(i)) {
                return false;
            }
            if (string.charAt(i) <= string2.charAt(i)) continue;
            return true;
        }
        if (n > n2) {
            return true;
        }
        return n >= n2;
    }

    @Override
    public abstract FileObject getWsdlFolder(boolean var1) throws IOException;

    @Override
    public abstract String getWsdlLocation(String var1);

    @Override
    public abstract MetadataModel<WebservicesMetadata> getWebservicesMetadataModel();

    protected String getProjectJavaEEVersion() {
        return JAVA_EE_VERSION_NONE;
    }
}

