/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.actions;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.groovy.editor.api.NbUtilities;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.openide.filesystems.FileObject;

public class FixImportsHelper {
    private final Logger LOG = Logger.getLogger(FixImportsHelper.class.getName());

    public List<ImportCandidate> getImportCandidate(FileObject fo, String missingClass) {
        this.LOG.log(Level.FINEST, "Looking for class: " + missingClass);
        ArrayList<ImportCandidate> result = new ArrayList<ImportCandidate>();
        ClasspathInfo pathInfo = NbUtilities.getClasspathInfoForFileObject(fo);
        if (pathInfo == null) {
            this.LOG.log(Level.FINEST, "Problem getting ClasspathInfo");
            return result;
        }
        Set typeNames = pathInfo.getClassIndex().getDeclaredTypes(missingClass, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.allOf(ClassIndex.SearchScope.class));
        for (ElementHandle typeName : typeNames) {
            ElementKind ek = typeName.getKind();
            if (ek != ElementKind.CLASS && ek != ElementKind.INTERFACE) continue;
            String fqnName = typeName.getQualifiedName();
            this.LOG.log(Level.FINEST, "Found     : " + fqnName);
            Icon icon = ElementIcons.getElementIcon((ElementKind)ek, null);
            int level = FixImportsHelper.getImportanceLevel(fqnName);
            ImportCandidate candidate = new ImportCandidate(missingClass, fqnName, icon, level);
            result.add(candidate);
        }
        return result;
    }

    public static int getImportanceLevel(String fqn) {
        int weight = 50;
        if (fqn.startsWith("java.lang") || fqn.startsWith("java.util")) {
            weight -= 10;
        } else if (fqn.startsWith("org.omg") || fqn.startsWith("org.apache")) {
            weight += 10;
        } else if (fqn.startsWith("com.sun") || fqn.startsWith("com.ibm") || fqn.startsWith("com.apple")) {
            weight += 20;
        } else if (fqn.startsWith("sun") || fqn.startsWith("sunw") || fqn.startsWith("netscape")) {
            weight += 30;
        }
        return weight;
    }

    public static String getMissingClassName(String errorMessage) {
        int idx;
        String ERR_PREFIX = "unable to resolve class ";
        String missingClass = null;
        if (errorMessage.startsWith(ERR_PREFIX) && (idx = (missingClass = errorMessage.substring(ERR_PREFIX.length())).indexOf(" ")) != -1) {
            return missingClass.substring(0, idx);
        }
        return missingClass;
    }

    int getImportPosition(BaseDocument doc) {
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, 1);
        int importEnd = -1;
        int packageOffset = -1;
        while (ts.moveNext()) {
            Token t = ts.token();
            int offset = ts.offset();
            if (t.id() == GroovyTokenId.LITERAL_import) {
                this.LOG.log(Level.FINEST, "GroovyTokenId.LITERAL_import found");
                importEnd = offset;
                continue;
            }
            if (t.id() != GroovyTokenId.LITERAL_package) continue;
            this.LOG.log(Level.FINEST, "GroovyTokenId.LITERAL_package found");
            packageOffset = offset;
        }
        int useOffset = 0;
        if (importEnd != -1 && packageOffset > importEnd) {
            this.LOG.log(Level.FINEST, "packageOffset > importEnd");
            return -1;
        }
        if (importEnd == -1 && packageOffset == -1) {
            this.LOG.log(Level.FINEST, "importEnd == -1 && packageOffset == -1");
            return 0;
        }
        if (importEnd == -1 && packageOffset != -1) {
            this.LOG.log(Level.FINEST, "importEnd == -1 && packageOffset != -1");
            useOffset = packageOffset;
        } else if (importEnd != -1 && packageOffset == -1) {
            this.LOG.log(Level.FINEST, "importEnd != -1 && packageOffset == -1");
            useOffset = importEnd;
        } else if (importEnd != -1 && packageOffset != -1) {
            this.LOG.log(Level.FINEST, "importEnd != -1 && packageOffset != -1");
            useOffset = importEnd;
        }
        int lineOffset = 0;
        try {
            lineOffset = Utilities.getLineOffset((BaseDocument)doc, (int)useOffset);
        }
        catch (BadLocationException ex) {
            this.LOG.log(Level.FINEST, "BadLocationException for offset : {0}", useOffset);
            this.LOG.log(Level.FINEST, "BadLocationException : {0}", ex.getMessage());
            return -1;
        }
        return Utilities.getRowStartFromLineOffset((BaseDocument)doc, (int)(lineOffset + 1));
    }

    public void doImport(FileObject fo, String fqnName) throws MissingResourceException {
        int firstFreePosition = 0;
        BaseDocument baseDoc = LexUtilities.getDocument(fo, true);
        firstFreePosition = this.getImportPosition(baseDoc);
        if (firstFreePosition != -1) {
            if (baseDoc == null) {
                return;
            }
            EditList edits = new EditList(baseDoc);
            this.LOG.log(Level.FINEST, "Importing here: " + firstFreePosition);
            edits.replace(firstFreePosition, 0, "import " + fqnName + "\n", false, 0);
            edits.apply();
        }
    }

    public static class ImportCandidate {
        String name;
        String fqnName;
        Icon icon;
        int importantsLevel;

        public ImportCandidate(String name, String fqnName, Icon icon, int importantsLevel) {
            this.name = name;
            this.fqnName = fqnName;
            this.icon = icon;
            this.importantsLevel = importantsLevel;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String Name) {
            this.name = Name;
        }

        public String getFqnName() {
            return this.fqnName;
        }

        public void setFqnName(String fqnName) {
            this.fqnName = fqnName;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public int getImportantsLevel() {
            return this.importantsLevel;
        }

        public void setImportantsLevel(int importantsLevel) {
            this.importantsLevel = importantsLevel;
        }
    }
}

