/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.javame;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.Document;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.io.javame.MEDesignEditorSupport;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;

public final class MESourceEditorView
implements DataEditorView {
    private static final long serialVersionUID = -1L;
    static final String VIEW_ID = "source";
    private DataObjectContext context;
    private transient MECloneableEditor editor;
    private transient JComponent toolbar;

    MESourceEditorView(DataObjectContext context) {
        this.context = context;
        this.init();
    }

    private void init() {
        MEDesignEditorSupport sup = (MEDesignEditorSupport)this.context.getCloneableEditorSupport();
        this.editor = new MECloneableEditor(sup);
        sup.initializeCloneableEditor(this.editor);
    }

    public DataObjectContext getContext() {
        return this.context;
    }

    public DataEditorView.Kind getKind() {
        return DataEditorView.Kind.CODE;
    }

    public boolean canShowSideWindows() {
        return true;
    }

    public Collection<String> getTags() {
        return Collections.emptySet();
    }

    public String preferredID() {
        return VIEW_ID;
    }

    public String getDisplayName() {
        return ProjectUtils.getSourceEditorViewDisplayName();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MESourceEditorView.class);
    }

    public JComponent getVisualRepresentation() {
        return this.editor;
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            Document doc;
            JEditorPane pane = this.editor.getEditorPane();
            if (pane != null && (doc = pane.getDocument()) instanceof NbDocument.CustomToolbar) {
                this.toolbar = ((NbDocument.CustomToolbar)doc).createToolbar(pane);
            }
            if (this.toolbar == null) {
                this.toolbar = new JPanel();
            }
        }
        return this.toolbar;
    }

    public UndoRedo getUndoRedo() {
        return this.editor.getUndoRedo();
    }

    public void componentOpened() {
        this.editor.componentOpened();
    }

    public void componentClosed() {
        this.editor.componentClosed();
    }

    public void componentShowing() {
        this.editor.componentShowing();
    }

    public void componentHidden() {
    }

    public void componentActivated() {
        this.editor.componentActivatedSuper();
    }

    public void componentDeactivated() {
    }

    public int getOpenPriority() {
        return this.getOrder();
    }

    public int getEditPriority() {
        return -this.getOrder();
    }

    public int getOrder() {
        return -1000;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.context);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object object = in.readObject();
        if (!(object instanceof DataObjectContext)) {
            throw new ClassNotFoundException("DataObjectContext expected but not found");
        }
        this.context = (DataObjectContext)object;
        this.init();
    }

    private static final class MECloneableEditor
    extends CloneableEditor {
        public MECloneableEditor(MEDesignEditorSupport s) {
            super((CloneableEditorSupport)s);
        }

        final void componentActivatedSuper() {
            this.componentActivated();
        }

        protected void componentShowing() {
            super.componentShowing();
        }

        protected void componentOpened() {
            super.componentOpened();
        }

        protected void componentClosed() {
            super.componentClosed();
        }
    }
}

