/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.pluginimporter.libinstaller;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.pluginimporter.libinstaller.Bundle;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class JUnitLibraryInstaller {
    private static final String JUNIT_LIB = "org.netbeans.modules.junitlib";
    private static final String JUNIT_MODULE = "org.netbeans.modules.junit";
    private static final Logger LOG = Logger.getLogger(JUnitLibraryInstaller.class.getName());

    public static void install(boolean silent) {
        UpdateElement jUnitElement;
        UpdateUnit jUnitMod;
        Map<String, UpdateUnit> modules = JUnitLibraryInstaller.findModules(JUNIT_LIB, JUNIT_MODULE);
        if (modules.size() < 2) {
            LOG.finer("May be first start, when no update lists have yet been downloaded.");
            for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
                try {
                    p.refresh(null, true);
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, "While refreshing " + p + " thrown " + ex, ex);
                }
            }
            modules = JUnitLibraryInstaller.findModules(JUNIT_LIB, JUNIT_MODULE);
        }
        if ((jUnitMod = modules.get(JUNIT_MODULE)) == null) {
            LOG.fine("No org.netbeans.modules.junit found. Probably a network problem.");
            return;
        }
        if (jUnitMod.getInstalled() == null) {
            LOG.fine("org.netbeans.modules.junit didn't installed, no needed to install org.netbeans.modules.junitlib");
            return;
        }
        UpdateUnit jUnitLib = modules.get(JUNIT_LIB);
        if (jUnitLib == null) {
            LOG.fine("No org.netbeans.modules.junitlib found. Probably a network problem.");
            return;
        }
        if (jUnitLib.getInstalled() != null) {
            LOG.fine("org.netbeans.modules.junitlib already installed, no needed to install again.");
            return;
        }
        assert (!jUnitLib.getAvailableUpdates().isEmpty()) : "Updates found for " + jUnitLib;
        if (jUnitLib.getAvailableUpdates().isEmpty()) {
            LOG.info("No updates found for " + jUnitLib);
            return;
        }
        OperationContainer oc = OperationContainer.createForInstall();
        if (!oc.canBeAdded(jUnitLib, jUnitElement = (UpdateElement)jUnitLib.getAvailableUpdates().get(0))) {
            LOG.info("Could not add " + jUnitElement + " to updates");
            return;
        }
        for (UpdateElement req : oc.add(jUnitElement).getRequiredElements()) {
            oc.add(req);
        }
        if (silent) {
            try {
                LOG.fine("Try to download " + jUnitElement);
                ProgressHandle downloadHandle = ProgressHandleFactory.createHandle((String)Bundle.download_handle());
                InstallSupport.Validator validator = ((InstallSupport)oc.getSupport()).doDownload(downloadHandle, true);
                ProgressHandle validateHandle = ProgressHandleFactory.createHandle((String)Bundle.validate_handle());
                InstallSupport.Installer installer = ((InstallSupport)oc.getSupport()).doValidate(validator, validateHandle);
                LOG.fine("Try to install " + jUnitElement);
                ProgressHandle installHandle = ProgressHandleFactory.createHandle((String)Bundle.install_handle());
                OperationSupport.Restarter restarter = ((InstallSupport)oc.getSupport()).doInstall(installer, installHandle);
                assert (restarter == null) : "Not need to restart while installing " + jUnitLib;
                LOG.fine("Done " + jUnitElement);
            }
            catch (OperationException ex) {
                LOG.log(Level.INFO, "While installing " + jUnitLib + " thrown " + (Object)((Object)ex), ex);
            }
        } else {
            NotifyDescriptor.Confirmation question = new NotifyDescriptor.Confirmation((Object)Bundle.download_question(), Bundle.download_title(), 2);
            question.setOptions(new Object[]{Bundle.accept_button(), NotifyDescriptor.CANCEL_OPTION});
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)question) == Bundle.accept_button()) {
                if (!PluginManager.openInstallWizard((OperationContainer)oc)) {
                    LOG.info("user canceled JUnit install wizard");
                }
            } else {
                LOG.info("user denied JUnit installation");
            }
        }
    }

    private static Map<String, UpdateUnit> findModules(String ... codeNames) {
        List<String> names = Arrays.asList(codeNames);
        HashMap<String, UpdateUnit> res = new HashMap<String, UpdateUnit>();
        for (UpdateUnit unit : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!names.contains(unit.getCodeName())) continue;
            res.put(unit.getCodeName(), unit);
            if (res.size() != names.size()) continue;
            return res;
        }
        return res;
    }
}

