/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DescriptorRegistryListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DocumentInterface;
import org.netbeans.modules.vmd.api.model.ListenerManager;
import org.netbeans.modules.vmd.api.model.PostInitializeProcessor;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TransactionManager;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.openide.util.Utilities;

public final class DesignDocument {
    private final DocumentInterface documentInterface;
    private final DescriptorRegistry descriptorRegistry;
    private final ListenerManager listenerManager;
    private final TransactionManager transactionManager;
    private HashMap<Long, TimedWeakReference> uid2components;
    private DesignComponent rootComponent;
    private long componentIDCounter;
    private String selectionSourceID;
    private Collection<DesignComponent> selectedComponents;

    public DesignDocument(DocumentInterface documentInterface) {
        this.documentInterface = documentInterface;
        this.descriptorRegistry = DescriptorRegistry.getDescriptorRegistry(documentInterface.getProjectType(), documentInterface.getProjectID());
        this.listenerManager = new ListenerManager(this);
        this.transactionManager = new TransactionManager(this, this.descriptorRegistry, this.listenerManager);
        this.uid2components = new HashMap(100);
        this.componentIDCounter = 0L;
        this.selectedComponents = Collections.emptySet();
        this.descriptorRegistry.addRegistryListener(new DescriptorRegistryListener(){

            @Override
            public void descriptorRegistryUpdated() {
                DesignDocument.this.updateDescriptorReferences();
            }
        });
    }

    public DocumentInterface getDocumentInterface() {
        return this.documentInterface;
    }

    public DescriptorRegistry getDescriptorRegistry() {
        return this.descriptorRegistry;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public DesignComponent getRootComponent() {
        assert (this.getTransactionManager().isAccess());
        return this.rootComponent;
    }

    public void setRootComponent(DesignComponent rootComponent) {
        assert (this.getTransactionManager().isWriteAccess());
        assert (this.rootComponent == null);
        assert (rootComponent != null);
        this.rootComponent = rootComponent;
        this.getTransactionManager().rootChangeHappened(rootComponent);
    }

    public boolean setPreferredComponentID(long preferredComponentID) {
        assert (this.transactionManager.isWriteAccess());
        if (this.componentIDCounter > preferredComponentID) {
            return false;
        }
        this.componentIDCounter = preferredComponentID;
        return true;
    }

    public DesignComponent createComponent(TypeID componentType) {
        DesignComponent component = this.createRawComponent(componentType);
        assert (component != null);
        this.performComponentPostInit(component, component.getComponentDescriptor());
        PostInitializeProcessor.postInitializeComponent(this.getDocumentInterface().getProjectType(), component);
        return component;
    }

    private void performComponentPostInit(DesignComponent component, ComponentDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.performComponentPostInit(component, descriptor.getSuperDescriptor());
        descriptor.postInitialize(component);
    }

    public DesignComponent createRawComponent(TypeID componentType) {
        assert (Debug.isFriend(DesignDocument.class, "createComponent") || Debug.isFriend("org.netbeans.modules.vmd.io.DocumentLoad", "loadDocumentCore"));
        assert (this.transactionManager.isWriteAccess());
        ComponentDescriptor componentDescriptor = this.descriptorRegistry.getComponentDescriptor(componentType);
        assert (componentDescriptor != null) : "Missing component descriptor for " + componentType;
        assert (componentDescriptor.getTypeDescriptor().isCanInstantiate());
        DesignComponent component = new DesignComponent(this, this.componentIDCounter++, componentDescriptor);
        this.uid2components.put(component.getComponentID(), new TimedWeakReference(component));
        this.getListenerManager().notifyComponentCreated(component);
        return component;
    }

    public void deleteComponent(DesignComponent component) {
        assert (this.transactionManager.isWriteAccess());
        assert (component != null && component != this.rootComponent);
        assert (component.getDocument() == this);
        Collection<DesignComponent> components = component.getComponents();
        if (components.size() > 0) {
            Debug.warning("Children has to be deleted before deleting the component", component, components);
        }
        component.removeFromParentComponent();
        ComponentDescriptor descriptor = component.getComponentDescriptor();
        if (descriptor != null) {
            for (PropertyDescriptor property : descriptor.getPropertyDescriptors()) {
                component.resetToDefault(property.getName());
            }
        }
        if (this.selectedComponents.contains(component)) {
            HashSet<DesignComponent> selected = new HashSet<DesignComponent>(this.selectedComponents);
            selected.remove(component);
            this.setSelectedComponents("deleteComponent", selected);
        }
        assert (!Debug.isComponentReferencedInRootTree(component)) : "Component (" + component + ") is referenced still after deletion";
    }

    public void deleteComponents(Collection<DesignComponent> components) {
        assert (this.transactionManager.isWriteAccess());
        assert (this.deleteComponentsPreAssert(components));
        for (DesignComponent component : components) {
            component.removeFromParentComponent();
        }
        HashSet<DesignComponent> selected = null;
        for (DesignComponent component : components) {
            ComponentDescriptor descriptor;
            Collection<DesignComponent> children = component.getComponents();
            if (children.size() > 0) {
                Debug.warning("Children has to be deleted before deleting the component", component, children);
            }
            if ((descriptor = component.getComponentDescriptor()) != null) {
                for (PropertyDescriptor property : descriptor.getPropertyDescriptors()) {
                    component.resetToDefault(property.getName());
                }
            }
            if (!this.selectedComponents.contains(component)) continue;
            if (selected == null) {
                selected = new HashSet<DesignComponent>(this.selectedComponents);
            }
            selected.remove(component);
        }
        if (selected != null) {
            this.setSelectedComponents("deleteComponent", selected);
        }
        assert (this.deleteComponentsPostAssert(components));
    }

    private boolean deleteComponentsPreAssert(Collection<DesignComponent> components) {
        for (DesignComponent component : components) {
            assert (component != null && component != this.rootComponent);
            assert (component.getDocument() == this);
        }
        return true;
    }

    private boolean deleteComponentsPostAssert(Collection<DesignComponent> components) {
        for (DesignComponent component : components) {
            assert (!Debug.isComponentReferencedInRootTree(component)) : "Component (" + component + ") is referenced still after deletion";
        }
        return true;
    }

    public DesignComponent getComponentByUID(long componentID) {
        assert (this.transactionManager.isAccess());
        TimedWeakReference ref = this.uid2components.get(componentID);
        return ref != null ? (DesignComponent)ref.get() : null;
    }

    public String getSelectionSourceID() {
        assert (this.transactionManager.isAccess());
        return this.selectionSourceID;
    }

    public Collection<DesignComponent> getSelectedComponents() {
        assert (this.transactionManager.isAccess());
        return this.selectedComponents;
    }

    public void setSelectedComponents(String selectionSourceID, Collection<DesignComponent> components) {
        assert (this.transactionManager.isWriteAccess());
        assert (components != null);
        assert (this.setSelectedComponentsAssert(components));
        if (this.selectedComponents.containsAll(components) && components.containsAll(this.selectedComponents)) {
            return;
        }
        Collection<DesignComponent> old = this.selectedComponents;
        this.selectionSourceID = selectionSourceID;
        this.selectedComponents = Collections.unmodifiableCollection(new ArrayList<DesignComponent>(components));
        this.transactionManager.selectComponentsHappened(old, this.selectedComponents);
    }

    private boolean setSelectedComponentsAssert(Collection<DesignComponent> components) {
        for (DesignComponent component : components) {
            assert (component != null);
            assert (component.getDocument() == this);
        }
        return true;
    }

    private void updateDescriptorReferences() {
        this.transactionManager.writeAccess(new Runnable(){

            @Override
            public void run() {
                DesignDocument.this.updateDescriptorReferencesCore();
            }
        });
    }

    private void updateDescriptorReferencesCore() {
        for (TimedWeakReference reference : this.uid2components.values()) {
            DesignComponent component = (DesignComponent)reference.get();
            if (component == null) continue;
            ComponentDescriptor descriptor = this.descriptorRegistry.getComponentDescriptor(component.getType());
            component.setComponentDescriptor(descriptor, true);
        }
    }

    private final class TimedWeakReference
    extends WeakReference<DesignComponent>
    implements Runnable {
        private final long componentID;

        public TimedWeakReference(DesignComponent referent) {
            super(referent, Utilities.activeReferenceQueue());
            this.componentID = referent.getComponentID();
        }

        @Override
        public void run() {
            DesignDocument.this.transactionManager.writeAccess(new Runnable(){

                @Override
                public void run() {
                    DesignDocument.this.uid2components.remove(TimedWeakReference.this.componentID);
                }
            });
        }
    }
}

