/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.persistence;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.spi.PersistenceLocationProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class PersistenceLocationProviderImpl
implements PersistenceLocationProvider,
PropertyChangeListener {
    static final String DEF_LOCATION = "src/main/resources/META-INF";
    static final String DEF_PERSISTENCE = "src/main/resources/META-INF/persistence.xml";
    static final String ALT_PERSISTENCE = "src/main/java/META-INF/persistence.xml";
    private Project project = null;
    private FileObject location = null;
    private File projectDir = null;
    private File persistenceXml = null;

    public PersistenceLocationProviderImpl(Project proj) {
        this.project = proj;
        this.projectDir = FileUtil.toFile((FileObject)proj.getProjectDirectory());
        this.persistenceXml = this.findPersistenceXml();
        this.location = FileUtil.toFileObject((File)this.persistenceXml.getParentFile());
    }

    public FileObject getLocation() {
        return this.location;
    }

    public FileObject createLocation() throws IOException {
        FileObject retVal = null;
        File defaultLocation = FileUtilities.resolveFilePath((File)this.projectDir, (String)DEF_LOCATION);
        if (!defaultLocation.exists()) {
            retVal = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)DEF_LOCATION);
        }
        this.location = retVal = FileUtil.toFileObject((File)defaultLocation);
        return retVal;
    }

    protected File getPersistenceXml() {
        return this.persistenceXml;
    }

    private File findPersistenceXml() {
        File altLocation;
        File retVal = null;
        File defaultLocation = FileUtilities.resolveFilePath((File)this.projectDir, (String)DEF_PERSISTENCE);
        retVal = defaultLocation.exists() ? defaultLocation : ((altLocation = FileUtilities.resolveFilePath((File)this.projectDir, (String)ALT_PERSISTENCE)).exists() ? altLocation : defaultLocation);
        return retVal;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("MavenPersistence".equals(evt.getPropertyName())) {
            this.persistenceXml = this.findPersistenceXml();
            this.location = FileUtil.toFileObject((File)this.persistenceXml.getParentFile());
        }
    }
}

