/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.fold;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.modules.java.editor.semantic.ScanningCancellableTask;
import org.netbeans.modules.java.editor.semantic.Utilities;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class JavaElementFoldManager
extends JavaFoldManager {
    private FoldOperation operation;
    private FileObject file;
    private JavaElementFoldTask task;
    private boolean foldImportsPreset = false;
    private boolean foldInnerClassesPreset = false;
    private boolean foldJavadocsPreset = false;
    private boolean foldCodeBlocksPreset = false;
    private boolean foldInitialCommentsPreset = false;
    private Map<FoldInfo, Fold> currentFolds;
    private Fold initialCommentFold;
    private Fold importsFold;

    public void init(FoldOperation operation) {
        this.operation = operation;
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)"text/x-java").lookup(Preferences.class);
        this.foldInitialCommentsPreset = prefs.getBoolean("code-folding-collapse-initial-comment", this.foldInitialCommentsPreset);
        this.foldImportsPreset = prefs.getBoolean("code-folding-collapse-import", this.foldImportsPreset);
        this.foldCodeBlocksPreset = prefs.getBoolean("code-folding-collapse-method", this.foldCodeBlocksPreset);
        this.foldInnerClassesPreset = prefs.getBoolean("code-folding-collapse-innerclass", this.foldInnerClassesPreset);
        this.foldJavadocsPreset = prefs.getBoolean("code-folding-collapse-javadoc", this.foldJavadocsPreset);
    }

    public synchronized void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.operation.getHierarchy().getComponent().getDocument();
        Object od = doc.getProperty("stream");
        if (od instanceof DataObject) {
            this.currentFolds = new HashMap<FoldInfo, Fold>();
            this.task = JavaElementFoldTask.getTask(((DataObject)od).getPrimaryFile());
            this.task.setJavaElementFoldManager(this);
        }
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold emptyFold) {
        this.removeDamagedNotify(emptyFold);
    }

    public void removeDamagedNotify(Fold damagedFold) {
        this.currentFolds.remove(this.operation.getExtraInfo(damagedFold));
        if (this.importsFold == damagedFold) {
            this.importsFold = null;
        }
        if (this.initialCommentFold == damagedFold) {
            this.initialCommentFold = null;
        }
    }

    public void expandNotify(Fold expandedFold) {
    }

    public synchronized void release() {
        if (this.task != null) {
            this.task.setJavaElementFoldManager(null);
        }
        this.task = null;
        this.file = null;
        this.currentFolds = null;
        this.importsFold = null;
        this.initialCommentFold = null;
    }

    protected static final class FoldInfo
    implements Comparable {
        private Position start;
        private Position end;
        private JavaFoldManager.FoldTemplate template;
        private boolean collapseByDefault;

        public FoldInfo(Document doc, int start, int end, JavaFoldManager.FoldTemplate template, boolean collapseByDefault) throws BadLocationException {
            this.start = doc.createPosition(start);
            this.end = doc.createPosition(end);
            this.template = template;
            this.collapseByDefault = collapseByDefault;
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof FoldInfo)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public int compareTo(Object o) {
            FoldInfo remote = (FoldInfo)o;
            if (this.start.getOffset() < remote.start.getOffset()) {
                return -1;
            }
            if (this.start.getOffset() > remote.start.getOffset()) {
                return 1;
            }
            if (this.end.getOffset() < remote.end.getOffset()) {
                return -1;
            }
            if (this.end.getOffset() > remote.end.getOffset()) {
                return 1;
            }
            return 0;
        }
    }

    private final class JavaElementFoldVisitor
    extends CancellableTreePathScanner<Object, Object> {
        private List<FoldInfo> folds = new ArrayList<FoldInfo>();
        private CompilationInfo info;
        private CompilationUnitTree cu;
        private SourcePositions sp;
        private boolean stopped;

        public JavaElementFoldVisitor(CompilationInfo info, CompilationUnitTree cu, SourcePositions sp) {
            this.info = info;
            this.cu = cu;
            this.sp = sp;
        }

        public void checkInitialFold() {
            try {
                TokenHierarchy th = this.info.getTokenHierarchy();
                TokenSequence ts = th.tokenSequence(JavaTokenId.language());
                while (ts.moveNext()) {
                    Token token = ts.token();
                    if (token.id() == JavaTokenId.BLOCK_COMMENT || token.id() == JavaTokenId.JAVADOC_COMMENT) {
                        Document doc = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                        int startOffset = ts.offset();
                        boolean collapsed = JavaElementFoldManager.this.foldInitialCommentsPreset;
                        if (JavaElementFoldManager.this.initialCommentFold != null) {
                            collapsed = JavaElementFoldManager.this.initialCommentFold.isCollapsed();
                        }
                        this.folds.add(new FoldInfo(doc, startOffset, startOffset + token.length(), JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE, collapsed));
                    }
                    if (token.id() == JavaTokenId.WHITESPACE) continue;
                    break;
                }
            }
            catch (BadLocationException e) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException e) {
                this.stopped = true;
            }
        }

        private void handleJavadoc(Tree t) throws BadLocationException, ConcurrentModificationException {
            int start = (int)this.sp.getStartPosition(this.cu, t);
            if (start == -1) {
                return;
            }
            TokenHierarchy th = this.info.getTokenHierarchy();
            TokenSequence ts = th.tokenSequence(JavaTokenId.language());
            if (ts.move(start) == Integer.MAX_VALUE) {
                return;
            }
            while (ts.movePrevious()) {
                Token token = ts.token();
                if (token.id() == JavaTokenId.JAVADOC_COMMENT) {
                    Document doc = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                    int startOffset = ts.offset();
                    this.folds.add(new FoldInfo(doc, startOffset, startOffset + token.length(), JavaFoldManager.JAVADOC_FOLD_TEMPLATE, JavaElementFoldManager.this.foldJavadocsPreset));
                }
                if (token.id() == JavaTokenId.WHITESPACE || token.id() == JavaTokenId.BLOCK_COMMENT || token.id() == JavaTokenId.LINE_COMMENT) continue;
                break;
            }
        }

        private void handleTree(Tree node, Tree javadocTree, boolean handleOnlyJavadoc) {
            try {
                if (!handleOnlyJavadoc) {
                    Document doc = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                    int start = (int)this.sp.getStartPosition(this.cu, node);
                    int end = (int)this.sp.getEndPosition(this.cu, node);
                    if (start != -1 && end != -1) {
                        this.folds.add(new FoldInfo(doc, start, end, JavaFoldManager.CODE_BLOCK_FOLD_TEMPLATE, JavaElementFoldManager.this.foldCodeBlocksPreset));
                    }
                }
                this.handleJavadoc(javadocTree != null ? javadocTree : node);
            }
            catch (BadLocationException e) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException e) {
                this.stopped = true;
            }
        }

        public Object visitMethod(MethodTree node, Object p) {
            super.visitMethod(node, p);
            this.handleTree(node.getBody(), node, false);
            return null;
        }

        public Object visitClass(ClassTree node, Object p) {
            super.visitClass(node, (Object)Boolean.TRUE);
            try {
                if (p == Boolean.TRUE) {
                    Document doc = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                    int start = Utilities.findBodyStart(node, this.cu, this.sp, doc);
                    int end = (int)this.sp.getEndPosition(this.cu, node);
                    if (start != -1 && end != -1) {
                        this.folds.add(new FoldInfo(doc, start, end, JavaFoldManager.CODE_BLOCK_FOLD_TEMPLATE, JavaElementFoldManager.this.foldInnerClassesPreset));
                    }
                }
                this.handleJavadoc(node);
            }
            catch (BadLocationException e) {
                this.stopped = true;
            }
            catch (ConcurrentModificationException e) {
                this.stopped = true;
            }
            return null;
        }

        public Object visitVariable(VariableTree node, Object p) {
            super.visitVariable(node, p);
            this.handleTree(node, null, true);
            return null;
        }

        public Object visitBlock(BlockTree node, Object p) {
            super.visitBlock(node, p);
            TreePath path = this.getCurrentPath();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind())) {
                this.handleTree(node, null, false);
            }
            return null;
        }

        public Object visitCompilationUnit(CompilationUnitTree node, Object p) {
            int importsStart = Integer.MAX_VALUE;
            int importsEnd = -1;
            for (ImportTree importTree : node.getImports()) {
                int start = (int)this.sp.getStartPosition(this.cu, importTree);
                int end = (int)this.sp.getEndPosition(this.cu, importTree);
                if (importsStart > start) {
                    importsStart = start;
                }
                if (end <= importsEnd) continue;
                importsEnd = end;
            }
            if (importsEnd != -1 && importsStart != -1) {
                try {
                    boolean bl;
                    Document doc = JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument();
                    boolean bl2 = JavaElementFoldManager.this.foldImportsPreset;
                    if (JavaElementFoldManager.this.importsFold != null) {
                        bl = JavaElementFoldManager.this.importsFold.isCollapsed();
                    }
                    if ((importsStart += 7) < importsEnd) {
                        this.folds.add(new FoldInfo(doc, importsStart, importsEnd, JavaFoldManager.IMPORTS_FOLD_TEMPLATE, bl));
                    }
                }
                catch (BadLocationException e) {
                    this.stopped = true;
                }
            }
            return super.visitCompilationUnit(node, p);
        }
    }

    private class CommitFolds
    implements Runnable {
        private boolean insideRender;
        private List<FoldInfo> infos;
        private long startTime;

        public CommitFolds(List<FoldInfo> infos) {
            this.infos = infos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.insideRender) {
                this.startTime = System.currentTimeMillis();
                this.insideRender = true;
                JavaElementFoldManager.this.operation.getHierarchy().getComponent().getDocument().render(this);
                return;
            }
            JavaElementFoldManager.this.operation.getHierarchy().lock();
            try {
                FoldHierarchyTransaction tr = JavaElementFoldManager.this.operation.openTransaction();
                try {
                    if (JavaElementFoldManager.this.currentFolds == null) {
                        return;
                    }
                    TreeMap<FoldInfo, Fold> added = new TreeMap<FoldInfo, Fold>();
                    ArrayList removed = new ArrayList(JavaElementFoldManager.this.currentFolds.keySet());
                    for (FoldInfo i : this.infos) {
                        if (JavaElementFoldManager.this.currentFolds.containsKey(i)) {
                            removed.remove(i);
                            continue;
                        }
                        int start = i.start.getOffset();
                        int end = i.end.getOffset();
                        if (end <= start || end - start <= i.template.getStartGuardedLength() + i.template.getEndGuardedLength() || added.containsKey(i)) continue;
                        Fold f = JavaElementFoldManager.this.operation.addToHierarchy(i.template.getType(), i.template.getDescription(), i.collapseByDefault, start, end, i.template.getStartGuardedLength(), i.template.getEndGuardedLength(), (Object)i, tr);
                        added.put(i, f);
                        if (i.template == JavaFoldManager.IMPORTS_FOLD_TEMPLATE) {
                            JavaElementFoldManager.this.importsFold = f;
                        }
                        if (i.template != JavaFoldManager.INITIAL_COMMENT_FOLD_TEMPLATE) continue;
                        JavaElementFoldManager.this.initialCommentFold = f;
                    }
                    for (FoldInfo i : removed) {
                        Fold f = (Fold)JavaElementFoldManager.this.currentFolds.remove(i);
                        JavaElementFoldManager.this.operation.removeFromHierarchy(f, tr);
                        if (JavaElementFoldManager.this.importsFold == f) {
                            JavaElementFoldManager.this.importsFold = null;
                        }
                        if (JavaElementFoldManager.this.initialCommentFold != f) continue;
                        JavaElementFoldManager.this.initialCommentFold = null;
                    }
                    JavaElementFoldManager.this.currentFolds.putAll(added);
                }
                catch (BadLocationException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
                finally {
                    tr.commit();
                }
            }
            finally {
                JavaElementFoldManager.this.operation.getHierarchy().unlock();
            }
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 2", new Object[]{JavaElementFoldManager.this.file, endTime - this.startTime});
        }
    }

    static final class JavaElementFoldTask
    extends ScanningCancellableTask<CompilationInfo> {
        private static Map<DataObject, JavaElementFoldTask> file2Task = new WeakHashMap<DataObject, JavaElementFoldTask>();
        private Reference<JavaElementFoldManager> manager;

        JavaElementFoldTask() {
        }

        static JavaElementFoldTask getTask(FileObject file) {
            try {
                DataObject od = DataObject.find((FileObject)file);
                JavaElementFoldTask task = file2Task.get(od);
                if (task == null) {
                    task = new JavaElementFoldTask();
                    file2Task.put(od, task);
                }
                return task;
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(JavaElementFoldManager.class.getName()).log(Level.FINE, null, ex);
                return new JavaElementFoldTask();
            }
        }

        synchronized void setJavaElementFoldManager(JavaElementFoldManager manager) {
            this.manager = new WeakReference<JavaElementFoldManager>(manager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(CompilationInfo info) {
            JavaElementFoldManager jefm;
            this.resume();
            JavaElementFoldTask javaElementFoldTask = this;
            synchronized (javaElementFoldTask) {
                jefm = this.manager != null ? this.manager.get() : null;
            }
            if (jefm == null) {
                return;
            }
            long startTime = System.currentTimeMillis();
            CompilationUnitTree cu = info.getCompilationUnit();
            JavaElementFoldManager javaElementFoldManager = jefm;
            ((Object)((Object)javaElementFoldManager)).getClass();
            JavaElementFoldVisitor v = javaElementFoldManager.new JavaElementFoldVisitor(info, cu, info.getTrees().getSourcePositions());
            this.scan(v, (Tree)cu, null);
            if (v.stopped || this.isCancelled()) {
                return;
            }
            v.checkInitialFold();
            if (v.stopped || this.isCancelled()) {
                return;
            }
            JavaElementFoldManager javaElementFoldManager2 = jefm;
            ((Object)((Object)javaElementFoldManager2)).getClass();
            SwingUtilities.invokeLater(javaElementFoldManager2.new CommitFolds(v.folds));
            long endTime = System.currentTimeMillis();
            Logger.getLogger("TIMER").log(Level.FINE, "Folds - 1", new Object[]{info.getFileObject(), endTime - startTime});
        }
    }
}

