/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.TextAction;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxUpdateTokens;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.java.JavaFoldManager;
import org.netbeans.editor.ext.java.JavaSyntax;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplateManager;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.MainMenuAction;
import org.netbeans.modules.editor.NbEditorKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.editor.java.BraceCompletion;
import org.netbeans.modules.editor.java.DeleteToNextCamelCasePosition;
import org.netbeans.modules.editor.java.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.editor.java.GoToSupport;
import org.netbeans.modules.editor.java.NextCamelCasePosition;
import org.netbeans.modules.editor.java.PreviousCamelCasePosition;
import org.netbeans.modules.editor.java.SelectCodeElementAction;
import org.netbeans.modules.editor.java.SelectNextCamelCasePosition;
import org.netbeans.modules.editor.java.SelectPreviousCamelCasePosition;
import org.netbeans.modules.java.editor.codegen.InsertSemicolonAction;
import org.netbeans.modules.java.editor.imports.FastImportAction;
import org.netbeans.modules.java.editor.imports.JavaFixAllImports;
import org.netbeans.modules.java.editor.overridden.GoToSuperTypeAction;
import org.netbeans.modules.java.editor.rename.InstantRenameAction;
import org.netbeans.modules.java.editor.semantic.GoToMarkOccurrencesAction;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaKit
extends NbEditorKit {
    public static final String JAVA_MIME_TYPE = "text/x-java";
    static final long serialVersionUID = -5445829962533684922L;
    private static final Logger LOGGER = Logger.getLogger(JavaKit.class.getName());
    private static final Object sourceLevelKey = new Object();
    private static final String[] getSetIsPrefixes = new String[]{"get", "set", "is"};
    public static final String makeGetterAction = "make-getter";
    public static final String makeSetterAction = "make-setter";
    public static final String makeIsAction = "make-is";
    public static final String addWatchAction = "add-watch";
    public static final String toggleBreakpointAction = "toggle-breakpoint";
    public static final String abbrevDebugLineAction = "abbrev-debug-line";
    public static final String fixImportsAction = "fix-imports";
    public static final String fastImportAction = "fast-import";
    public static final String tryCatchAction = "try-catch";
    public static final String javaDocShowAction = "javadoc-show-action";
    public static final String expandAllJavadocFolds = "expand-all-javadoc-folds";
    public static final String collapseAllJavadocFolds = "collapse-all-javadoc-folds";
    public static final String expandAllCodeBlockFolds = "expand-all-code-block-folds";
    public static final String collapseAllCodeBlockFolds = "collapse-all-code-block-folds";
    public static final String selectNextElementAction = "select-element-next";
    public static final String selectPreviousElementAction = "select-element-previous";
    static final String previousCamelCasePosition = "previous-camel-case-position";
    static final String nextCamelCasePosition = "next-camel-case-position";
    static final String selectPreviousCamelCasePosition = "select-previous-camel-case-position";
    static final String selectNextCamelCasePosition = "select-next-camel-case-position";
    static final String deletePreviousCamelCasePosition = "delete-previous-camel-case-position";
    static final String deleteNextCamelCasePosition = "delete-next-camel-case-position";

    public String getContentType() {
        return JAVA_MIME_TYPE;
    }

    public Syntax createSyntax(Document doc) {
        String sourceLevel = (String)doc.getProperty(sourceLevelKey);
        if (sourceLevel == null) {
            sourceLevel = this.getSourceLevel((BaseDocument)doc);
            doc.putProperty(sourceLevelKey, sourceLevel);
        }
        return new JavaSyntax(sourceLevel);
    }

    public String getSourceLevel(BaseDocument doc) {
        DataObject dob = NbEditorUtilities.getDataObject((Document)doc);
        return dob != null ? SourceLevelQuery.getSourceLevel((FileObject)dob.getPrimaryFile()) : null;
    }

    protected void initDocument(BaseDocument doc) {
        doc.putProperty(SyntaxUpdateTokens.class, (Object)new SyntaxUpdateTokens(){
            private List tokenList = new ArrayList();

            public void syntaxUpdateStart() {
                this.tokenList.clear();
            }

            public List syntaxUpdateEnd() {
                return this.tokenList;
            }

            public void syntaxUpdateToken(TokenID id, TokenContextPath contextPath, int offset, int length) {
                if (JavaTokenContext.LINE_COMMENT == id) {
                    this.tokenList.add(new SyntaxUpdateTokens.TokenInfo((SyntaxUpdateTokens)this, id, contextPath, offset, length));
                }
            }
        });
        CodeTemplateManager.get((Document)doc);
    }

    protected Action[] createActions() {
        Action[] superActions = super.createActions();
        BaseAction[] actions = new BaseAction[]{new JavaDefaultKeyTypedAction(), new ExtKit.PrefixMakerAction(makeGetterAction, "get", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeSetterAction, "set", getSetIsPrefixes), new ExtKit.PrefixMakerAction(makeIsAction, "is", getSetIsPrefixes), new ExtKit.ToggleCommentAction("//"), new JavaInsertBreakAction(), new JavaDeleteCharAction("delete-previous", false), new JavaDeleteCharAction("delete-next", true), new JavaGenerateFoldPopupAction(), new JavaGoToDeclarationAction(), new InstantRenameAction(), new InsertSemicolonAction(true), new InsertSemicolonAction(false), new SelectCodeElementAction(selectNextElementAction, true), new SelectCodeElementAction(selectPreviousElementAction, false), new NextCamelCasePosition(JavaKit.findAction(superActions, "caret-next-word")), new PreviousCamelCasePosition(JavaKit.findAction(superActions, "caret-previous-word")), new SelectNextCamelCasePosition(JavaKit.findAction(superActions, "selection-next-word")), new SelectPreviousCamelCasePosition(JavaKit.findAction(superActions, "selection-previous-word")), new DeleteToNextCamelCasePosition(JavaKit.findAction(superActions, "remove-word-next")), new DeleteToPreviousCamelCasePosition(JavaKit.findAction(superActions, "remove-word-previous")), new FastImportAction(), new GoToSuperTypeAction(), new GoToMarkOccurrencesAction(false), new GoToMarkOccurrencesAction(true)};
        return TextAction.augmentList(superActions, (Action[])actions);
    }

    private static Action findAction(Action[] actions, String name) {
        for (Action a : actions) {
            Object nameObj = a.getValue("Name");
            if (!(nameObj instanceof String) || !name.equals(nameObj)) continue;
            return a;
        }
        return null;
    }

    public static class JavaGotoHelpAction
    extends BaseAction {
        public JavaGotoHelpAction() {
            super(142);
            this.putValue("helpID", JavaGotoHelpAction.class.getName());
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                GoToSupport.goToJavadoc(target.getDocument(), target.getCaretPosition());
            }
        }

        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle(JavaKit.class).getString("show_javadoc");
        }
    }

    public static class JavaFixImports
    extends BaseAction {
        public JavaFixImports() {
            super(14);
            this.putValue("trimmed-text", NbBundle.getBundle(JavaKit.class).getString("fix-imports-trimmed"));
            this.putValue("ShortDescription", NbBundle.getBundle(JavaKit.class).getString("desc-fix-imports"));
            this.putValue("PopupMenuText", NbBundle.getBundle(JavaKit.class).getString("popup-fix-imports"));
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            Document doc;
            Object source;
            if (target != null && (source = (doc = target.getDocument()).getProperty("stream")) instanceof DataObject) {
                FileObject fo = ((DataObject)source).getPrimaryFile();
                JavaFixAllImports.getDefault().fixAllImports(fo);
            }
        }

        public static final class GlobalAction
        extends MainMenuAction {
            public GlobalAction() {
                this.setMenu();
            }

            protected String getMenuItemText() {
                return NbBundle.getBundle(GlobalAction.class).getString("fix-imports-main-menu-source-item");
            }

            protected String getActionName() {
                return JavaKit.fixImportsAction;
            }
        }
    }

    public static class JavaGoToSourceAction
    extends BaseAction {
        static final long serialVersionUID = -6440495023918097760L;

        public JavaGoToSourceAction() {
            super(142);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && target.getDocument() instanceof BaseDocument) {
                GoToSupport.goTo((Document)((BaseDocument)target.getDocument()), target.getCaretPosition(), true);
            }
        }

        public String getPopupMenuText(JTextComponent target) {
            return NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted");
        }

        protected Class getShortDescriptionBundleClass() {
            return BaseKit.class;
        }
    }

    public static class JavaGoToDeclarationAction
    extends ExtKit.GotoDeclarationAction {
        public boolean gotoDeclaration(JTextComponent target) {
            if (!(target.getDocument() instanceof BaseDocument)) {
                return false;
            }
            GoToSupport.goTo((Document)((BaseDocument)target.getDocument()), target.getCaretPosition(), false);
            return true;
        }
    }

    public static class JavaGenerateFoldPopupAction
    extends NbEditorKit.GenerateFoldPopupAction {
        protected void addAdditionalItems(JTextComponent target, JMenu menu) {
            this.addAction(target, menu, JavaKit.collapseAllJavadocFolds);
            this.addAction(target, menu, JavaKit.expandAllJavadocFolds);
            this.setAddSeparatorBeforeNextAction(true);
            this.addAction(target, menu, JavaKit.collapseAllCodeBlockFolds);
            this.addAction(target, menu, JavaKit.expandAllCodeBlockFolds);
        }
    }

    public static class CollapseAllCodeBlockFolds
    extends BaseAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            types.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, types);
        }
    }

    public static class ExpandAllCodeBlockFolds
    extends BaseAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            ArrayList<FoldType> types = new ArrayList<FoldType>();
            types.add(JavaFoldManager.CODE_BLOCK_FOLD_TYPE);
            types.add(JavaFoldManager.IMPORTS_FOLD_TYPE);
            FoldUtilities.expand((FoldHierarchy)hierarchy, types);
        }
    }

    public static class CollapseAllJavadocFolds
    extends BaseAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.collapse((FoldHierarchy)hierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class ExpandAllJavadocFolds
    extends BaseAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)target);
            FoldUtilities.expand((FoldHierarchy)hierarchy, (FoldType)JavaFoldManager.JAVADOC_FOLD_TYPE);
        }
    }

    public static class JavaDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public JavaDeleteCharAction(String nm, boolean nextChar) {
            super(nm, nextChar);
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
            BraceCompletion.charBackspaced(doc, dotPos, caret, ch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            target.putClientProperty(JavaDeleteCharAction.class, (Object)this);
            try {
                super.actionPerformed(evt, target);
            }
            finally {
                target.putClientProperty(JavaDeleteCharAction.class, null);
            }
        }

        public boolean getNextChar() {
            return this.nextChar;
        }
    }

    public static class JavaInsertBreakAction
    extends BaseKit.InsertBreakAction {
        static final long serialVersionUID = -1506173310438326380L;
        private boolean isJavadocTouched = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block13: {
                try {
                    super.actionPerformed(evt, target);
                    if (this.isJavadocTouched) {
                        Lookup.Result res = MimeLookup.getLookup((MimePath)MimePath.parse((String)"text/x-javadoc")).lookupResult(TextAction.class);
                        ActionEvent newevt = new ActionEvent(target, 1001, "fix-javadoc");
                        for (TextAction action : res.allInstances()) {
                            action.actionPerformed(newevt);
                        }
                        break block13;
                    }
                    Document doc = target.getDocument();
                    int start = ((AbstractDocument)doc).getParagraphElement(target.getCaretPosition()).getStartOffset();
                    int end = ((AbstractDocument)doc).getParagraphElement(target.getCaretPosition()).getEndOffset();
                    try {
                        if (doc.getText(start, end - start - 1).matches("\\s+\\*\\s+")) {
                            TokenHierarchy th = TokenHierarchy.get((Document)doc);
                            TokenSequence ts = th.tokenSequence();
                            ts.move(target.getCaretPosition());
                            ts.moveNext();
                            Token t = ts.token();
                            if (t.id() == JavaTokenId.BLOCK_COMMENT) {
                                String part;
                                int pos;
                                if (t.partType() == PartType.START) {
                                    String s = doc.getText(start, end - start - 1);
                                    s = s.replaceFirst(" \\* ", " */");
                                    s = "\n" + s;
                                    int cursorPos = target.getCaretPosition();
                                    doc.insertString(end - 1, s, null);
                                    target.setCaretPosition(cursorPos);
                                } else if (t.partType() == PartType.COMPLETE && (pos = (part = doc.getText(end, doc.getLength() - end)).indexOf("*/")) != -1) {
                                    part = part.substring(0, pos + 2);
                                    TokenHierarchy thp = TokenHierarchy.create((CharSequence)part, (Language)JavaTokenId.language());
                                    TokenSequence tsp = thp.tokenSequence();
                                    tsp.moveEnd();
                                    tsp.movePrevious();
                                    Token tp = tsp.token();
                                    if (tp.id() != JavaTokenId.INVALID_COMMENT_END) {
                                        String s = doc.getText(start, end - start - 1);
                                        s = s.replaceFirst(" \\* ", " */");
                                        s = "\n" + s;
                                        int cursorPos = target.getCaretPosition();
                                        doc.insertString(end - 1, s, null);
                                        target.setCaretPosition(cursorPos);
                                    }
                                }
                            }
                        }
                    }
                    catch (BadLocationException ex) {
                        LOGGER.log(Level.WARNING, "Cannot complete block comment", ex);
                    }
                }
                finally {
                    this.isJavadocTouched = false;
                }
            }
        }

        protected Object beforeBreak(JTextComponent target, BaseDocument doc, Caret caret) {
            int dotPos = caret.getDot();
            if (BraceCompletion.posWithinString((Document)doc, dotPos)) {
                try {
                    doc.insertString(dotPos, "\" + \"", null);
                    CodeStyle cs = CodeStyle.getDefault((Document)doc);
                    if (cs.wrapAfterBinaryOps()) {
                        caret.setDot(dotPos += 3);
                        return new Integer(1);
                    }
                    caret.setDot(++dotPos);
                    return new Integer(3);
                }
                catch (BadLocationException ex) {}
            } else {
                try {
                    if (BraceCompletion.isAddRightBrace(doc, dotPos)) {
                        boolean[] insert = new boolean[]{true};
                        int end = BraceCompletion.getRowOrBlockEnd(doc, dotPos, insert);
                        if (insert[0]) {
                            doc.insertString(end, "}", null);
                            Indent.get((Document)doc).indentNewLine(end);
                        }
                        caret.setDot(dotPos);
                        return Boolean.TRUE;
                    }
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
            return this.javadocBlockCompletion(target, doc, dotPos);
        }

        protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object cookie) {
            if (cookie != null && cookie instanceof Integer) {
                int nowDotPos = caret.getDot();
                caret.setDot(nowDotPos + (Integer)cookie);
            }
        }

        private Object javadocBlockCompletion(JTextComponent target, BaseDocument doc, int dotPosition) {
            try {
                CharSequence content;
                TokenHierarchy tokens = TokenHierarchy.get((Document)doc);
                TokenSequence ts = tokens.tokenSequence();
                if (ts == null) {
                    return null;
                }
                ts.move(dotPosition);
                if (!ts.moveNext() && !ts.movePrevious() || ts.token().id() != JavaTokenId.JAVADOC_COMMENT) {
                    return null;
                }
                int jdoffset = dotPosition - 3;
                if (jdoffset >= 0 && JavaInsertBreakAction.isOpenJavadoc(content = DocumentUtilities.getText((Document)doc), dotPosition - 1) && !JavaInsertBreakAction.isClosedJavadoc(content, dotPosition)) {
                    doc.insertString(dotPosition, "*/", null);
                    Indent.get((Document)doc).indentNewLine(dotPosition);
                    target.setCaretPosition(dotPosition);
                    this.isJavadocTouched = true;
                    return Boolean.TRUE;
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return null;
        }

        private static boolean isOpenJavadoc(CharSequence content, int pos) {
            for (int i = pos; i >= 0; --i) {
                char c = content.charAt(i);
                if (c == '*' && i - 2 >= 0 && content.charAt(i - 1) == '*' && content.charAt(i - 2) == '/') {
                    return true;
                }
                if (c == '\n') {
                    return false;
                }
                if (c != '/' || i - 1 < 0 || content.charAt(i - 1) != '*') continue;
                return false;
            }
            return false;
        }

        private static boolean isClosedJavadoc(CharSequence txt, int pos) {
            int length = txt.length();
            int quotation = 0;
            for (int i = pos; i < length; ++i) {
                char c = txt.charAt(i);
                if (c == '*' && i < length - 1 && txt.charAt(i + 1) == '/') {
                    char cc;
                    if (quotation == 0 || i < length - 2) {
                        return true;
                    }
                    boolean isClosed = true;
                    for (int j = i + 2; j < length && (cc = txt.charAt(j)) != '\n'; ++j) {
                        if (cc != '\"' || j >= length - 1 || txt.charAt(j + 1) == '\'') continue;
                        isClosed = false;
                        break;
                    }
                    if (!isClosed) continue;
                    return true;
                }
                if (c == '/' && i < length - 1 && txt.charAt(i + 1) == '*') {
                    return false;
                }
                if (c == '\n') {
                    quotation = 0;
                    continue;
                }
                if (c != '\"' || i >= length - 1 || txt.charAt(i + 1) == '\'') continue;
                ++quotation;
                quotation %= 2;
            }
            return false;
        }
    }

    public static class AbbrevDebugLineAction
    extends BaseAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                BaseDocument doc = (BaseDocument)target.getDocument();
                StringBuffer sb = new StringBuffer("System.out.println(\"");
                String title = (String)doc.getProperty((Object)"title");
                if (title != null) {
                    sb.append(title);
                    sb.append(':');
                }
                try {
                    sb.append(Utilities.getLineOffset((BaseDocument)doc, (int)target.getCaret().getDot()) + 1);
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                sb.append(' ');
                BaseKit kit = Utilities.getKit((JTextComponent)target);
                if (kit == null) {
                    return;
                }
                Action a = kit.getActionByName("insert-content");
                if (a != null) {
                    Utilities.performAction((Action)a, (ActionEvent)new ActionEvent(target, 1001, sb.toString()), (JTextComponent)target);
                }
            }
        }
    }

    public static class JavaGenerateGoToPopupAction
    extends NbEditorKit.NbGenerateGoToPopupAction {
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
        }

        private void addAcceleretors(Action a, JMenuItem item, JTextComponent target) {
            Keymap km = target.getKeymap();
            if (km != null) {
                KeyStroke ks;
                KeyStroke[] keys = km.getKeyStrokesForAction(a);
                if (keys != null && keys.length > 0) {
                    item.setAccelerator(keys[0]);
                } else if (a != null && (ks = (KeyStroke)a.getValue("AcceleratorKey")) != null) {
                    item.setAccelerator(ks);
                }
            }
        }

        private void addAction(JTextComponent target, JMenu menu, Action a) {
            if (a != null) {
                String actionName = (String)a.getValue("Name");
                JMenuItem item = null;
                if (a instanceof BaseAction) {
                    item = ((BaseAction)a).getPopupMenuItem(target);
                }
                if (item == null) {
                    String itemText = (String)a.getValue("trimmed-text");
                    if (itemText == null) {
                        itemText = this.getItemText(target, actionName, a);
                    }
                    if (itemText != null) {
                        item = new JMenuItem(itemText);
                        Mnemonics.setLocalizedText((AbstractButton)item, (String)itemText);
                        item.addActionListener(a);
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(a.isEnabled());
                        Object helpID = a.getValue("helpID");
                        if (helpID != null && helpID instanceof String) {
                            item.putClientProperty("HelpID", helpID);
                        }
                    } else if ("goto-source".equals(actionName)) {
                        item = new JMenuItem(NbBundle.getBundle(JavaKit.class).getString("goto_source_open_source_not_formatted"));
                        this.addAcceleretors(a, item, target);
                        item.setEnabled(false);
                    }
                }
                if (item != null) {
                    menu.add(item);
                }
            }
        }

        protected void addAction(JTextComponent target, JMenu menu, String actionName) {
            BaseKit kit = Utilities.getKit((JTextComponent)target);
            if (kit == null) {
                return;
            }
            Action a = kit.getActionByName(actionName);
            if (a != null) {
                this.addAction(target, menu, a);
            } else {
                menu.addSeparator();
            }
        }

        protected String getItemText(JTextComponent target, String actionName, Action a) {
            String itemText = a instanceof BaseAction ? ((BaseAction)a).getPopupMenuText(target) : actionName;
            return itemText;
        }

        public JMenuItem getPopupMenuItem(JTextComponent target) {
            String menuText = NbBundle.getBundle(JavaKit.class).getString("generate-goto-popup");
            JMenu jm = new JMenu(menuText);
            this.addAction(target, jm, "goto-source");
            this.addAction(target, jm, "goto-declaration");
            this.addAction(target, jm, "goto-super-implementation");
            this.addAction(target, jm, "goto");
            return jm;
        }
    }

    public static class JavaDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            char insertedChar = str.charAt(0);
            if (insertedChar == '\"' || insertedChar == '\'') {
                boolean inserted = BraceCompletion.completeQuote(doc, dotPos, caret, insertedChar);
                if (inserted) {
                    caret.setDot(dotPos + 1);
                } else {
                    super.insertString(doc, dotPos, caret, str, overwrite);
                }
            } else {
                super.insertString(doc, dotPos, caret, str, overwrite);
                BraceCompletion.charInserted(doc, dotPos, caret, insertedChar);
            }
        }

        protected void replaceSelection(JTextComponent target, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            char insertedChar = str.charAt(0);
            Document doc = target.getDocument();
            if (insertedChar == '\"' || insertedChar == '\'') {
                if (doc != null) {
                    try {
                        boolean inserted = false;
                        int p0 = Math.min(caret.getDot(), caret.getMark());
                        int p1 = Math.max(caret.getDot(), caret.getMark());
                        if (p0 != p1) {
                            doc.remove(p0, p1 - p0);
                        }
                        int caretPosition = caret.getDot();
                        if (doc instanceof BaseDocument) {
                            inserted = BraceCompletion.completeQuote((BaseDocument)doc, caretPosition, caret, insertedChar);
                        }
                        if (inserted) {
                            caret.setDot(caretPosition + 1);
                        } else if (str != null && str.length() > 0) {
                            doc.insertString(p0, str, null);
                        }
                    }
                    catch (BadLocationException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                super.replaceSelection(target, dotPos, caret, str, overwrite);
                if (doc instanceof BaseDocument) {
                    BraceCompletion.charInserted((BaseDocument)doc, caret.getDot() - 1, caret, insertedChar);
                }
            }
        }
    }
}

