/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.adapter.SceneLayerTableAdapter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class SequenceContainerTableAdapter
implements TableModel,
SequenceContainerListener,
SequenceListener,
PropertyChangeListener {
    private static final int COLS = 4;
    private static final int COL_DEFAULT = 0;
    private static final int COL_NAME = 1;
    private static final int COL_FRAMES = 2;
    private static final int COL_DELAY = 3;
    private SequenceContainer sequenceContainer;
    private ArrayList listeners = new ArrayList();

    public SequenceContainerTableAdapter(SequenceContainer sequenceContainer) {
        this.sequenceContainer = sequenceContainer;
        this.sequenceContainer.addSequenceContainerListener(this);
        this.sequenceContainer.addPropertyChangeListener(this);
        for (Sequence s : this.sequenceContainer.getSequences()) {
            s.addSequenceListener(this);
            s.addPropertyChangeListener(this);
        }
    }

    @Override
    public int getRowCount() {
        return this.sequenceContainer.getSequenceCount();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return NbBundle.getMessage(SequenceContainerTableAdapter.class, (String)"SequenceContainerTableAdapter.columnDefault.txt");
            }
            case 1: {
                return NbBundle.getMessage(SequenceContainerTableAdapter.class, (String)"SequenceContainerTableAdapter.columnName.txt");
            }
            case 2: {
                return NbBundle.getMessage(SequenceContainerTableAdapter.class, (String)"SequenceContainerTableAdapter.columnFrames.txt");
            }
            case 3: {
                return NbBundle.getMessage(SequenceContainerTableAdapter.class, (String)"SequenceContainerTableAdapter.columnDelay.txt");
            }
        }
        return "???";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Short.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Sequence s = this.sequenceContainer.getSequenceAt(rowIndex);
        if (s == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.sequenceContainer.getDefaultSequence() == s;
            }
            case 1: {
                return s.getName();
            }
            case 2: {
                return s.getFrameCount();
            }
            case 3: {
                return s.getFrameMs();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Sequence s = this.sequenceContainer.getSequenceAt(rowIndex);
        switch (columnIndex) {
            case 0: {
                this.sequenceContainer.setDefaultSequence(s);
                break;
            }
            case 1: {
                String name = (String)aValue;
                if (!this.sequenceContainer.getGameDesign().isComponentNameAvailable(name)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SceneLayerTableAdapter.class, (String)"SequenceContainerTableAdapter.noRenameDialog.txt", (Object)name), 0));
                    break;
                }
                s.setName(name);
                break;
            }
            case 3: {
                s.setFrameMs((Integer)aValue);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void sequenceAdded(SequenceContainer source, Sequence sequence, int index) {
        TableModelEvent e = new TableModelEvent(this, index, index, -1, 1);
        sequence.addPropertyChangeListener(this);
        sequence.addSequenceListener(this);
        this.fireTableChanged(e);
    }

    @Override
    public void sequenceRemoved(SequenceContainer source, Sequence sequence, int index) {
        TableModelEvent e = new TableModelEvent(this, index, index, -1, -1);
        sequence.removePropertyChangeListener(this);
        sequence.removeSequenceListener(this);
        this.fireTableChanged(e);
    }

    @Override
    public void sequenceMoved(SequenceContainer source, Sequence sequence, int indexOld, int indexNew) {
        this.sequenceRemoved(source, sequence, indexOld);
        this.sequenceAdded(source, sequence, indexNew);
    }

    private void fireTableChanged(TableModelEvent e) {
        for (TableModelListener l : this.listeners) {
            l.tableChanged(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Sequence) {
            Sequence s = (Sequence)evt.getSource();
            int index = this.sequenceContainer.indexOf(s);
            TableModelEvent e = new TableModelEvent(this, index, index, -1, 0);
            this.fireTableChanged(e);
        }
        if (evt.getSource() instanceof SequenceContainer) {
            SequenceContainer sc = (SequenceContainer)evt.getSource();
            if (evt.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
                Sequence old = (Sequence)evt.getOldValue();
                Sequence current = (Sequence)evt.getNewValue();
                int oldIndex = this.sequenceContainer.indexOf(old);
                int newIndex = this.sequenceContainer.indexOf(current);
                TableModelEvent e = new TableModelEvent(this, oldIndex, oldIndex, -1, 0);
                this.fireTableChanged(e);
                e = new TableModelEvent(this, newIndex, newIndex, -1, 0);
                this.fireTableChanged(e);
            }
        }
    }

    @Override
    public void frameAdded(Sequence sequence, int index) {
        int seqIndex = this.sequenceContainer.indexOf(sequence);
        TableModelEvent e = new TableModelEvent(this, seqIndex, seqIndex, -1, 1);
        this.fireTableChanged(e);
    }

    @Override
    public void frameRemoved(Sequence sequence, int index) {
        int seqIndex = this.sequenceContainer.indexOf(sequence);
        TableModelEvent e = new TableModelEvent(this, seqIndex, seqIndex, -1, 1);
        this.fireTableChanged(e);
    }

    @Override
    public void frameModified(Sequence sequence, int index) {
    }

    @Override
    public void framesChanged(Sequence sequence) {
        TableModelEvent e = new TableModelEvent(this);
        this.fireTableChanged(e);
    }
}

