/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.integration;

import com.sun.source.util.TreePath;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.vmd.api.codegen.CodeClassLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeGlobalLevelPresenter;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.codegen.MultiGuardedSection;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.game.integration.components.GameTypes;
import org.netbeans.modules.vmd.game.model.AnimatedTileCD;
import org.netbeans.modules.vmd.game.model.CodeUtils;
import org.netbeans.modules.vmd.game.model.TiledLayerCD;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.util.Exceptions;

public class GameCodeSupport {
    public static Presenter createAddImportPresenter(final List<String> fqns) {
        return new CodeGlobalLevelPresenter(){

            protected void performGlobalGeneration(StyledDocument styledDocument) {
                this.addImports(styledDocument);
            }

            private void addImports(StyledDocument styledDocument) {
                try {
                    JavaSource.forDocument((Document)styledDocument).runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                        public void cancel() {
                        }

                        public void run(WorkingCopy parameter) throws Exception {
                            parameter.toPhase(JavaSource.Phase.PARSED);
                            for (String fqn : fqns) {
                                SourceUtils.resolveImport((CompilationInfo)parameter, (TreePath)new TreePath(parameter.getCompilationUnit()), (String)fqn);
                            }
                        }
                    }).commit();
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        };
    }

    public static Presenter createSequenceCodePresenter() {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection section) {
                CodeWriter writer = section.getWriter();
                DesignComponent component = this.getComponent();
                String name = MidpTypes.getString((PropertyValue)component.readProperty("sequncecd.prop.name"));
                int frameMillis = MidpTypes.getInteger((PropertyValue)component.readProperty("sequncecd.prop.framems"));
                writer.write("public int " + name + "Delay = " + frameMillis + ";\n");
                writer.write("public int[] " + name + " = {");
                int[] frames = GameTypes.getFrames(component.readProperty("sequncecd.prop.frames"));
                for (int i = 0; i < frames.length; ++i) {
                    if (i > 0) {
                        writer.write(", ");
                    }
                    writer.write(Integer.toString(frames[i]));
                }
                writer.write("};\n");
            }
        };
    }

    public static Presenter createImageResourceCodePresenter(final List<String> fqns) {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection section) {
                CodeWriter writer = section.getWriter();
                DesignComponent component = this.getComponent();
                String name = MidpTypes.getString((PropertyValue)component.readProperty("imageresourcecd.prop.name"));
                writer.write("private Image " + name + ";\n");
                fqns.add("javax.microedition.lcdui.Image");
            }

            protected void generateClassBodyCode(StyledDocument document) {
                DesignComponent component = this.getComponent();
                MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(component.getComponentID() + "-getter"));
                String name = MidpTypes.getString((PropertyValue)component.readProperty("imageresourcecd.prop.name"));
                String path = MidpTypes.getString((PropertyValue)component.readProperty("imageresourcecd.prop.imagepath"));
                section.getWriter().write("public Image " + CodeUtils.createGetterMethodName(name) + "() throws java.io.IOException {\n");
                section.getWriter().write("if (" + name + " == null) {\n");
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-preInit");
                section.getWriter().write(" // write pre-init user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write(name + " = Image.createImage(\"" + path + "\");\n");
                section.getWriter().write("}\n");
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-postInit");
                section.getWriter().write(" // write post-init user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write("return this." + name + ";\n");
                section.getWriter().write("}\n");
                section.getWriter().write("\n");
                section.getWriter().commit();
                section.close();
            }
        };
    }

    public static Presenter createSceneCodePresenter(final List<String> fqns) {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateClassBodyCode(StyledDocument document) {
                DesignComponent component = this.getComponent();
                MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(component.getComponentID() + "-updateLayerManager"));
                String sceneName = MidpTypes.getString((PropertyValue)component.readProperty("scenecd.prop.name"));
                section.getWriter().write("public void updateLayerManagerFor" + CodeUtils.capitalize(sceneName) + "(LayerManager lm) throws java.io.IOException {\n");
                fqns.add("javax.microedition.lcdui.game.LayerManager");
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-preUpdate");
                section.getWriter().write(" // write pre-update user code here\n").commit();
                section.switchToGuarded();
                List tmp = component.readProperty("scenecd.prop.sceneitems").getArray();
                ArrayList sceneItems = new ArrayList();
                sceneItems.addAll(tmp);
                Collections.sort(sceneItems, new Comparator<PropertyValue>(){

                    @Override
                    public int compare(PropertyValue a, PropertyValue b) {
                        DesignComponent aItem = a.getComponent();
                        int aZ = MidpTypes.getInteger((PropertyValue)aItem.readProperty("sceneitemcd.prop.z.order"));
                        DesignComponent bItem = b.getComponent();
                        int bZ = MidpTypes.getInteger((PropertyValue)bItem.readProperty("sceneitemcd.prop.z.order"));
                        return new Integer(aZ).compareTo(bZ);
                    }
                });
                for (PropertyValue propertyValue : sceneItems) {
                    DesignComponent sceneItem = propertyValue.getComponent();
                    DesignComponent layer = sceneItem.readProperty("sceneitemcd.prop.layer").getComponent();
                    String layerName = MidpTypes.getString((PropertyValue)layer.readProperty("layercd.prop.name"));
                    Point position = GameTypes.getPoint(sceneItem.readProperty("sceneitemcd.prop.position"));
                    boolean visible = MidpTypes.getBoolean((PropertyValue)sceneItem.readProperty("sceneitemcd.prop.visible"));
                    section.getWriter().write(CodeUtils.createGetterMethodName(layerName) + "().setPosition(" + position.x + ", " + position.y + ");\n");
                    section.getWriter().write(CodeUtils.createGetterMethodName(layerName) + "().setVisible(" + visible + ");\n");
                    section.getWriter().write("lm.append(" + CodeUtils.createGetterMethodName(layerName) + "());\n");
                }
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-postUpdate");
                section.getWriter().write(" // write post-update user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write("}\n");
                section.getWriter().write("\n");
                section.getWriter().commit();
                section.close();
            }
        };
    }

    public static Presenter createSpriteCodePresenter(final List<String> fqns) {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection section) {
                DesignComponent component = this.getComponent();
                String layerName = MidpTypes.getString((PropertyValue)component.readProperty("layercd.prop.name"));
                section.getWriter().write("private Sprite " + layerName + ";\n");
                fqns.add("javax.microedition.lcdui.game.Sprite");
            }

            protected void generateClassBodyCode(StyledDocument document) {
                DesignComponent component = this.getComponent();
                MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(component.getComponentID() + "-getter"));
                String layerName = MidpTypes.getString((PropertyValue)component.readProperty("layercd.prop.name"));
                DesignComponent imageResource = component.readProperty("layercd.prop.imageresource").getComponent();
                String imageName = MidpTypes.getString((PropertyValue)imageResource.readProperty("imageresourcecd.prop.name"));
                int tileWidth = MidpTypes.getInteger((PropertyValue)component.readProperty("layercd.prop.tile.width"));
                int tileHeight = MidpTypes.getInteger((PropertyValue)component.readProperty("layercd.prop.tile.height"));
                DesignComponent defSeq = component.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
                String defSeqName = MidpTypes.getString((PropertyValue)defSeq.readProperty("sequncecd.prop.name"));
                section.getWriter().write("public Sprite " + CodeUtils.createGetterMethodName(layerName) + "() throws java.io.IOException {\n");
                section.getWriter().write("if (" + layerName + " == null) {\n");
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-preInit");
                section.getWriter().write(" // write pre-init user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write(layerName + " = new Sprite(" + CodeUtils.createGetterMethodName(imageName) + "(), " + tileWidth + ", " + tileHeight + ");\n");
                section.getWriter().write(layerName + ".setFrameSequence(" + defSeqName + ");\n");
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-postInit");
                section.getWriter().write(" // write post-init user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write("}\n");
                section.getWriter().write("\treturn " + layerName + ";\n");
                section.getWriter().write("}\n");
                section.getWriter().write("\n");
                section.getWriter().commit();
                section.close();
            }
        };
    }

    private static Set<Integer> getAnimatedTileIndexesFromTiledLayer(DesignComponent tiledLayer) {
        assert (tiledLayer.getType().equals((Object)TiledLayerCD.TYPEID));
        HashSet<Integer> animSet = new HashSet<Integer>();
        int[][] tiles = GameTypes.getTiles(tiledLayer.readProperty("tiledlayercd.prop.tiles"));
        for (int i = 0; i < tiles.length; ++i) {
            for (int j = 0; j < tiles[i].length; ++j) {
                int index = tiles[i][j];
                if (index >= 0) continue;
                animSet.add(index);
            }
        }
        return animSet;
    }

    private static Set<DesignComponent> getAnimatedTilesFromTiledLayer(DesignComponent tiledLayer) {
        HashSet<DesignComponent> finalSet = new HashSet<DesignComponent>();
        Set<Integer> animSet = GameCodeSupport.getAnimatedTileIndexesFromTiledLayer(tiledLayer);
        DesignComponent dcImgRes = tiledLayer.readProperty("layercd.prop.imageresource").getComponent();
        Collection children = dcImgRes.getComponents();
        for (DesignComponent child : children) {
            if (!child.getType().equals((Object)AnimatedTileCD.TYPEID) || !animSet.contains(MidpTypes.getInteger((PropertyValue)child.readProperty("animatedtilecd.prop.index")))) continue;
            finalSet.add(child);
        }
        return finalSet;
    }

    public static Presenter createTiledLayerCodePresenter(final List<String> fqns) {
        return new CodeClassLevelPresenter.Adapter(){

            protected void generateFieldSectionCode(MultiGuardedSection section) {
                DesignComponent component = this.getComponent();
                String layerName = MidpTypes.getString((PropertyValue)component.readProperty("layercd.prop.name"));
                section.getWriter().write("private TiledLayer " + layerName + ";\n");
                fqns.add("javax.microedition.lcdui.game.TiledLayer");
                Set ats = GameCodeSupport.getAnimatedTilesFromTiledLayer(component);
                for (DesignComponent animtile : ats) {
                    String animTileName = MidpTypes.getString((PropertyValue)animtile.readProperty("animatedtilecd.prop.name"));
                    section.getWriter().write("public int " + animTileName + CodeUtils.capitalize(layerName) + ";\n");
                }
            }

            protected void generateClassBodyCode(StyledDocument document) {
                DesignComponent component = this.getComponent();
                MultiGuardedSection section = MultiGuardedSection.create((StyledDocument)document, (String)(component.getComponentID() + "-getter"));
                String layerName = MidpTypes.getString((PropertyValue)component.readProperty("layercd.prop.name"));
                int[][] tiles = GameTypes.getTiles(component.readProperty("tiledlayercd.prop.tiles"));
                DesignComponent imageResource = component.readProperty("layercd.prop.imageresource").getComponent();
                String imageName = MidpTypes.getString((PropertyValue)imageResource.readProperty("imageresourcecd.prop.name"));
                int tileWidth = MidpTypes.getInteger((PropertyValue)component.readProperty("layercd.prop.tile.width"));
                int tileHeight = MidpTypes.getInteger((PropertyValue)component.readProperty("layercd.prop.tile.height"));
                section.getWriter().write("public TiledLayer " + CodeUtils.createGetterMethodName(layerName) + "() throws java.io.IOException {\n");
                section.getWriter().write("if (" + layerName + " == null) {\n");
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-preInit");
                section.getWriter().write(" // write pre-init user code here\n").commit();
                section.switchToGuarded();
                int cols = 0;
                if (tiles.length > 0) {
                    cols = tiles[0].length;
                }
                section.getWriter().write(layerName + " = new TiledLayer(" + cols + ", " + tiles.length + ", " + CodeUtils.createGetterMethodName(imageName) + "(), " + tileWidth + ", " + tileHeight + ");\n");
                Set ats = GameCodeSupport.getAnimatedTilesFromTiledLayer(component);
                for (DesignComponent animtile : ats) {
                    String animTileName = MidpTypes.getString((PropertyValue)animtile.readProperty("animatedtilecd.prop.name"));
                    DesignComponent defSeq = animtile.readProperty("sequencecontainer.prop.defaultsequence").getComponent();
                    String seqName = MidpTypes.getString((PropertyValue)defSeq.readProperty("sequncecd.prop.name"));
                    section.getWriter().write(animTileName + CodeUtils.capitalize(layerName) + " = " + layerName + ".createAnimatedTile(" + seqName + "[0]);\n");
                }
                HashMap<Integer, String> indexNames = new HashMap<Integer, String>();
                for (DesignComponent at : ats) {
                    indexNames.put(MidpTypes.getInteger((PropertyValue)at.readProperty("animatedtilecd.prop.index")), MidpTypes.getString((PropertyValue)at.readProperty("animatedtilecd.prop.name")));
                }
                section.getWriter().write("int[][] tiles = {\n");
                for (int rowIndex = 0; rowIndex < tiles.length; ++rowIndex) {
                    section.getWriter().write("{ ");
                    int[] row = tiles[rowIndex];
                    for (int columnIndex = 0; columnIndex < row.length; ++columnIndex) {
                        int tileIndex;
                        if (columnIndex > 0) {
                            section.getWriter().write(", ");
                        }
                        if ((tileIndex = row[columnIndex]) >= 0) {
                            section.getWriter().write(Integer.toString(row[columnIndex]));
                            continue;
                        }
                        String atName = (String)indexNames.get(tileIndex);
                        section.getWriter().write(atName + CodeUtils.capitalize(layerName));
                    }
                    if (rowIndex < tiles.length - 1) {
                        section.getWriter().write(" },\n");
                        continue;
                    }
                    section.getWriter().write(" }\n");
                }
                section.getWriter().write("};\n");
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-midInit");
                section.getWriter().write(" // write mid-init user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write("for (int row = 0; row < " + tiles.length + "; row++) {\n");
                section.getWriter().write("for (int col = 0; col < " + cols + "; col++) {\n");
                section.getWriter().write(layerName + ".setCell(col, row, tiles[row][col]);\n");
                section.getWriter().write("}\n");
                section.getWriter().write("}\n");
                section.getWriter().write("}\n");
                section.getWriter().commit();
                section.switchToEditable(this.getComponent().getComponentID() + "-postInit");
                section.getWriter().write(" // write post-init user code here\n").commit();
                section.switchToGuarded();
                section.getWriter().write("\treturn " + layerName + ";\n");
                section.getWriter().write("}\n");
                section.getWriter().write("\n");
                section.getWriter().commit();
                section.close();
            }
        };
    }
}

