/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.sequece;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceEditingPanelListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TileDataFlavor;
import org.openide.util.NbBundle;

public class SequenceEditingPanel
extends JComponent
implements Scrollable,
MouseMotionListener,
MouseListener,
SequenceListener {
    public static final boolean DEBUG = false;
    private static final int BOUNDARY_MIN = 10;
    private static final int SEPARATOR_WIDTH_MIN = 15;
    private static final Color COLOR_SEPARATOR_VERTICAL;
    private static final Color COLOR_SEPARATOR_HORIZONTAL;
    private Color backgroundColor = Color.WHITE;
    private static final int NONE = -1;
    private Sequence sequence;
    private SequenceContainer sequenceContainer;
    private JViewport viewPort;
    private int frameWidth;
    private int frameHeight;
    private int unitWidth;
    private int unitHeight;
    private int separatorWidth;
    private int separatorHeight;
    private int outlineWidth;
    private int outlineHeight;
    private boolean centerVertically;
    private boolean centerHorizontally;
    private Point start = new Point(0, 0);
    private Point transOutlineToFrame;
    private Point transFrameToSeparator;
    private Point transOutlineToSeparator;
    private Point transSeparatorToOutline;
    private int filmUnitWidth;
    private FrameSelectionManager selection;
    private int hilitedColumn = -1;
    EventListenerList listenerList = new EventListenerList();

    public SequenceEditingPanel(Sequence sequence) {
        this.setDoubleBuffered(true);
        this.sequence = sequence;
        this.selection = new FrameSelectionManager();
        this.sequence.addSequenceListener(this);
        this.sequence.addSequenceListener(this.selection);
        this.frameWidth = this.sequence.getFrameWidth();
        this.frameHeight = this.sequence.getFrameHeight();
        this.unitWidth = Math.max(this.frameWidth / 5, 10);
        this.unitHeight = Math.max(this.frameHeight / 5, 10);
        this.outlineWidth = this.frameWidth + this.unitWidth * 2;
        this.outlineHeight = this.frameHeight + this.unitHeight * 2;
        this.separatorWidth = Math.max(this.unitWidth, 15);
        this.transSeparatorToOutline = new Point(this.separatorWidth + this.unitWidth, 0);
        this.transOutlineToFrame = new Point(this.unitWidth, this.unitHeight);
        this.transFrameToSeparator = new Point(this.frameWidth + this.unitWidth * 2, -this.unitHeight);
        this.transOutlineToSeparator = new Point(this.unitWidth, 0);
        this.filmUnitWidth = this.transSeparatorToOutline.x + this.transOutlineToFrame.x + this.transFrameToSeparator.x;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        DropTarget dropTarget = new DropTarget(this, new SequenceDropTargetListener());
        dropTarget.setActive(true);
        this.setDropTarget(dropTarget);
        DragSource dragSource = new DragSource();
        DragGestureRecognizer dgr = dragSource.createDefaultDragGestureRecognizer(this, 1, new DGL());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setSequenceContainer(SequenceContainer sequenceContainer) {
        this.sequenceContainer = sequenceContainer;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int col = this.getColumnForPoint(event.getPoint());
        int frame = this.getFrameForColumn(col);
        if (frame == -1) {
            return null;
        }
        return NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.frame.tooltip", (Object[])new Object[]{frame, this.sequence.getFrame(frame).getIndex()});
    }

    private void updateHiLite(Point p) {
        this.handleMouseMoveOver(p);
    }

    public void setViewPort(JViewport viewPort) {
        this.viewPort = viewPort;
    }

    @Override
    public Dimension getPreferredSize() {
        int filmRollWidth = this.filmUnitWidth * this.sequence.getFrameCount() + this.transOutlineToSeparator.x + this.transSeparatorToOutline.x;
        int filmRollHeight = 10 + this.separatorHeight;
        int prefWidth = 0;
        int prefHeight = 0;
        if (this.viewPort != null && this.viewPort.getWidth() > filmRollWidth) {
            prefWidth += this.viewPort.getWidth();
        } else {
            prefWidth += filmRollWidth + 20;
            this.start.x = 10;
        }
        this.start.y = 10;
        return new Dimension(prefWidth, prefHeight += filmRollHeight);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(this.backgroundColor);
        g.setColor(COLOR_SEPARATOR_HORIZONTAL);
        g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
        this.start = new Point(this.separatorWidth, (this.getHeight() - this.outlineHeight) / 2);
        Point current = new Point(this.start);
        int col = 0;
        for (int i = 0; i < this.sequence.getFrameCount(); ++i) {
            this.drawSeparator(g, col, current);
            ++col;
            current.translate(this.transSeparatorToOutline.x, this.transSeparatorToOutline.y);
            this.drawOutline(g, i, current);
            current.translate(this.transOutlineToFrame.x, this.transOutlineToFrame.y);
            StaticTile frame = this.sequence.getFrame(i);
            this.drawFrame(g, frame, current);
            ++col;
            current.translate(this.transFrameToSeparator.x, this.transFrameToSeparator.y);
        }
        this.drawSeparator(g, col, current);
    }

    private void drawSeparator(Graphics2D g, int col, Point p) {
        Color c = this.hilitedColumn == col ? new Color(255, 235, 140) : this.backgroundColor;
        g.setColor(c);
        g.fillRect(p.x, 0, this.separatorWidth, this.getHeight() - 1);
        g.setColor(COLOR_SEPARATOR_VERTICAL);
        int x = p.x + this.separatorWidth / 2;
        g.drawLine(x, 0, x, this.getHeight() - 1);
    }

    private void drawOutline(Graphics2D g, int frameIndex, Point p) {
        int col = this.getColumnForFrame(frameIndex);
        int halfW = this.unitWidth / 2;
        int halfH = this.unitHeight / 2;
        if (this.selection.isFrameSelected(frameIndex)) {
            g.setColor(new Color(175, 195, 255));
            g.fillRect(p.x - this.unitWidth, p.y - this.unitHeight, this.outlineWidth + 2 * this.unitWidth, this.outlineHeight + 2 * this.unitHeight);
        }
        if (this.hilitedColumn == col) {
            g.setColor(new Color(255, 235, 140));
            g.fillRect(p.x - halfW, p.y - halfH, this.outlineWidth + this.unitWidth, this.outlineHeight + this.unitHeight);
        }
        g.setColor(Color.WHITE);
        g.fillRect(p.x, p.y, this.outlineWidth, this.outlineHeight);
    }

    private void drawFrame(Graphics2D g, StaticTile frame, Point p) {
        frame.paint(g, p.x, p.y);
    }

    private int getColumnForPoint(Point p) {
        if (p.x < this.start.x + this.transSeparatorToOutline.x) {
            return 0;
        }
        if (p.x > this.start.x + this.filmUnitWidth * this.sequence.getFrameCount()) {
            return this.getLastColIndex();
        }
        int filmUnit = (p.x - this.start.x) / this.filmUnitWidth;
        int offsetCol = 0;
        int offset = (p.x - this.start.x) % this.filmUnitWidth;
        offsetCol = offset < this.transSeparatorToOutline.x ? 0 : (offset < this.transSeparatorToOutline.x + this.outlineWidth ? 1 : 2);
        return 2 * filmUnit + offsetCol;
    }

    private Rectangle getAreaForColumn(int col) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = this.getHeight();
        if (col % 2 == 0) {
            if (col == 0) {
                width = this.start.x + this.transSeparatorToOutline.x;
            } else {
                x = this.start.x + this.sequence.getFrameCount() * this.filmUnitWidth - this.transOutlineToSeparator.x;
                width = col == this.getLastColIndex() ? this.getWidth() - x : this.transSeparatorToOutline.x + this.transOutlineToSeparator.x;
            }
        } else {
            x = this.start.x + this.transSeparatorToOutline.x + this.filmUnitWidth * (col / 2);
            width = this.outlineWidth;
        }
        return new Rectangle(x, y, width, height);
    }

    private int getLastColIndex() {
        return this.sequence.getFrameCount() * 2;
    }

    private int getColumnForFrame(int frameIndex) {
        return frameIndex * 2 + 1;
    }

    private int getFrameForColumn(int col) {
        if (col % 2 == 0) {
            return -1;
        }
        return (col - 1) / 2;
    }

    private int getColumnCount() {
        return this.getLastColIndex() + 1;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.handleMouseMoveOver(e.getPoint());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.handleMouseMoveOver(e.getPoint());
    }

    private void handleMouseMoveOver(Point p) {
        int old = this.hilitedColumn;
        this.hilitedColumn = this.getColumnForPoint(p);
        if (old != this.hilitedColumn) {
            int frame = this.getFrameForColumn(this.hilitedColumn);
            if (frame != -1) {
                this.fireFrameHilited(frame);
            }
            this.repaint();
        }
    }

    @Override
    public void frameAdded(Sequence sequence, int index) {
        this.revalidate();
        this.repaint();
        Rectangle r = index == this.sequence.getFrameCount() - 1 ? new Rectangle(new Point(this.getWidth() + this.filmUnitWidth, 0)) : this.getAreaForColumn(this.getColumnForFrame(index));
        this.scrollRectToVisible(r);
    }

    @Override
    public void frameRemoved(Sequence sequence, int index) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void frameModified(Sequence sequence, int index) {
        this.repaint(this.getAreaForColumn(this.getColumnForFrame(index)));
    }

    @Override
    public void framesChanged(Sequence sequence) {
        this.revalidate();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopUp(e);
        } else {
            int col = this.getColumnForPoint(e.getPoint());
            int f = this.getFrameForColumn(col);
            if (f == -1) {
                return;
            }
            if (this.isContinuousSelect(e)) {
                int anchor = this.selection.getAnchorSelectionIndex();
                if (anchor == -1) {
                    this.selection.setSelected(f, true);
                } else {
                    this.selection.setIntervalSelection(anchor, f, true);
                }
            } else if (this.isMultiSelect(e)) {
                this.selection.flipSelection(f);
            } else {
                boolean alreadySelected = this.selection.isFrameSelected(f);
                this.selection.clearSelections();
                this.selection.setSelected(f, !alreadySelected);
            }
            this.repaint();
            this.sequence.getGameDesign().getMainView().requestPreview(this.sequence.getFrame(f));
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopUp(e);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.hilitedColumn = -1;
        this.repaint();
        this.fireHiliteLost();
    }

    private boolean isMultiSelect(MouseEvent e) {
        return e.isControlDown();
    }

    private boolean isContinuousSelect(MouseEvent e) {
        return e.isShiftDown();
    }

    private void handlePopUp(MouseEvent e) {
        int col;
        JPopupMenu menu = new JPopupMenu();
        if (this.sequenceContainer != null) {
            for (Action a : this.sequenceContainer.getActionsForSequence(this.sequence)) {
                menu.add(a);
            }
            menu.addSeparator();
        }
        if (this.getFrameForColumn(col = this.getColumnForPoint(e.getPoint())) == -1) {
            for (Action a : this.getSeparatorActions(col)) {
                menu.add(a);
            }
        } else {
            for (Action a : this.getFrameActions(col)) {
                menu.add(a);
            }
        }
        menu.show(this, e.getX(), e.getY());
    }

    private List getFrameActions(int col) {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        SelectAllAction saa = new SelectAllAction();
        actions.add(saa);
        RemoveAction ra = new RemoveAction();
        if (this.sequence.getFrameCount() == 1 || this.selection.getSelectedIndexes().size() > 1) {
            ra.setEnabled(false);
        }
        ra.putValue("PROP_COL", new Integer(col));
        actions.add(ra);
        RemoveSelectedAction rsa = new RemoveSelectedAction();
        if (this.selection.isSelectionEmpty()) {
            rsa.setEnabled(false);
        }
        if (this.sequence.getFrameCount() <= this.selection.getSelectedIndexes().size() || this.selection.getSelectedIndexes().size() == 0) {
            rsa.setEnabled(false);
        }
        actions.add(rsa);
        return actions;
    }

    private List getSeparatorActions(int col) {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        TweenAction ta = new TweenAction();
        if (col == 0 || col == this.sequence.getFrameCount() * 2) {
            ta.setEnabled(false);
        }
        ta.putValue("PROP_COL", new Integer(col));
        actions.add(ta);
        InsertEmptyFrameAction iefa = new InsertEmptyFrameAction();
        iefa.putValue("PROP_COL", col);
        actions.add(iefa);
        return actions;
    }

    public synchronized void addSequenceEditingPanelListener(SequenceEditingPanelListener l) {
        this.listenerList.add(SequenceEditingPanelListener.class, l);
    }

    public synchronized void removeSequenceEditingPanelListener(SequenceEditingPanelListener l) {
        this.listenerList.remove(SequenceEditingPanelListener.class, l);
    }

    private void fireFrameHilited(int index) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SequenceEditingPanelListener.class) continue;
            ((SequenceEditingPanelListener)listeners[i + 1]).frameHilited(this, index);
        }
    }

    private void fireHiliteLost() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SequenceEditingPanelListener.class) continue;
            ((SequenceEditingPanelListener)listeners[i + 1]).hiliteLost(this);
        }
    }

    private void fireSelectioChange(int[] selectedFrameIdices) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SequenceEditingPanelListener.class) continue;
            ((SequenceEditingPanelListener)listeners[i + 1]).frameSelectionChange(this, selectedFrameIdices);
        }
    }

    static {
        COLOR_SEPARATOR_HORIZONTAL = COLOR_SEPARATOR_VERTICAL = new Color(204, 218, 228);
    }

    private class FrameSelectionManager
    implements SequenceListener {
        public static final int NONE = -1;
        private ArrayList<Boolean> frameSelections;
        private int anchorSelectionIndex = -1;
        private int leadSelectionIndex = -1;

        public FrameSelectionManager() {
            this.clearSelections();
        }

        public int getAnchorSelectionIndex() {
            return this.anchorSelectionIndex;
        }

        public int getLeadSelectionIndex() {
            return this.leadSelectionIndex;
        }

        public void clearSelections() {
            int size = SequenceEditingPanel.this.sequence.getFrameCount();
            this.frameSelections = new ArrayList();
            this.frameSelections.ensureCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.frameSelections.add(Boolean.FALSE);
            }
            this.anchorSelectionIndex = -1;
            this.leadSelectionIndex = -1;
        }

        public boolean flipSelection(int frame) {
            Boolean x = this.frameSelections.get(frame);
            if (x == null) {
                x = Boolean.FALSE;
            }
            x = x == false;
            this.frameSelections.set(frame, x);
            return x;
        }

        public void setSelected(int frame, boolean selected) {
            this.frameSelections.set(frame, selected);
            this.anchorSelectionIndex = selected ? frame : -1;
            this.leadSelectionIndex = -1;
        }

        public void setIntervalSelection(int startFrameInclusive, int endFrameInclusive, boolean selected) {
            if (startFrameInclusive <= endFrameInclusive) {
                for (int i = startFrameInclusive; i <= endFrameInclusive; ++i) {
                    this.frameSelections.set(i, selected);
                }
            } else {
                for (int i = startFrameInclusive; i >= endFrameInclusive; --i) {
                    this.frameSelections.set(i, selected);
                }
            }
            if (selected) {
                this.anchorSelectionIndex = startFrameInclusive;
                this.leadSelectionIndex = endFrameInclusive;
            }
        }

        public boolean isFrameSelected(int index) {
            Boolean selection = this.frameSelections.get(index);
            assert (selection != null);
            return selection;
        }

        public Set<Integer> getSelectedIndexes() {
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (int i = 0; i < this.frameSelections.size(); ++i) {
                if (!this.frameSelections.get(i).equals(Boolean.TRUE)) continue;
                indexes.add(i);
            }
            return indexes;
        }

        public boolean isSelectionEmpty() {
            return this.frameSelections.isEmpty();
        }

        @Override
        public void frameAdded(Sequence sequence, int index) {
            this.clearSelections();
            this.frameSelections.add(index, true);
        }

        @Override
        public void frameRemoved(Sequence sequence, int index) {
            this.frameSelections.remove(index);
            this.clearSelections();
        }

        @Override
        public void frameModified(Sequence sequence, int index) {
        }

        @Override
        public void framesChanged(Sequence sequence) {
            this.clearSelections();
        }
    }

    private class InsertEmptyFrameAction
    extends AbstractAction {
        public static final String PROP_COL = "PROP_COL";

        private InsertEmptyFrameAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuInsertFrame.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int separatorCol = (Integer)this.getValue(PROP_COL);
            int frameIndex = SequenceEditingPanel.this.getFrameForColumn(separatorCol + 1);
            Sequence seq = SequenceEditingPanel.this.sequence;
            seq.insertFrame(null, frameIndex);
        }
    }

    private class TweenAction
    extends AbstractAction {
        public static final String PROP_COL = "PROP_COL";

        private TweenAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuTweenFrames.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int indexAfter;
            int separatorCol = (Integer)this.getValue(PROP_COL);
            int beforeFrameIndex = SequenceEditingPanel.this.getFrameForColumn(separatorCol - 1);
            int afterFrameIndex = SequenceEditingPanel.this.getFrameForColumn(separatorCol + 1);
            Sequence seq = SequenceEditingPanel.this.sequence;
            StaticTile before = seq.getFrame(beforeFrameIndex);
            StaticTile after = seq.getFrame(afterFrameIndex);
            int indexBefore = before.getIndex();
            if (indexBefore == (indexAfter = after.getIndex()) || indexBefore == indexAfter + 1 || indexBefore == indexAfter - 1) {
                return;
            }
            int incr = 1;
            if (indexBefore > indexAfter) {
                incr = -1;
            }
            int insertIndex = afterFrameIndex;
            while ((indexBefore += incr) != indexAfter) {
                ImageResource imgRes = seq.getImageResource();
                StaticTile tile = (StaticTile)imgRes.getTile(indexBefore, SequenceEditingPanel.this.frameWidth, SequenceEditingPanel.this.frameHeight, seq.isZeroBasedIndex());
                seq.insertFrame(tile, insertIndex);
                SequenceEditingPanel.this.selection.setSelected(insertIndex, true);
                ++insertIndex;
            }
        }
    }

    private class RemoveSelectedAction
    extends AbstractAction {
        private RemoveSelectedAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuRemoveSelectedFrames.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Set<Integer> indexes = SequenceEditingPanel.this.selection.getSelectedIndexes();
            SequenceEditingPanel.this.sequence.removeFrames(indexes);
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public static final String PROP_COL = "PROP_COL";

        private RemoveAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuRemoveFrame.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int col = (Integer)this.getValue(PROP_COL);
            Sequence seq = SequenceEditingPanel.this.sequence;
            seq.removeFrame(SequenceEditingPanel.this.getFrameForColumn(col));
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
            this.putValue("Name", NbBundle.getMessage(SequenceEditingPanel.class, (String)"SequenceEditingPanel.menuSelectAll.txt"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Sequence seq = SequenceEditingPanel.this.sequence;
            SequenceEditingPanel.this.selection.setIntervalSelection(0, seq.getFrameCount() - 1, true);
            SequenceEditingPanel.this.repaint();
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            SequenceEditingPanel.this.validate();
        }
    }

    private class SequenceDropTargetListener
    implements DropTargetListener {
        private SequenceDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            SequenceEditingPanel.this.updateHiLite(dtde.getLocation());
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            SequenceEditingPanel.this.hilitedColumn = -1;
            SequenceEditingPanel.this.repaint();
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            block9: {
                Point dropPoint = dtde.getLocation();
                Transferable transferable = dtde.getTransferable();
                try {
                    TileDataFlavor tileFlavor = new TileDataFlavor();
                    if (transferable.isDataFlavorSupported(tileFlavor)) {
                        dtde.acceptDrop(1);
                        List tiles = (List)transferable.getTransferData(tileFlavor);
                        int col = SequenceEditingPanel.this.getColumnForPoint(dropPoint);
                        if (col % 2 == 0) {
                            for (int i = 0; i < tiles.size(); ++i) {
                                SequenceEditingPanel.this.sequence.insertFrame((StaticTile)tiles.get(i), (col + i * 2) / 2);
                            }
                        } else {
                            for (Tile tile : tiles) {
                                SequenceEditingPanel.this.sequence.setFrame((StaticTile)tile, SequenceEditingPanel.this.getFrameForColumn(col));
                            }
                        }
                        dtde.dropComplete(true);
                        break block9;
                    }
                    dtde.dropComplete(false);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    dtde.dropComplete(false);
                }
                catch (UnsupportedFlavorException e) {
                    e.printStackTrace();
                    dtde.dropComplete(false);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    dtde.dropComplete(false);
                }
            }
        }
    }

    private class DGL
    extends DragSourceAdapter
    implements DragGestureListener {
        private DGL() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            Point dragOrigin = dge.getDragOrigin();
            int col = SequenceEditingPanel.this.getColumnForPoint(dragOrigin);
            int frame = SequenceEditingPanel.this.getFrameForColumn(col);
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            super.dragDropEnd(dsde);
            if (dsde.getDropSuccess()) {
                // empty if block
            }
        }
    }
}

