/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileProxy;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.UiUtils;
import org.netbeans.installer.utils.XMLUtils;
import org.netbeans.installer.utils.exceptions.DownloadException;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.exceptions.ParseException;
import org.netbeans.installer.utils.helper.Context;
import org.netbeans.installer.utils.helper.FinishHandler;
import org.netbeans.installer.utils.helper.PropertyContainer;
import org.netbeans.installer.utils.helper.UiMode;
import org.netbeans.installer.wizard.components.WizardComponent;
import org.netbeans.installer.wizard.containers.SilentContainer;
import org.netbeans.installer.wizard.containers.SwingFrameContainer;
import org.netbeans.installer.wizard.containers.WizardContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wizard {
    private static Wizard instance;
    private static String componentsInstanceUri;
    private static String componentsSchemaUri;
    private List<WizardComponent> components;
    private WizardContainer container;
    private PropertyContainer propertyContainer;
    private Context context = new Context();
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private int index = -1;
    private Wizard parent;
    private FinishHandler finishHandler;
    private boolean blocking = false;
    public static final String COMPONENTS_INSTANCE_URI_PROPERTY = "nbi.wizard.components.instance.uri";
    public static final String DEFAULT_COMPONENTS_INSTANCE_URI = "resource:org/netbeans/installer/wizard/wizard-components.xml";
    public static final String COMPONENTS_SCHEMA_URI_PROPERTY = "nbi.wizard.components.schema.uri";
    public static final String DEFAULT_COMPONENTS_SCHEMA_URI = "resource:org/netbeans/installer/wizard/wizard-components.xsd";
    public static final String TAG_COMPONENTS = "components";
    public static final String TAG_COMPONENT = "component";
    public static final String TAG_PROPERTIES = "properties";
    public static final String ATTRIBUTE_CLASS = "class";
    public static final String CURRENT_COMPONENT_CLASSNAME_PROPERTY = "nbi.wizard.current.component.classname";
    private static final String RESOURCE_FAILED_TO_CREATE_INSTANCE = "W.error.failed.to.create.instance";
    private static final String RESOURCE_FAILED_TO_LOAD_COMPONENTS = "W.error.failed.to.load.components";
    private static final String RESOURCE_FAILED_TO_LOAD_COMPONENT = "W.error.failed.to.load.component";
    private static final String RESOURCE_UNKNOWN_UI_MODE = "W.error.unknown.ui.mode";
    private static final String RESOURCE_CANNOT_MOVE_BACKWARD_AT_FIRST = "W.error.cannot.move.backward.at.first";
    private static final String RESOURCE_PARSER_UNSUPPORTS_SCHEMAS = "W.error.parser.unsupports.schemas";
    private static final String RESOURCE_INTERRUPTED = "W.error.interrupted";

    public static synchronized Wizard getInstance() {
        if (instance == null) {
            componentsInstanceUri = System.getProperty(COMPONENTS_INSTANCE_URI_PROPERTY) != null ? System.getProperty(COMPONENTS_INSTANCE_URI_PROPERTY) : DEFAULT_COMPONENTS_INSTANCE_URI;
            componentsSchemaUri = System.getProperty(COMPONENTS_SCHEMA_URI_PROPERTY) != null ? System.getProperty(COMPONENTS_SCHEMA_URI_PROPERTY) : DEFAULT_COMPONENTS_SCHEMA_URI;
            instance = new Wizard();
            try {
                Wizard.instance.components = Wizard.loadWizardComponents(componentsInstanceUri);
            }
            catch (InitializationException e) {
                ErrorManager.notifyCritical(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_CREATE_INSTANCE), e);
            }
        }
        return instance;
    }

    public static List<WizardComponent> loadWizardComponents(String componentsUri) throws InitializationException {
        return Wizard.loadWizardComponents(componentsUri, Wizard.class.getClassLoader());
    }

    public static List<WizardComponent> loadWizardComponents(String componentsUri, ClassLoader classLoader) throws InitializationException {
        try {
            File schemaFile = FileProxy.getInstance().getFile(componentsSchemaUri, classLoader, true);
            File componentsFile = FileProxy.getInstance().getFile(componentsUri, classLoader, true);
            Schema schema = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFile);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                factory.setSchema(schema);
            }
            catch (UnsupportedOperationException e) {
                ErrorManager.notifyDebug(ResourceUtils.getString(Wizard.class, RESOURCE_PARSER_UNSUPPORTS_SCHEMAS, factory.getClass()), e);
            }
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse(componentsFile);
            return Wizard.loadWizardComponents(document.getDocumentElement(), classLoader);
        }
        catch (DownloadException e) {
            throw new InitializationException(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_LOAD_COMPONENTS, componentsUri, classLoader), e);
        }
        catch (ParserConfigurationException e) {
            throw new InitializationException(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_LOAD_COMPONENTS, componentsUri, classLoader), e);
        }
        catch (SAXException e) {
            throw new InitializationException(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_LOAD_COMPONENTS, componentsUri, classLoader), e);
        }
        catch (IOException e) {
            throw new InitializationException(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_LOAD_COMPONENTS, componentsUri, classLoader), e);
        }
    }

    private static List<WizardComponent> loadWizardComponents(Element element, ClassLoader classLoader) throws InitializationException {
        LinkedList<WizardComponent> components = new LinkedList<WizardComponent>();
        for (Element child : XMLUtils.getChildren(element, TAG_COMPONENT)) {
            components.add(Wizard.loadWizardComponent(child, classLoader));
        }
        return components;
    }

    private static WizardComponent loadWizardComponent(Element element, ClassLoader classLoader) throws InitializationException {
        WizardComponent component;
        try {
            component = (WizardComponent)classLoader.loadClass(element.getAttribute(ATTRIBUTE_CLASS)).newInstance();
            Element child = XMLUtils.getChild(element, TAG_COMPONENTS);
            if (child != null) {
                component.addChildren(Wizard.loadWizardComponents(child, classLoader));
            }
            if ((child = XMLUtils.getChild(element, TAG_PROPERTIES)) != null) {
                component.getProperties().putAll((Map<?, ?>)XMLUtils.parseNbiProperties(child));
            }
        }
        catch (ParseException e) {
            throw new InitializationException(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_LOAD_COMPONENT, element, classLoader), e);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_LOAD_COMPONENT, element, classLoader), e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationException(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_LOAD_COMPONENT, element, classLoader), e);
        }
        catch (InstantiationException e) {
            throw new InitializationException(ResourceUtils.getString(Wizard.class, RESOURCE_FAILED_TO_LOAD_COMPONENT, element, classLoader), e);
        }
        return component;
    }

    public Wizard() {
    }

    public Wizard(Wizard parent) {
        this();
        this.parent = parent;
        if (this.parent != null) {
            this.container = parent.container;
            this.propertyContainer = parent.propertyContainer;
            this.context = new Context(parent.context);
            this.classLoader = parent.classLoader;
            this.finishHandler = parent.finishHandler;
        }
    }

    public Wizard(Wizard parent, List<WizardComponent> components, int index) {
        this(parent);
        this.components = components;
        this.index = index;
    }

    public Wizard(Wizard parent, List<WizardComponent> components, int index, PropertyContainer propertyContainer, ClassLoader classLoader) {
        this(parent, components, index);
        this.propertyContainer = propertyContainer;
        this.classLoader = classLoader;
    }

    private WizardContainer newWizardContainer() {
        switch (UiMode.getCurrentUiMode()) {
            case SWING: {
                try {
                    UiUtils.initializeLookAndFeel();
                }
                catch (InitializationException e) {
                    ErrorManager.notifyWarning(e.getMessage(), e.getCause());
                }
                return new SwingFrameContainer();
            }
            case SILENT: {
                return new SilentContainer();
            }
        }
        ErrorManager.notifyCritical(ResourceUtils.getString(Wizard.class, RESOURCE_UNKNOWN_UI_MODE, new Object[]{UiMode.getCurrentUiMode()}));
        return null;
    }

    public void open() {
        if (this.parent != null) {
            this.parent.open();
            return;
        }
        this.container = this.newWizardContainer();
        if (this.container != null) {
            this.container.open();
        }
        this.next();
    }

    public void openBlocking() {
        this.blocking = true;
        this.open();
        while (this.blocking) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                ErrorManager.notifyDebug(ResourceUtils.getString(Wizard.class, RESOURCE_INTERRUPTED), e);
            }
        }
    }

    public void close() {
        if (this.parent != null) {
            this.parent.close();
            return;
        }
        if (this.container != null) {
            this.container.close();
        }
        if (this.blocking) {
            this.blocking = false;
            this.notifyAll();
        }
    }

    public void next() {
        WizardComponent component = this.getNext();
        if (component != null) {
            this.index = this.components.indexOf(component);
            component.setWizard(this);
            component.initialize();
            if (this.container != null) {
                this.container.updateWizardUi(component.getWizardUi());
            }
            System.setProperty(CURRENT_COMPONENT_CLASSNAME_PROPERTY, component.getClass().getName());
            component.executeForward();
        } else if (this.parent != null) {
            this.parent.next();
        } else {
            this.finishHandler.finish();
        }
    }

    public void previous() {
        WizardComponent component = this.getPrevious();
        if (component != null) {
            this.index = this.components.indexOf(component);
            component.setWizard(this);
            component.initialize();
            if (this.container != null) {
                this.container.updateWizardUi(component.getWizardUi());
            }
            System.setProperty(CURRENT_COMPONENT_CLASSNAME_PROPERTY, component.getClass().getName());
            component.executeBackward();
        } else if (this.parent != null) {
            this.parent.previous();
        } else {
            ErrorManager.notifyCritical(ResourceUtils.getString(Wizard.class, RESOURCE_CANNOT_MOVE_BACKWARD_AT_FIRST));
        }
    }

    public boolean hasNext() {
        return this.getNext() != null || this.parent != null && this.parent.hasNext();
    }

    public boolean hasPrevious() {
        if (this.getCurrent() != null && this.getCurrent().isPointOfNoReturn()) {
            return false;
        }
        for (int i = this.index - 1; i > -1; --i) {
            WizardComponent component = this.components.get(i);
            if (component.canExecuteBackward()) {
                return true;
            }
            if (!component.isPointOfNoReturn()) continue;
            return false;
        }
        return this.parent != null && this.parent.hasPrevious();
    }

    public int getIndex() {
        return this.index;
    }

    public WizardContainer getContainer() {
        return this.container;
    }

    public String getProperty(String name) {
        return this.propertyContainer.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.propertyContainer.setProperty(name, value);
    }

    public Context getContext() {
        return this.context;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public FinishHandler getFinishHandler() {
        return this.finishHandler;
    }

    public void setFinishHandler(FinishHandler finishHandler) {
        this.finishHandler = finishHandler;
    }

    public Wizard createSubWizard(List<WizardComponent> components, int index) {
        return new Wizard(this, components, index);
    }

    public Wizard createSubWizard(List<WizardComponent> components, int index, PropertyContainer propertyContainer, ClassLoader classLoader) {
        return new Wizard(this, components, index, propertyContainer, classLoader);
    }

    private WizardComponent getCurrent() {
        if (this.index > -1 && this.index < this.components.size()) {
            return this.components.get(this.index);
        }
        return null;
    }

    private WizardComponent getPrevious() {
        if (this.getCurrent() != null && this.getCurrent().isPointOfNoReturn()) {
            return null;
        }
        for (int i = this.index - 1; i > -1; --i) {
            WizardComponent component = this.components.get(i);
            if (component.canExecuteBackward()) {
                return component;
            }
            if (!component.isPointOfNoReturn()) continue;
            return null;
        }
        return null;
    }

    private WizardComponent getNext() {
        for (int i = this.index + 1; i < this.components.size(); ++i) {
            WizardComponent component = this.components.get(i);
            if (!component.canExecuteForward()) continue;
            return component;
        }
        return null;
    }
}

