/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.calendar;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.calendar.Calendar;
import org.primefaces.component.calendar.CalendarUtils;
import org.primefaces.event.DateSelectEvent;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.ComponentUtils;

public class CalendarRenderer
extends InputRenderer {
    public void decode(FacesContext context, UIComponent component) {
        Calendar calendar = (Calendar)component;
        if (calendar.isDisabled() || calendar.isReadonly()) {
            return;
        }
        this.decodeBehaviors(context, (UIComponent)calendar);
        String param = calendar.getClientId(context) + "_input";
        String submittedValue = (String)context.getExternalContext().getRequestParameterMap().get(param);
        if (submittedValue != null) {
            calendar.setSubmittedValue(submittedValue);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Calendar calendar = (Calendar)component;
        String value = CalendarUtils.getValueAsString(context, calendar);
        this.encodeMarkup(context, calendar, value);
        this.encodeScript(context, calendar, value);
    }

    protected void encodeMarkup(FacesContext context, Calendar calendar, String value) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = calendar.getClientId(context);
        String inputId = clientId + "_input";
        writer.startElement("span", (UIComponent)calendar);
        writer.writeAttribute("id", (Object)clientId, null);
        if (calendar.getStyle() != null) {
            writer.writeAttribute("style", (Object)calendar.getStyle(), null);
        }
        if (calendar.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)calendar.getStyleClass(), null);
        }
        if (!calendar.isPopup()) {
            writer.startElement("div", null);
            writer.writeAttribute("id", (Object)(clientId + "_inline"), null);
            writer.endElement("div");
        }
        String type = calendar.isPopup() ? "text" : "hidden";
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)inputId, null);
        writer.writeAttribute("name", (Object)inputId, null);
        writer.writeAttribute("type", (Object)type, null);
        if (!this.isValueBlank(value)) {
            writer.writeAttribute("value", (Object)value, null);
        }
        if (calendar.isPopup()) {
            String inputStyleClass = calendar.getInputStyleClass();
            inputStyleClass = inputStyleClass == null ? "ui-inputfield ui-widget ui-state-default ui-corner-all" : "ui-inputfield ui-widget ui-state-default ui-corner-all " + inputStyleClass;
            writer.writeAttribute("class", (Object)inputStyleClass, null);
            if (calendar.getInputStyle() != null) {
                writer.writeAttribute("style", (Object)calendar.getInputStyle(), null);
            }
            if (calendar.isReadOnlyInputText()) {
                writer.writeAttribute("readonly", (Object)"readonly", null);
            }
            if (calendar.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            this.renderPassThruAttributes(context, (UIComponent)calendar, Calendar.INPUT_TEXT_ATTRS);
        }
        writer.endElement("input");
        writer.endElement("span");
    }

    protected void encodeScript(FacesContext context, Calendar calendar, String value) throws IOException {
        String showOn;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = calendar.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        writer.write(calendar.resolveWidgetVar() + " = new PrimeFaces.widget.Calendar('" + clientId + "', {");
        writer.write("popup:" + calendar.isPopup());
        writer.write(",locale:'" + calendar.calculateLocale(context).toString() + "'");
        if (!this.isValueBlank(value)) {
            writer.write(",defaultDate:'" + value + "'");
        }
        if (calendar.getPattern() != null) {
            writer.write(",dateFormat:'" + CalendarUtils.convertPattern(calendar.getPattern()) + "'");
        }
        if (calendar.getPages() != 1) {
            writer.write(",numberOfMonths:" + calendar.getPages());
        }
        if (calendar.getMindate() != null) {
            writer.write(",minDate:'" + CalendarUtils.getDateAsString(calendar, calendar.getMindate()) + "'");
        }
        if (calendar.getMaxdate() != null) {
            writer.write(",maxDate:'" + CalendarUtils.getDateAsString(calendar, calendar.getMaxdate()) + "'");
        }
        if (calendar.isShowButtonPanel()) {
            writer.write(",showButtonPanel:true");
        }
        if (calendar.isShowWeek()) {
            writer.write(",showWeek:true");
        }
        if (calendar.isDisabled()) {
            writer.write(",disabled:true");
        }
        if (calendar.getYearRange() != null) {
            writer.write(",yearRange:'" + calendar.getYearRange() + "'");
        }
        if (calendar.isNavigator()) {
            writer.write(",changeMonth:true");
            writer.write(",changeYear:true");
        }
        if (calendar.getEffect() != null) {
            writer.write(",showAnim:'" + calendar.getEffect() + "'");
            writer.write(",duration:'" + calendar.getEffectDuration() + "'");
        }
        if (!(showOn = calendar.getShowOn()).equalsIgnoreCase("focus")) {
            String iconSrc = calendar.getPopupIcon() != null ? this.getResourceURL(context, calendar.getPopupIcon()) : this.getResourceRequestPath(context, Calendar.POPUP_ICON);
            writer.write(",showOn:'" + showOn + "'");
            writer.write(",buttonImage:'" + iconSrc + "'");
            writer.write(",buttonImageOnly:" + calendar.isPopupIconOnly());
        }
        if (calendar.isShowOtherMonths()) {
            writer.write(",showOtherMonths:true");
            writer.write(",selectOtherMonths:" + calendar.isSelectOtherMonths());
        }
        if (calendar.getSelectListener() != null) {
            UIComponent form = ComponentUtils.findParentForm(context, (UIComponent)calendar);
            if (form == null) {
                throw new FacesException("Calendar \"" + calendar.getClientId(context) + "\" must be enclosed with a form when using ajax selection.");
            }
            writer.write(",formId:'" + form.getClientId(context) + "'");
            writer.write(",url:'" + this.getActionURL(context) + "'");
            writer.write(",hasSelectListener:true");
            String onSelectProcess = calendar.getOnSelectProcess();
            onSelectProcess = onSelectProcess == null ? clientId : ComponentUtils.findClientIds(context, (UIComponent)calendar, onSelectProcess);
            writer.write(",onSelectProcess:'" + onSelectProcess + "'");
            if (calendar.getOnSelectUpdate() != null) {
                writer.write(",onSelectUpdate:'" + ComponentUtils.findClientIds(context, (UIComponent)calendar, calendar.getOnSelectUpdate()) + "'");
            }
        }
        this.encodeClientBehaviors(context, (ClientBehaviorHolder)calendar);
        writer.write("});});");
        writer.endElement("script");
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object value) throws ConverterException {
        Calendar calendar = (Calendar)component;
        String submittedValue = (String)value;
        if (this.isValueBlank(submittedValue)) {
            return null;
        }
        if (calendar.getConverter() != null) {
            return calendar.getConverter().getAsObject(context, (UIComponent)calendar, submittedValue);
        }
        try {
            Locale locale = calendar.calculateLocale(context);
            SimpleDateFormat format = new SimpleDateFormat(calendar.getPattern(), locale);
            format.setTimeZone(calendar.calculateTimeZone());
            Date convertedValue = format.parse(submittedValue);
            if (calendar.isInstantSelection()) {
                calendar.queueEvent(new DateSelectEvent((UIComponent)calendar, convertedValue));
            }
            return convertedValue;
        }
        catch (ParseException e) {
            throw new ConverterException((Throwable)e);
        }
    }
}

