/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorDataProviderAccessor;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;

public abstract class IndicatorDataProvider<T extends IndicatorDataProviderConfiguration>
implements DLightTargetListener,
Validateable<DLightTarget>,
DataFilterListener {
    private final CopyOnWriteArrayList<IndicatorNotificationsListener> notificationListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<ValidationListener> validationListeners = new CopyOnWriteArrayList();
    private final AtomicBoolean hasListeners = new AtomicBoolean(false);
    private ServiceInfoDataStorage serviceInfoDataStorage;
    private DLightTarget validatedTarget = null;
    private ValidationStatus validationStatus;
    private final String NAME;

    public IndicatorDataProvider(String name) {
        this.NAME = name;
        this.validationStatus = ValidationStatus.initialStatus();
    }

    private synchronized void addIndicatorDataProviderListener(IndicatorNotificationsListener l) {
        boolean added = this.notificationListeners.addIfAbsent(l);
        if (this.hasListeners.compareAndSet(false, added)) {
            this.resume();
        }
    }

    private synchronized void removeIndicatorDataProviderListener(IndicatorNotificationsListener l) {
        boolean removed = this.notificationListeners.remove(l);
        if (removed && this.notificationListeners.isEmpty() && this.hasListeners.compareAndSet(true, false)) {
            this.pause();
        }
    }

    @Override
    public final synchronized ValidationStatus validate(DLightTarget target) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus oldStatus = this.validationStatus;
        ValidationStatus newStatus = this.doValidation(target);
        this.notifyStatusChanged(oldStatus, newStatus);
        this.validatedTarget = target;
        this.validationStatus = newStatus;
        return newStatus;
    }

    protected abstract ValidationStatus doValidation(DLightTarget var1);

    @Override
    public final synchronized void invalidate() {
        ValidationStatus oldStatus = this.validationStatus;
        this.validationStatus = ValidationStatus.initialStatus();
        this.validatedTarget = null;
        this.notifyStatusChanged(oldStatus, this.validationStatus);
    }

    @Override
    public final synchronized ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    @Override
    public final void addValidationListener(ValidationListener listener) {
        this.validationListeners.addIfAbsent(listener);
    }

    @Override
    public final void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    private void notifyStatusChanged(ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (oldStatus.equals(newStatus)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged(this, oldStatus, newStatus);
        }
    }

    @Override
    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.targetStarted(event.target);
                break;
            }
            case DONE: 
            case FAILED: 
            case STOPPED: 
            case TERMINATED: {
                this.targetFinished(event.target);
            }
        }
    }

    protected void targetStarted(DLightTarget target) {
    }

    protected void targetFinished(DLightTarget target) {
    }

    public final boolean subscribe(Indicator<?> indicator) {
        List<DataTableMetadata.Column> indicatorColumns = IndicatorAccessor.getDefault().getMetadataColumns(indicator);
        for (DataTableMetadata tdm : this.getDataTablesMetadata()) {
            if (tdm == null) continue;
            List<DataTableMetadata.Column> providedColumns = tdm.getColumns();
            for (DataTableMetadata.Column pcol : providedColumns) {
                for (DataTableMetadata.Column icol : indicatorColumns) {
                    if (!icol.equals(pcol)) continue;
                    indicator.columnProvided(icol);
                    this.addIndicatorDataProviderListener(indicator);
                    return true;
                }
            }
        }
        return false;
    }

    public final void unsubscribe(Indicator<?> indicator) {
        this.removeIndicatorDataProviderListener(indicator);
    }

    protected final void resetIndicators() {
        for (IndicatorNotificationsListener l : this.notificationListeners) {
            l.reset();
        }
    }

    protected final void notifyIndicators(List<DataRow> data) {
        for (IndicatorNotificationsListener l : this.notificationListeners) {
            l.updated(data);
        }
    }

    protected final void suggestIndicatorsRepaint() {
        for (IndicatorNotificationsListener l : this.notificationListeners) {
            l.suggestRepaint();
        }
    }

    public abstract List<DataTableMetadata> getDataTablesMetadata();

    public final String getName() {
        return this.NAME;
    }

    public final void init(ServiceInfoDataStorage infoStorage) {
        this.serviceInfoDataStorage = infoStorage;
    }

    protected final ServiceInfoDataStorage getServiceInfoDataStorage() {
        return this.serviceInfoDataStorage;
    }

    protected void pause() {
    }

    protected void resume() {
    }

    static {
        IndicatorDataProviderAccessor.setDefault(new IndicatorDataProviderAccessorImpl());
    }

    private static final class IndicatorDataProviderAccessorImpl
    extends IndicatorDataProviderAccessor {
        private IndicatorDataProviderAccessorImpl() {
        }

        @Override
        public void addIndicatorDataProviderListener(IndicatorDataProvider<?> provider, IndicatorNotificationsListener l) {
            ((IndicatorDataProvider)provider).addIndicatorDataProviderListener(l);
        }

        @Override
        public void removeIndicatorDataProviderListener(IndicatorDataProvider<?> provider, IndicatorNotificationsListener l) {
            ((IndicatorDataProvider)provider).removeIndicatorDataProviderListener(l);
        }
    }
}

