/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.indicator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.dlight.api.impl.IndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorActionDescriptor;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;

public abstract class IndicatorConfiguration {
    private final IndicatorMetadata metadata;
    private final int position;
    private final List<VisualizerConfiguration> visualizerConfigurations;
    private final List<IndicatorActionDescriptor> actionDescriptors;
    private IndicatorActionDescriptor defaultActionDescriptor;
    private boolean visible;

    public IndicatorConfiguration(IndicatorMetadata metadata, int position, boolean visible) {
        this.metadata = metadata;
        this.position = position;
        this.visible = visible;
        this.visualizerConfigurations = new ArrayList<VisualizerConfiguration>();
        this.actionDescriptors = new ArrayList<IndicatorActionDescriptor>();
    }

    public IndicatorConfiguration(IndicatorMetadata metadata) {
        this(metadata, 0, true);
    }

    public abstract String getID();

    public final void addVisualizerConfiguration(VisualizerConfiguration configuration) {
        if (configuration != null && !this.visualizerConfigurations.contains(configuration)) {
            this.visualizerConfigurations.add(configuration);
        }
    }

    public final void addActionDescription(IndicatorActionDescriptor descr) {
        if (descr != null && !this.actionDescriptors.contains(descr)) {
            this.actionDescriptors.add(descr);
        }
    }

    public final void setDefaultActionDescription(IndicatorActionDescriptor descr) {
        this.defaultActionDescriptor = descr;
        this.addActionDescription(descr);
    }

    @Deprecated
    public final void setActionDisplayName(String actionDisplayName) {
        String tooltip = null;
        if (this.defaultActionDescriptor != null) {
            this.actionDescriptors.remove(this.defaultActionDescriptor);
            tooltip = this.defaultActionDescriptor.getTooltip();
        }
        this.defaultActionDescriptor = new IndicatorActionDescriptor(actionDisplayName, tooltip, null);
        this.setDefaultActionDescription(this.defaultActionDescriptor);
    }

    @Deprecated
    public final void setActionTooltip(String actionTooltip) {
        String displayName = null;
        if (this.defaultActionDescriptor != null) {
            this.actionDescriptors.remove(this.defaultActionDescriptor);
            displayName = this.defaultActionDescriptor.getDisplayName();
        }
        this.defaultActionDescriptor = new IndicatorActionDescriptor(displayName, actionTooltip, null);
        this.setDefaultActionDescription(this.defaultActionDescriptor);
    }

    protected final IndicatorMetadata getIndicatorMetadata() {
        return this.metadata;
    }

    protected final int getIndicatorPosition() {
        return this.position;
    }

    protected final List<VisualizerConfiguration> getVisualizerConfigurations() {
        return Collections.unmodifiableList(this.visualizerConfigurations);
    }

    private IndicatorActionDescriptor getDefaultActionDescriptor() {
        if (this.defaultActionDescriptor != null) {
            return this.defaultActionDescriptor;
        }
        if (!this.actionDescriptors.isEmpty()) {
            return this.actionDescriptors.get(0);
        }
        return null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    static {
        IndicatorConfigurationAccessor.setDefault(new IndicatorConfigurationAccessorImpl());
    }

    private static final class IndicatorConfigurationAccessorImpl
    extends IndicatorConfigurationAccessor {
        private IndicatorConfigurationAccessorImpl() {
        }

        @Override
        public IndicatorMetadata getIndicatorMetadata(IndicatorConfiguration configuration) {
            return configuration.getIndicatorMetadata();
        }

        @Override
        public int getIndicatorPosition(IndicatorConfiguration configuration) {
            return configuration.getIndicatorPosition();
        }

        @Override
        public List<VisualizerConfiguration> getVisualizerConfigurations(IndicatorConfiguration configuration) {
            return configuration.getVisualizerConfigurations();
        }

        @Override
        public List<IndicatorActionDescriptor> getActionDescriptors(IndicatorConfiguration configuration) {
            return Collections.unmodifiableList(configuration.actionDescriptors);
        }

        @Override
        public IndicatorActionDescriptor getDefaultActionDescriptor(IndicatorConfiguration configuration) {
            return configuration.getDefaultActionDescriptor();
        }
    }
}

