/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearch;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.openide.ErrorManager;

final class JavadocSearchEngineImpl
extends JavadocSearchEngine {
    private final List<IndexSearchThread> tasks = new ArrayList<IndexSearchThread>();
    private IndexSearchThread.DocIndexItemConsumer diiConsumer;
    private boolean isStopped = false;

    JavadocSearchEngineImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void search(String[] items, final JavadocSearchEngine.SearchEngineCallback callback) throws NoJavadocException {
        IndexSearchThread[] tasksArray;
        Object st;
        this.diiConsumer = new IndexSearchThread.DocIndexItemConsumer(){

            @Override
            public void addDocIndexItem(DocIndexItem dii) {
                callback.addItem(dii);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void indexSearchThreadFinished(IndexSearchThread t) {
                boolean isEmpty;
                JavadocSearchEngineImpl javadocSearchEngineImpl = JavadocSearchEngineImpl.this;
                synchronized (javadocSearchEngineImpl) {
                    IndexSearch.LOG.log(Level.FINE, "JavadocSearchEngineImpl.indexSearchThreadFinished: tasks: {0}", JavadocSearchEngineImpl.this.tasks.size());
                    JavadocSearchEngineImpl.this.tasks.remove(t);
                    isEmpty = JavadocSearchEngineImpl.this.tasks.isEmpty();
                }
                if (isEmpty) {
                    callback.finished();
                }
            }
        };
        URL[] docRoots = JavadocRegistry.getDefault().getDocRoots();
        JavadocSearchEngineImpl javadocSearchEngineImpl = this;
        synchronized (javadocSearchEngineImpl) {
            if (this.isStopped) {
                return;
            }
        }
        if (docRoots.length <= 0) {
            callback.finished();
            throw new NoJavadocException();
        }
        String toFind = items[0];
        for (int i = 0; i < docRoots.length; ++i) {
            st = JavadocRegistry.getDefault().findSearchType(docRoots[i]);
            if (st == null) {
                ErrorManager.getDefault().log("NO Search type for " + docRoots[i]);
                continue;
            }
            URL indexFo = ((JavadocSearchType)st).getDocFileObject(docRoots[i]);
            if (indexFo == null) {
                ErrorManager.getDefault().log("NO Index files fot " + docRoots[i]);
                continue;
            }
            IndexSearchThread searchThread = ((JavadocSearchType)st).getSearchThread(toFind, indexFo, this.diiConsumer);
            JavadocSearchEngineImpl javadocSearchEngineImpl2 = this;
            synchronized (javadocSearchEngineImpl2) {
                if (this.isStopped) {
                    return;
                }
                this.tasks.add(searchThread);
                continue;
            }
        }
        st = this;
        synchronized (st) {
            tasksArray = this.tasks.toArray(new IndexSearchThread[this.tasks.size()]);
        }
        for (IndexSearchThread searchThread : tasksArray) {
            if (this.isStopped) {
                return;
            }
            searchThread.go();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        boolean noTask;
        IndexSearchThread[] tasksArray = null;
        JavadocSearchEngineImpl javadocSearchEngineImpl = this;
        synchronized (javadocSearchEngineImpl) {
            if (this.isStopped) {
                return;
            }
            this.isStopped = true;
            noTask = this.tasks.isEmpty();
            if (!noTask) {
                tasksArray = this.tasks.toArray(new IndexSearchThread[this.tasks.size()]);
            }
        }
        IndexSearch.LOG.fine("JavadocSearchEngineImpl.stop");
        if (noTask) {
            this.diiConsumer.indexSearchThreadFinished(null);
            return;
        }
        for (IndexSearchThread searchThread : tasksArray) {
            searchThread.finish();
        }
    }
}

