/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ACCESS;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.FORM;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.INL;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.VIRTUALITY;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.VIS;

public class DwarfAttribute {
    public final ATTR attrName;
    public final FORM valueForm;

    public DwarfAttribute(int nameOrdinal, int formOrdinal) {
        this.attrName = ATTR.get(nameOrdinal);
        this.valueForm = FORM.get(formOrdinal);
    }

    public void dump(PrintStream out, Object value) {
        out.print("\t" + (Object)((Object)this.attrName) + " [" + (Object)((Object)this.valueForm) + "]");
        if (value != null) {
            if (this.valueForm == FORM.DW_FORM_ref4) {
                out.printf(" <%x>", value);
            } else if (this.valueForm == FORM.DW_FORM_block1) {
                byte[] data = (byte[])value;
                out.printf(" %d bytes: ", data.length);
                for (int i = 0; i < data.length; ++i) {
                    out.printf(" 0x%x", data[i]);
                }
            } else if (this.attrName == ATTR.DW_AT_inline && this.valueForm == FORM.DW_FORM_data1) {
                out.printf(" %s", value.toString());
                INL inl = INL.get(((Byte)value).byteValue());
                if (inl != null) {
                    out.printf(" %s", inl.toString());
                }
            } else if (this.attrName == ATTR.DW_AT_visibility && this.valueForm == FORM.DW_FORM_data1) {
                out.printf(" %s", value.toString());
                VIS vis = VIS.get(((Byte)value).byteValue());
                if (vis != null) {
                    out.printf(" %s", vis.toString());
                }
            } else if (this.attrName == ATTR.DW_AT_virtuality && this.valueForm == FORM.DW_FORM_data1) {
                out.printf(" %s", value.toString());
                VIRTUALITY virt = VIRTUALITY.get(((Byte)value).byteValue());
                if (virt != null) {
                    out.printf(" %s", virt.toString());
                }
            } else if (this.attrName == ATTR.DW_AT_accessibility && this.valueForm == FORM.DW_FORM_data1) {
                out.printf(" %s", value.toString());
                ACCESS access = ACCESS.get(((Byte)value).byteValue());
                if (access != null) {
                    out.printf(" %s", access.toString());
                }
            } else {
                out.printf(" %s", value.toString());
            }
            out.printf("\n", new Object[0]);
        } else {
            out.println("");
        }
    }

    public void dump(PrintStream out) {
        this.dump(out, null);
    }

    public void dump() {
        this.dump(System.out, null);
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Object value) {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out, value);
        return st.toString();
    }
}

