/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.reader;

import java.io.IOException;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATE;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.FORM;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.reader.ElfReader;
import org.netbeans.modules.cnd.dwarfdump.reader.MyRandomAccessFile;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAbbriviationTableSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfArangesSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfAttribute;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfLineInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfMacroInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfNameLookupTableSection;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfRelaDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.StringTableSection;

public class DwarfReader
extends ElfReader {
    public DwarfReader(String fname, MyRandomAccessFile reader, Magic magic, long shift, long length) throws IOException {
        super(fname, reader, magic, shift, length);
        this.getSection(".debug_str");
    }

    public Object readAttrValue(DwarfAttribute attr) throws IOException {
        Object value = this.readForm(attr.valueForm);
        if (attr.attrName.equals((Object)ATTR.DW_AT_language)) {
            return LANG.get(((Number)value).intValue());
        }
        if (attr.attrName.equals((Object)ATTR.DW_AT_encoding)) {
            return ATE.get(((Byte)value).byteValue());
        }
        if (attr.attrName.equals((Object)ATTR.DW_AT_decl_line)) {
            return ((Number)value).intValue();
        }
        return value;
    }

    public Object readForm(FORM form) throws IOException {
        switch (form) {
            case DW_FORM_addr: {
                return this.read(new byte[this.getAddressSize()]);
            }
            case DW_FORM_block2: {
                return this.read(new byte[this.readShort()]);
            }
            case DW_FORM_block4: {
                return this.read(new byte[this.readInt()]);
            }
            case DW_FORM_data2: {
                return this.readShort();
            }
            case DW_FORM_data4: {
                return this.readInt();
            }
            case DW_FORM_data8: {
                return this.readLong();
            }
            case DW_FORM_string: {
                return this.readString();
            }
            case DW_FORM_block: {
                return this.read(new byte[this.readUnsignedLEB128()]);
            }
            case DW_FORM_block1: {
                return this.read(new byte[this.readUnsignedByte()]);
            }
            case DW_FORM_data1: {
                return this.readByte();
            }
            case DW_FORM_flag: {
                return this.readBoolean();
            }
            case DW_FORM_sdata: {
                return this.readSignedLEB128();
            }
            case DW_FORM_strp: {
                return ((StringTableSection)this.getSection(".debug_str")).getString(this.readInt());
            }
            case DW_FORM_udata: {
                return this.readUnsignedLEB128();
            }
            case DW_FORM_ref_addr: {
                return this.read(new byte[this.getAddressSize()]);
            }
            case DW_FORM_ref1: {
                return this.read(new byte[this.readUnsignedByte()]);
            }
            case DW_FORM_ref2: {
                return this.read(new byte[2]);
            }
            case DW_FORM_ref4: {
                return this.readInt();
            }
            case DW_FORM_ref8: {
                return this.readLong();
            }
            case DW_FORM_ref_udata: {
                return this.read(new byte[this.readUnsignedLEB128()]);
            }
            case DW_FORM_indirect: {
                return this.readForm(FORM.get(this.readUnsignedLEB128()));
            }
        }
        throw new IOException("unknown type " + (Object)((Object)form));
    }

    ElfSection initSection(Integer sectionIdx, String sectionName) {
        if (sectionName.equals(".debug_str")) {
            return new StringTableSection((ElfReader)this, sectionIdx);
        }
        if (sectionName.equals(".debug_aranges")) {
            return new DwarfArangesSection(this, (int)sectionIdx);
        }
        if (sectionName.equals(".debug_info")) {
            return new DwarfDebugInfoSection(this, (int)sectionIdx);
        }
        if (sectionName.equals(".rela.debug_info")) {
            return new DwarfRelaDebugInfoSection(this, (int)sectionIdx);
        }
        if (sectionName.equals(".debug_abbrev")) {
            return new DwarfAbbriviationTableSection(this, sectionIdx);
        }
        if (sectionName.equals(".debug_line")) {
            return new DwarfLineInfoSection(this, (int)sectionIdx);
        }
        if (sectionName.equals(".debug_macinfo")) {
            return new DwarfMacroInfoSection(this, (int)sectionIdx);
        }
        if (sectionName.equals(".debug_pubnames")) {
            return new DwarfNameLookupTableSection(this, (int)sectionIdx);
        }
        return null;
    }
}

