/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation;

import java.util.ArrayList;
import javax.lang.model.element.ElementKind;
import javax.swing.JDialog;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.modules.java.navigation.JavaMembersPanel;
import org.netbeans.modules.java.navigation.ResizablePopup;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class JavaMembers {
    public static void show(FileObject fileObject) {
        JavaSource javaSource;
        if (fileObject != null && (javaSource = JavaSource.forFileObject((FileObject)fileObject)) != null) {
            String name = null;
            ClassPath srcPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
            if (srcPath != null) {
                name = srcPath.getResourceName(fileObject, '.', false);
            }
            if (name == null) {
                name = "";
            }
            JavaMembers.showDialog(name, new JavaMembersPanel(fileObject), fileObject);
        }
    }

    public static void show(FileObject fileObject, ElementHandle<?>[] elements) {
        if (fileObject != null) {
            String membersOf = "";
            if (elements != null && elements.length > 0) {
                ArrayList<String> namesList = new ArrayList<String>(elements.length);
                for (ElementHandle<?> handle : elements) {
                    namesList.add(handle.getQualifiedName());
                }
                membersOf = elements[0].getKind() == ElementKind.PACKAGE && elements.length > 1 ? namesList.subList(1, namesList.size()).toString() : ((Object)namesList).toString();
            }
            JavaMembers.showDialog(membersOf, new JavaMembersPanel(fileObject, elements), fileObject);
        }
    }

    private static void showDialog(String membersOf, JavaMembersPanel panel, FileObject file) {
        assert (membersOf != null);
        assert (panel != null);
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JavaMembers.class, (String)"LBL_WaitNode"));
        JDialog dialog = ResizablePopup.getDialog(file);
        String title = NbBundle.getMessage(JavaMembers.class, (String)"TITLE_Members", (Object)membersOf);
        dialog.setTitle(title);
        dialog.setContentPane(panel);
        dialog.setVisible(true);
    }
}

