/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.index;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.editor.PredefinedSymbols;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.index.IdentifierSignature;
import org.netbeans.modules.php.editor.index.PHPIndex;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.LazyBuild;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.project.api.PhpSourcePath;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;

public final class PHPIndexer
extends EmbeddingIndexer {
    private static final Logger LOG = Logger.getLogger(PHPIndexer.class.getName());
    static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    private static final Collection<String> INDEXABLE_EXTENSIONS = Arrays.asList("php", "php3", "php4", "php5", "phtml", "inc");
    public static final String FIELD_BASE = "base";
    public static final String FIELD_EXTEND = "extend";
    public static final String FIELD_CLASS = "clz";
    public static final String FIELD_SUPER_CLASS = "superclz";
    public static final String FIELD_IFACE = "iface";
    public static final String FIELD_SUPER_IFACE = "superiface";
    public static final String FIELD_CONST = "const";
    public static final String FIELD_CLASS_CONST = "clz.const";
    public static final String FIELD_FIELD = "field";
    public static final String FIELD_METHOD = "method";
    public static final String FIELD_CONSTRUCTOR = "constructor";
    public static final String FIELD_INCLUDE = "include";
    public static final String FIELD_IDENTIFIER = "identifier_used";
    public static final String FIELD_IDENTIFIER_DECLARATION = "identifier_declaration";
    public static final String FIELD_NAMESPACE = "ns";
    public static final String FIELD_VAR = "var";
    public static final String FIELD_TOP_LEVEL = "top";
    public static final String[] ALL_FIELDS = new String[]{"base", "extend", "clz", "iface", "const", "clz.const", "field", "method", "constructor", "include", "identifier_used", "var", "top", "ns"};

    public String getPersistentUrl(File file) {
        try {
            String url = file.toURI().toURL().toExternalForm();
            return PHPIndex.getPreindexUrl(url);
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return file.getPath();
        }
    }

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        try {
            FileObject editedFO;
            Document doc;
            JTextComponent jtc;
            PHPParseResult r = (PHPParseResult)parserResult;
            if (r.getProgram() == null) {
                return;
            }
            String processedFileURL = null;
            try {
                FileObject fileObject = r.getSnapshot().getSource().getFileObject();
                assert (r.getDiagnostics().isEmpty() || !PhpSourcePath.FileType.INTERNAL.equals((Object)PhpSourcePath.getFileType((FileObject)fileObject))) : fileObject.getPath();
                processedFileURL = fileObject.getURL().toExternalForm();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (processedFileURL == null) {
                return;
            }
            boolean isFileEdited = false;
            if (!context.isAllFilesIndexing() && context.checkForEditorModifications() && (jtc = EditorRegistry.lastFocusedComponent()) != null && (doc = jtc.getDocument()) != null && (editedFO = NbEditorUtilities.getFileObject((Document)doc)) != null && editedFO.equals(r.getSnapshot().getSource().getFileObject())) {
                isFileEdited = true;
            }
            IndexQueryImpl.clearNamespaceCache();
            LinkedList<IndexDocument> documents = new LinkedList<IndexDocument>();
            IndexingSupport support = IndexingSupport.getInstance((Context)context);
            Model model = r.getModel(false);
            FileScope fileScope = model.getFileScope();
            IndexDocument reverseIdxDocument = support.createDocument(indexable);
            documents.add(reverseIdxDocument);
            for (ClassScope classScope : ModelUtils.getDeclaredClasses(fileScope)) {
                IndexDocument indexDocument = support.createDocument(indexable);
                documents.add(indexDocument);
                indexDocument.addPair(FIELD_CLASS, classScope.getIndexSignature(), true, true);
                QualifiedName superClassName = classScope.getSuperClassName();
                if (superClassName != null) {
                    String name = superClassName.getName();
                    Collection<QualifiedName> collection = VariousUtils.getPossibleFQN(superClassName, classScope.getOffset(), (NamespaceScope)classScope.getInScope());
                    String string = ModelUtils.getFirst(collection).getNamespaceName();
                    indexDocument.addPair(FIELD_SUPER_CLASS, String.format("%s;%s;%s", name.toLowerCase(), name, string), true, true);
                }
                Set superInterfaces = classScope.getSuperInterfaces();
                for (QualifiedName qualifiedName : superInterfaces) {
                    String name = qualifiedName.getName();
                    Collection<QualifiedName> namespaceNames = VariousUtils.getPossibleFQN(qualifiedName, classScope.getOffset(), (NamespaceScope)classScope.getInScope());
                    String namespaceName = ModelUtils.getFirst(namespaceNames).getNamespaceName();
                    indexDocument.addPair(FIELD_SUPER_IFACE, String.format("%s;%s;%s", name.toLowerCase(), name, namespaceName), true, true);
                }
                indexDocument.addPair(FIELD_TOP_LEVEL, classScope.getName().toLowerCase(), true, true);
                for (MethodScope methodScope : classScope.getDeclaredMethods()) {
                    LazyBuild lazyMethod;
                    if (!isFileEdited && methodScope instanceof LazyBuild && !(lazyMethod = (LazyBuild)((Object)methodScope)).isScanned()) {
                        lazyMethod.scan();
                    }
                    indexDocument.addPair(FIELD_METHOD, methodScope.getIndexSignature(), true, true);
                    if (!methodScope.isConstructor()) continue;
                    indexDocument.addPair(FIELD_CONSTRUCTOR, methodScope.getConstructorIndexSignature(), false, true);
                }
                for (FieldElement fieldElement : classScope.getDeclaredFields()) {
                    indexDocument.addPair(FIELD_FIELD, fieldElement.getIndexSignature(), true, true);
                }
                for (ClassConstantElement classConstantElement : classScope.getDeclaredConstants()) {
                    indexDocument.addPair(FIELD_CLASS_CONST, classConstantElement.getIndexSignature(), true, true);
                }
            }
            for (InterfaceScope interfaceScope : ModelUtils.getDeclaredInterfaces(fileScope)) {
                IndexDocument indexDocument = support.createDocument(indexable);
                documents.add(indexDocument);
                indexDocument.addPair(FIELD_IFACE, interfaceScope.getIndexSignature(), true, true);
                Set superInterfaces = interfaceScope.getSuperInterfaces();
                for (QualifiedName qualifiedName : superInterfaces) {
                    String string = qualifiedName.getName();
                    String namespaceName = qualifiedName.toNamespaceName().toString();
                    indexDocument.addPair(FIELD_SUPER_IFACE, String.format("%s;%s;%s", string.toLowerCase(), string, namespaceName), true, true);
                }
                indexDocument.addPair(FIELD_TOP_LEVEL, interfaceScope.getName().toLowerCase(), true, true);
                for (MethodScope methodScope : interfaceScope.getDeclaredMethods()) {
                    indexDocument.addPair(FIELD_METHOD, methodScope.getIndexSignature(), true, true);
                }
                for (ClassConstantElement classConstantElement : interfaceScope.getDeclaredConstants()) {
                    indexDocument.addPair(FIELD_CLASS_CONST, classConstantElement.getIndexSignature(), true, true);
                }
            }
            IndexDocument defaultDocument = support.createDocument(indexable);
            documents.add(defaultDocument);
            for (FunctionScope functionScope : ModelUtils.getDeclaredFunctions(fileScope)) {
                defaultDocument.addPair(FIELD_BASE, functionScope.getIndexSignature(), true, true);
                defaultDocument.addPair(FIELD_TOP_LEVEL, functionScope.getName().toLowerCase(), true, true);
            }
            for (ConstantElement constantElement : ModelUtils.getDeclaredConstants(fileScope)) {
                defaultDocument.addPair(FIELD_CONST, constantElement.getIndexSignature(), true, true);
                defaultDocument.addPair(FIELD_TOP_LEVEL, constantElement.getName().toLowerCase(), true, true);
            }
            for (NamespaceScope namespaceScope : fileScope.getDeclaredNamespaces()) {
                Collection<? extends VariableName> declaredVariables = namespaceScope.getDeclaredVariables();
                for (VariableName variableName : declaredVariables) {
                    String string = variableName.getName();
                    String varNameNoDollar = string.startsWith("$") ? string.substring(1) : string;
                    if (PredefinedSymbols.isSuperGlobalName(varNameNoDollar)) continue;
                    String indexSignature = variableName.getIndexSignature();
                    defaultDocument.addPair(FIELD_VAR, indexSignature, true, true);
                    defaultDocument.addPair(FIELD_TOP_LEVEL, variableName.getName().toLowerCase(), true, true);
                }
                if (namespaceScope.isDefaultNamespace()) continue;
                defaultDocument.addPair(FIELD_NAMESPACE, namespaceScope.getIndexSignature(), true, true);
                defaultDocument.addPair(FIELD_TOP_LEVEL, namespaceScope.getName().toLowerCase(), true, true);
            }
            final IndexDocument indexDocument = support.createDocument(indexable);
            documents.add(indexDocument);
            Program program = r.getProgram();
            DefaultVisitor identifierVisitor = new DefaultVisitor(){

                @Override
                public void visit(Identifier identifier) {
                    IdentifierSignature idSign = IdentifierSignature.createIdentifier(identifier);
                    indexDocument.addPair(PHPIndexer.FIELD_IDENTIFIER, idSign.getSignature(), true, true);
                    super.visit(identifier);
                }
            };
            program.accept(identifierVisitor);
            for (IndexDocument indexDocument2 : documents) {
                support.addDocument(indexDocument2);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public File getPreindexedData() {
        return null;
    }

    public boolean acceptQueryPath(String url) {
        return url.indexOf("jsstubs") == -1 && url.indexOf("/ruby/") == -1 && url.indexOf("/gems/") == -1 && url.indexOf("lib/ruby/") == -1;
    }

    public static final class Factory
    extends EmbeddingIndexerFactory {
        public static final String NAME = "php";
        public static final int VERSION = 18;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(indexable, snapshot)) {
                return new PHPIndexer();
            }
            return null;
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 18;
        }

        private boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            FileObject fileObject = snapshot.getSource().getFileObject();
            if (INDEXABLE_EXTENSIONS.contains(fileObject.getExt().toLowerCase())) {
                return true;
            }
            return FileUtils.isPhpFile((FileObject)fileObject);
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : deleted) {
                    is.removeDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }

        public void rootsRemoved(Iterable<? extends URL> removedRoots) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
            try {
                IndexingSupport is = IndexingSupport.getInstance((Context)context);
                for (Indexable indexable : dirty) {
                    is.markDirtyDocuments(indexable);
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, null, ioe);
            }
        }
    }
}

