/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.ElementQueryFactory;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.ElementTransformation;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.TreeElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.codegen.CGSGenerator;
import org.netbeans.modules.php.editor.codegen.MethodProperty;
import org.netbeans.modules.php.editor.codegen.Property;
import org.netbeans.modules.php.editor.nav.NavUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BodyDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CGSInfo {
    private String className = null;
    private boolean hasConstructor;
    private final List<Property> properties = new ArrayList<Property>();
    private final List<Property> possibleGetters = new ArrayList<Property>();
    private final List<Property> possibleSetters = new ArrayList<Property>();
    private final List<Property> possibleGettersSetters = new ArrayList<Property>();
    private final List<MethodProperty> possibleMethods = new ArrayList<MethodProperty>();
    private final JTextComponent textComp;
    private CGSGenerator.GenWay howToGenerate;
    private boolean generateDoc;

    private CGSInfo(JTextComponent textComp) {
        this.textComp = textComp;
        this.hasConstructor = false;
        this.generateDoc = true;
        this.howToGenerate = CGSGenerator.GenWay.AS_JAVA;
    }

    public static CGSInfo getCGSInfo(JTextComponent textComp) {
        CGSInfo info = new CGSInfo(textComp);
        info.findPropertyInScope();
        return info;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public List<MethodProperty> getPossibleMethods() {
        return this.possibleMethods;
    }

    public List<Property> getPossibleGetters() {
        return this.possibleGetters;
    }

    public List<Property> getPossibleGettersSetters() {
        return this.possibleGettersSetters;
    }

    public List<Property> getPossibleSetters() {
        return this.possibleSetters;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean hasConstructor() {
        return this.hasConstructor;
    }

    public CGSGenerator.GenWay getHowToGenerate() {
        return this.howToGenerate;
    }

    public void setHowToGenerate(CGSGenerator.GenWay howGenerate) {
        this.howToGenerate = howGenerate;
    }

    public boolean isGenerateDoc() {
        return this.generateDoc;
    }

    public void setGenerateDoc(boolean generateDoc) {
        this.generateDoc = generateDoc;
    }

    private void findPropertyInScope() {
        FileObject file = NavUtils.getFile(this.textComp.getDocument());
        if (file == null) {
            return;
        }
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)this.textComp.getDocument())), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    int caretOffset;
                    ParserResult info = (ParserResult)resultIterator.getParserResult();
                    ClassDeclaration classDecl = CGSInfo.this.findEnclosingClass(info, caretOffset = CGSInfo.this.textComp.getCaretPosition());
                    if (classDecl != null) {
                        CGSInfo.this.className = classDecl.getName().getName();
                        if (info != null && CGSInfo.this.className != null) {
                            FileObject fileObject = info.getSnapshot().getSource().getFileObject();
                            ElementQuery.Index index = ElementQueryFactory.getIndexQuery(info);
                            ElementFilter forFilesFilter = ElementFilter.forFiles(fileObject);
                            Set<ClassElement> classes = forFilesFilter.filter(index.getClasses(NameKind.exact(CGSInfo.this.className)));
                            for (ClassElement classElement : classes) {
                                ElementFilter forNotDeclared = ElementFilter.forExcludedElements(index.getDeclaredMethods(classElement));
                                HashSet<MethodElement> accessibleMethods = new HashSet<MethodElement>();
                                accessibleMethods.addAll(forNotDeclared.filter(index.getAccessibleMethods(classElement, classElement)));
                                accessibleMethods.addAll(ElementFilter.forExcludedElements(accessibleMethods).filter(forNotDeclared.filter(index.getConstructors(classElement))));
                                accessibleMethods.addAll(ElementFilter.forExcludedElements(accessibleMethods).filter(forNotDeclared.filter(index.getAccessibleMagicMethods(classElement))));
                                Set<TypeElement> preferedTypes = forFilesFilter.prefer(ElementTransformation.toMemberTypes().transform(accessibleMethods));
                                TreeElement<TypeElement> enclosingType = index.getInheritedTypesAsTree(classElement, preferedTypes);
                                ArrayList<MethodProperty> properties = new ArrayList<MethodProperty>();
                                Set methods = ElementFilter.forMembersOfTypes(preferedTypes).filter(accessibleMethods);
                                for (MethodElement methodElement : methods) {
                                    if (methodElement.isFinal()) continue;
                                    properties.add(new MethodProperty(methodElement, enclosingType));
                                }
                                Collections.sort(properties, MethodProperty.getComparator());
                                CGSInfo.this.getPossibleMethods().addAll(properties);
                            }
                        }
                        ArrayList<String> existingGetters = new ArrayList<String>();
                        ArrayList<String> existingSetters = new ArrayList<String>();
                        PropertiesVisitor visitor = new PropertiesVisitor(CGSInfo.this.getProperties(), existingGetters, existingSetters);
                        visitor.scan(classDecl);
                        for (Property property : CGSInfo.this.getProperties()) {
                            String propertyName = property.getName().toLowerCase();
                            boolean existGetter = existingGetters.contains(propertyName);
                            boolean existSetter = existingSetters.contains(propertyName);
                            if (!existGetter && !existSetter) {
                                CGSInfo.this.getPossibleGettersSetters().add(property);
                                CGSInfo.this.getPossibleGetters().add(property);
                                CGSInfo.this.getPossibleSetters().add(property);
                                continue;
                            }
                            if (!existGetter) {
                                CGSInfo.this.getPossibleGetters().add(property);
                                continue;
                            }
                            if (existSetter) continue;
                            CGSInfo.this.getPossibleSetters().add(property);
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private ClassDeclaration findEnclosingClass(ParserResult info, int offset) {
        List<ASTNode> nodes = NavUtils.underCaret(info, offset);
        int count = nodes.size();
        if (count > 1) {
            ASTNode block = nodes.get(count - 1);
            ASTNode declaration = nodes.get(count - 2);
            if (block instanceof Block && declaration instanceof ClassDeclaration) {
                return (ClassDeclaration)declaration;
            }
        }
        return null;
    }

    private class PropertiesVisitor
    extends DefaultVisitor {
        private final List<String> existingGetters;
        private final List<String> existingSetters;
        private final List<Property> properties;

        public PropertiesVisitor(List<Property> properties, List<String> existingGetters, List<String> existingSetters) {
            this.existingGetters = existingGetters;
            this.existingSetters = existingSetters;
            this.properties = properties;
        }

        @Override
        public void visit(FieldsDeclaration node) {
            List<SingleFieldDeclaration> fields = node.getFields();
            if (!BodyDeclaration.Modifier.isStatic(node.getModifier())) {
                for (SingleFieldDeclaration singleFieldDeclaration : fields) {
                    Variable variable = singleFieldDeclaration.getName();
                    if (variable == null || !(variable.getName() instanceof Identifier)) continue;
                    String name = ((Identifier)variable.getName()).getName();
                    CGSInfo.this.getProperties().add(new Property(name, node.getModifier()));
                }
            }
        }

        @Override
        public void visit(MethodDeclaration node) {
            String name = node.getFunction().getFunctionName().getName();
            if (name != null) {
                if (name.startsWith("get")) {
                    String propertyName = name.substring("get".length());
                    this.existingGetters.add(propertyName.toLowerCase());
                } else if (name.startsWith("set")) {
                    String propertyName = name.substring("set".length());
                    this.existingSetters.add(propertyName.toLowerCase());
                } else if (CGSInfo.this.className != null && (CGSInfo.this.className.equals(name) || "__construct".equals(name))) {
                    CGSInfo.this.hasConstructor = true;
                }
            }
        }
    }
}

