/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.api.components;

import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.web.jsf.api.facesmodel.JSFVersion;
import org.openide.util.Parameters;

public final class JsfComponentDescriptor {
    private final String name;
    private final String libraryName;
    private final String description;
    private final JSFVersion jsfVersion;
    private final String welcomeBody;
    private final String namespace;
    private final String nsPrefix;
    private final String defaultRenderKitId;

    public JsfComponentDescriptor(String libraryName, String name, JSFVersion jsfVersion, String description, String welcomeBody, String namespace, String nsPrefix) {
        this(libraryName, name, jsfVersion, description, welcomeBody, namespace, nsPrefix, null);
    }

    public JsfComponentDescriptor(String libraryName, String name, JSFVersion jsfVersion, String description, String welcomeBody, String namespace, String nsPrefix, String defaultRenderKitId) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"libraryName", (Object)libraryName);
        this.libraryName = libraryName;
        this.name = name;
        this.jsfVersion = jsfVersion;
        this.description = description;
        this.welcomeBody = welcomeBody;
        this.namespace = namespace;
        this.nsPrefix = nsPrefix;
        this.defaultRenderKitId = defaultRenderKitId;
    }

    public JSFVersion getJsfVersion() {
        return this.jsfVersion;
    }

    public int hashCode() {
        return this.getLibraryName().hashCode();
    }

    public boolean equals(Object obj) {
        JsfComponentDescriptor descriptor;
        return obj instanceof JsfComponentDescriptor && (descriptor = (JsfComponentDescriptor)obj).getLibraryName().equals(this.getLibraryName());
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        return this.getName();
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public Library getLibrary() {
        return LibraryManager.getDefault().getLibrary(this.getLibraryName());
    }

    public String toString() {
        return this.getName();
    }

    public String getWelcomeBody() {
        return this.welcomeBody;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNsPrefix() {
        return this.nsPrefix;
    }

    public String getDefaultRenderKitId() {
        return this.defaultRenderKitId;
    }
}

