/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.fortran.options.FortranCodeStyle;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorKit;

public class FKit
extends NbEditorKit {
    private InputAttributes lexerAttrs = null;
    private static ArrayList<Class<?>> actionClasses = null;

    public String getContentType() {
        return "text/x-fortran";
    }

    public void install(JEditorPane c) {
        super.install(c);
    }

    public Document createDefaultDocument() {
        NbEditorDocument doc = new NbEditorDocument("text/x-fortran");
        doc.putProperty((Object)"write-line-separator", (Object)"\n");
        return doc;
    }

    protected void initDocument(BaseDocument doc) {
        super.initDocument(doc);
        doc.putProperty(InputAttributes.class, (Object)this.getLexerAttributes(doc));
        doc.putProperty(Language.class, this.getLanguage());
    }

    private Language<FortranTokenId> getLanguage() {
        return FortranTokenId.languageFortran();
    }

    private synchronized InputAttributes getLexerAttributes(BaseDocument doc) {
        if (this.lexerAttrs == null) {
            this.lexerAttrs = new InputAttributes();
        }
        FortranCodeStyle codeStyle = FortranCodeStyle.get((Document)doc);
        this.lexerAttrs.setValue(this.getLanguage(), (Object)"lexer-filter", this.getFilter(), true);
        this.lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-maximum-text-width", (Object)codeStyle.getRrightMargin(), true);
        this.lexerAttrs.setValue(this.getLanguage(), (Object)"fortran-free-format", (Object)codeStyle.isFreeFormatFortran(), true);
        return this.lexerAttrs;
    }

    private Filter<FortranTokenId> getFilter() {
        return CndLexerUtilities.getFortranFilter();
    }

    protected Action[] createActions() {
        int arraySize = 3;
        int numAddClasses = 0;
        if (actionClasses != null) {
            numAddClasses = actionClasses.size();
            arraySize += numAddClasses;
        }
        Action[] fortranActions = new Action[arraySize];
        int index = 0;
        if (actionClasses != null) {
            for (int i = 0; i < numAddClasses; ++i) {
                Class<?> c = actionClasses.get(i);
                try {
                    fortranActions[index] = (Action)c.newInstance();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++index;
            }
        }
        fortranActions[index++] = new ExtKit.CommentAction("!");
        fortranActions[index++] = new ExtKit.UncommentAction("!");
        fortranActions[index++] = new ExtKit.ToggleCommentAction("!");
        return TextAction.augmentList(super.createActions(), fortranActions);
    }

    public static void addActionClass(Class<?> action) {
        if (actionClasses == null) {
            actionClasses = new ArrayList(2);
        }
        actionClasses.add(action);
    }
}

