/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.editor.cplusplus.BracketCompletion;
import org.netbeans.modules.cnd.editor.indent.HotCharIndent;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;
import org.openide.util.Exceptions;

public class CppTTIFactory
implements TypedTextInterceptor.Factory {
    public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
        return new TypedTextInterceptorImpl();
    }

    private static class TypedTextInterceptorImpl
    implements TypedTextInterceptor {
        public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
            return false;
        }

        public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
        }

        public void afterInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
            final BaseDocument doc = (BaseDocument)context.getDocument();
            doc.runAtomicAsUser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String typedText;
                    int offset = context.getOffset();
                    if (HotCharIndent.INSTANCE.getKeywordBasedReformatBlock(doc, offset, typedText = context.getText())) {
                        Indent indent = Indent.get((Document)doc);
                        indent.lock();
                        try {
                            doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.TRUE);
                            indent.reindent(offset);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.FALSE);
                            indent.unlock();
                        }
                    } else {
                        TokenItem tokenAtDot;
                        Caret caret = context.getComponent().getCaret();
                        boolean blockCommentStart = false;
                        if (offset > 0 && typedText.charAt(0) == '*' && (tokenAtDot = CndTokenUtilities.getToken((Document)doc, (int)(offset - 1), (boolean)true)).id() == CppTokenId.BLOCK_COMMENT) {
                            blockCommentStart = true;
                        }
                        try {
                            BracketCompletion.charInserted(doc, offset, caret, typedText.charAt(0), blockCommentStart);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
        }

        public void cancelled(TypedTextInterceptor.Context context) {
        }
    }
}

