/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.hibernate.cfg.HibernateCfgProperties;
import org.netbeans.modules.hibernate.cfg.model.SessionFactory;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class Util {
    public static String[] getAllPropNames(String propCat) {
        if (propCat.equals("JDBC Properties")) {
            return HibernateCfgProperties.jdbcProps;
        }
        if (propCat.equals("Datasource Properties")) {
            return HibernateCfgProperties.datasourceProps;
        }
        if (propCat.equals("Configuration Properties")) {
            return HibernateCfgProperties.optionalConfigProps;
        }
        if (propCat.equals("JDBC and Connection Properties")) {
            return HibernateCfgProperties.optionalJdbcConnProps;
        }
        if (propCat.equals("Cache Properties")) {
            return HibernateCfgProperties.optionalCacheProps;
        }
        if (propCat.equals("Transaction Properties")) {
            return HibernateCfgProperties.optionalTransactionProps;
        }
        if (propCat.equals("Miscellaneous Properties")) {
            return HibernateCfgProperties.optionalMiscProps;
        }
        return new String[0];
    }

    public static String[] getAvailPropNames(String propCat, SessionFactory sessionFactory) {
        List<String> propsList = Arrays.asList(Util.getAllPropNames(propCat));
        if (sessionFactory != null) {
            ArrayList<String> availProps = new ArrayList<String>(propsList);
            for (int i = 0; i < sessionFactory.sizeProperty2(); ++i) {
                String propName = sessionFactory.getAttributeValue("Property2", i, "Name");
                if (!availProps.contains(propName) && !availProps.contains("hibernate." + propName)) continue;
                availProps.remove(propName);
            }
            return availProps.toArray(new String[0]);
        }
        return new String[0];
    }

    public static String[] getMappingFilesFromProject(FileObject fileObj) {
        Project enclosingProject = FileOwnerQuery.getOwner((FileObject)fileObj);
        HibernateEnvironment env = (HibernateEnvironment)enclosingProject.getLookup().lookup(HibernateEnvironment.class);
        if (env != null) {
            return env.getAllHibernateMappings().toArray(new String[0]);
        }
        return new String[0];
    }

    public static SourceGroup[] getJavaSourceGroups(HibernateCfgDataObject dObj) throws IOException {
        Project proj = FileOwnerQuery.getOwner((FileObject)dObj.getPrimaryFile());
        if (proj == null) {
            return new SourceGroup[0];
        }
        Sources sources = ProjectUtils.getSources((Project)proj);
        SourceGroup[] toRet = sources.getSourceGroups("resources");
        if (toRet != null && toRet.length != 0) {
            return toRet;
        }
        return sources.getSourceGroups("java");
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo) {
        return Util.getResourcePath(groups, fo, '.', false);
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo, char separator) {
        return Util.getResourcePath(groups, fo, separator, false);
    }

    public static String getResourcePath(SourceGroup[] groups, FileObject fo, char separator, boolean withExt) {
        for (int i = 0; i < groups.length; ++i) {
            FileObject root = groups[i].getRootFolder();
            if (!FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
            String relativePath = FileUtil.getRelativePath((FileObject)root, (FileObject)fo);
            if (relativePath != null) {
                int index;
                if (separator != '/') {
                    relativePath = relativePath.replace('/', separator);
                }
                if (!withExt && (index = relativePath.lastIndexOf(46)) > 0) {
                    relativePath = relativePath.substring(0, index);
                }
                return relativePath;
            }
            return "";
        }
        return "";
    }
}

