/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.GrantPanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTableModel;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class SecurityTablePanel
extends DefaultTablePanel {
    private SecurityTableModel model;
    private HibernateCfgDataObject configDataObject;

    public SecurityTablePanel(HibernateCfgDataObject dObj, final SecurityTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.configDataObject = dObj;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SecurityTablePanel.this.configDataObject.modelUpdatedFromUI();
                int row = SecurityTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = this.add ? -1 : SecurityTablePanel.this.getTable().getSelectedRow();
            final GrantPanel dialogPanel = new GrantPanel();
            if (!this.add) {
                String roleName = (String)SecurityTablePanel.this.model.getValueAt(row, 0);
                String entityName = (String)SecurityTablePanel.this.model.getValueAt(row, 1);
                String actions = (String)SecurityTablePanel.this.model.getValueAt(row, 2);
                dialogPanel.initValues(roleName, entityName, actions);
            }
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(SecurityTablePanel.class, (String)"LBL_Security"), this.add){

                protected String validate() {
                    String role = dialogPanel.getRole();
                    String entityName = dialogPanel.getEntityName();
                    String actions = dialogPanel.getActions();
                    if (role.length() == 0) {
                        return NbBundle.getMessage(SecurityTablePanel.class, (String)"TXT_Role_Empty");
                    }
                    if (entityName.length() == 0) {
                        return NbBundle.getMessage(SecurityTablePanel.class, (String)"TXT_Entity_Name_Empty");
                    }
                    if (actions.length() == 0) {
                        return NbBundle.getMessage(SecurityTablePanel.class, (String)"TXT_Actions_Empty");
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getRoleTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getEntityNameTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            dialogPanel.getActionsTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getRoleTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getEntityNameTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            dialogPanel.getActionsTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                SecurityTablePanel.this.configDataObject.modelUpdatedFromUI();
                String role = dialogPanel.getRole();
                String entityName = dialogPanel.getEntityName();
                String actions = dialogPanel.getActions();
                if (this.add) {
                    SecurityTablePanel.this.model.addRow(new String[]{role, entityName, actions});
                } else {
                    SecurityTablePanel.this.model.editRow(row, new String[]{role, entityName, actions});
                }
            }
        }
    }
}

