/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hyperlink;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.modules.hibernate.editor.HibernateEditorUtil;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkEnv;
import org.netbeans.modules.hibernate.hyperlink.HyperlinkProcessor;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;

public class PropertyHyperlinkProcessor
extends HyperlinkProcessor {
    @Override
    public void process(HyperlinkEnv env) {
        try {
            final String className = HibernateEditorUtil.getClassName((Node)env.getCurrentTag());
            if (className == null) {
                return;
            }
            final String propName = env.getValueString();
            if (propName == null || propName.length() == 0) {
                return;
            }
            JavaSource js = HibernateEditorUtil.getJavaSource(env.getDocument());
            if (js == null) {
                return;
            }
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    TypeElement te = HibernateEditorUtil.findClassElementByBinaryName(className, cc);
                    if (te == null) {
                        return;
                    }
                    TypeMirror startType = te.asType();
                    if (startType == null) {
                        return;
                    }
                    ElementUtilities eu = cc.getElementUtilities();
                    VariableElement fieldElement = HibernateEditorUtil.findFieldElementOnType(eu, startType, propName);
                    if (fieldElement != null) {
                        ElementOpen.open((ClasspathInfo)cc.getClasspathInfo(), (Element)fieldElement);
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

