/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.table;

import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.renderer.CheckBoxProvider;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.FormatStringValue;
import org.jdesktop.swingx.renderer.JRendererCheckBox;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.table.DatePickerCellEditor;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.output.DataView;
import org.netbeans.modules.db.dataview.table.BooleanTableCellEditor;
import org.netbeans.modules.db.dataview.table.DateTimePickerCellEditor;
import org.netbeans.modules.db.dataview.table.JXTableDecorator;
import org.netbeans.modules.db.dataview.table.JXTableRowHeader;
import org.netbeans.modules.db.dataview.table.NumberFieldEditor;
import org.netbeans.modules.db.dataview.table.ResultSetCellRenderer;
import org.netbeans.modules.db.dataview.table.ResultSetTableModel;
import org.netbeans.modules.db.dataview.table.StringTableCellEditor;
import org.openide.util.NbBundle;

public class ResultSetJXTable
extends JXTableDecorator {
    private String[] columnToolTips;
    private final int multiplier;
    private static final String data = "WE WILL EITHER FIND A WAY, OR MAKE ONE.";
    private static final Logger mLogger = Logger.getLogger(ResultSetJXTable.class.getName());
    protected DataView dView;
    private final List<Integer> columnWidthList;
    private static final int MAX_COLUMN_WIDTH = 25;

    public ResultSetJXTable(DataView dataView) {
        this.dView = dataView;
        this.setShowGrid(true, true);
        this.setGridColor(GRID_COLOR);
        this.getTableHeader().setReorderingAllowed(false);
        this.setColumnControlVisible(true);
        this.getColumnControl().setToolTipText(NbBundle.getMessage(ResultSetJXTable.class, (String)"ResultSetJXTable.columnControl.tooltip"));
        this.setHorizontalScrollEnabled(true);
        this.setAutoResizeMode(0);
        this.setFillsViewportHeight(true);
        this.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)Color.WHITE, (Color)ALTERNATE_ROW_COLOR)});
        this.addHighlighter((Highlighter)new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, ROLLOVER_ROW_COLOR, null));
        this.setDefaultCellRenderers();
        this.setDefaultCellEditors();
        if (this.dView.getDataViewDBTable() != null) {
            this.columnToolTips = this.dView.getDataViewDBTable().getColumnToolTips();
        }
        this.multiplier = this.getFontMetrics(this.getFont()).stringWidth(data) / data.length() + 4;
        this.columnWidthList = this.getColumnWidthList();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeaderImpl(this.columnModel);
    }

    public void createTableModel(List<Object[]> rows, JXTableRowHeader rowHeader) {
        assert (SwingUtilities.isEventDispatchThread()) : "Must be called from AWT thread";
        assert (rows != null);
        TableModel tempModel = this.createModelFrom(rows);
        this.setModel(tempModel);
        if (!this.columnWidthList.isEmpty()) {
            this.setHeader((JTable)((Object)this), this.columnWidthList);
        }
        if (rowHeader != null) {
            rowHeader.setTable((JTable)((Object)this));
        }
    }

    protected void setDefaultCellRenderers() {
        this.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new ResultSetCellRenderer()));
        this.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new ResultSetCellRenderer()));
        this.setDefaultRenderer(Number.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)FormatStringValue.NUMBER_TO_STRING, 4)));
        this.setDefaultRenderer(Boolean.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((ComponentProvider)new CheckBoxProvider())));
        this.setDefaultRenderer(Date.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)FormatStringValue.DATE_TO_STRING)));
        this.setDefaultRenderer(Time.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.TIME_TO_STRING)));
        this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.DATETIME_TO_STRING)));
        this.setDefaultRenderer(java.util.Date.class, (TableCellRenderer)((Object)new ResultSetCellRenderer((StringValue)ResultSetCellRenderer.DATETIME_TO_STRING)));
    }

    protected void setDefaultCellEditors() {
        KeyListener kl = this.createControKeyListener();
        JTextField txtFld = new JTextField();
        txtFld.addKeyListener(kl);
        this.setDefaultEditor(Object.class, new StringTableCellEditor(txtFld));
        this.setDefaultEditor(String.class, new StringTableCellEditor(txtFld));
        this.setDefaultEditor(Time.class, new StringTableCellEditor(txtFld));
        JTextField numFld = new JTextField();
        txtFld.addKeyListener(kl);
        this.setDefaultEditor(Number.class, new NumberFieldEditor(numFld));
        JRendererCheckBox b = new JRendererCheckBox();
        b.addKeyListener(kl);
        this.setDefaultEditor(Boolean.class, new BooleanTableCellEditor(b));
        try {
            DatePickerCellEditor dateEditor = new DatePickerCellEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd"));
            this.setDefaultEditor(Date.class, (TableCellEditor)dateEditor);
        }
        catch (NullPointerException npe) {
            mLogger.log(Level.WARNING, "While creating DatePickerCellEditor was thrown " + npe, npe);
        }
        try {
            DateTimePickerCellEditor dateTimeEditor = new DateTimePickerCellEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
            dateTimeEditor.addKeyListener(kl);
            this.setDefaultEditor(Timestamp.class, dateTimeEditor);
            this.setDefaultEditor(java.util.Date.class, dateTimeEditor);
        }
        catch (NullPointerException npe) {
            mLogger.log(Level.WARNING, "While creating DateTimePickerCellEditor was thrown " + npe, npe);
        }
    }

    protected KeyListener createControKeyListener() {
        return new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }
        };
    }

    private void setHeader(JTable table, List<Integer> columnWidthList) {
        try {
            TableColumnModel cModel = table.getColumnModel();
            for (int i = 0; i < columnWidthList.size(); ++i) {
                TableColumn column = cModel.getColumn(i);
                column.setPreferredWidth(columnWidthList.get(i));
            }
            table.getTableHeader().setColumnModel(cModel);
        }
        catch (Exception e) {
            mLogger.log(Level.INFO, "Failed to set the size of the table headers" + e, e);
        }
    }

    private List<Integer> getColumnWidthList() {
        ArrayList<Integer> colWidthList = new ArrayList<Integer>();
        try {
            int I = this.getRSColumnCount();
            for (int i = 0; i < I; ++i) {
                int labelWidth;
                DBColumn col = this.getDBColumn(i);
                int fieldWidth = col.getDisplaySize();
                int colWidth = Math.max(fieldWidth, labelWidth = col.getDisplayName().length()) * this.multiplier;
                if (colWidth < 5) {
                    colWidth = 15 * this.multiplier;
                }
                if (colWidth > 25 * this.multiplier) {
                    colWidth = 25 * this.multiplier;
                }
                colWidthList.add(colWidth);
            }
        }
        catch (Exception e) {
            mLogger.log(Level.INFO, "Failed to set the size of the table headers" + e, e);
        }
        return colWidthList;
    }

    private TableModel createModelFrom(List<Object[]> rows) {
        DefaultTableModel dtm = this.getDefaultTableModel();
        int I = this.getRSColumnCount();
        for (int i = 0; i < I; ++i) {
            DBColumn col = this.getDBColumn(i);
            dtm.addColumn(col.getDisplayName());
        }
        for (Object[] row : rows) {
            dtm.addRow(row);
        }
        return dtm;
    }

    public DBColumn getDBColumn(int col) {
        DBColumn dbcol = this.dView.getDataViewDBTable().getColumn(col);
        return dbcol;
    }

    public int getRSColumnCount() {
        return this.dView.getDataViewDBTable().getColumnCount();
    }

    protected DefaultTableModel getDefaultTableModel() {
        return new ResultSetTableModel(this);
    }

    private class JTableHeaderImpl
    extends JXTableHeader {
        public JTableHeaderImpl(TableColumnModel cm) {
            super(cm);
        }

        public String getToolTipText(MouseEvent e) {
            return this.getColumnToolTipText(e);
        }

        protected String getColumnToolTipText(MouseEvent e) {
            Point p = e.getPoint();
            int index = this.columnModel.getColumnIndexAtX(p.x);
            try {
                int realIndex = this.columnModel.getColumn(index).getModelIndex();
                return ResultSetJXTable.this.columnToolTips[realIndex];
            }
            catch (ArrayIndexOutOfBoundsException aio) {
                return null;
            }
        }
    }
}

