/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.editor.ext.html.parser.SyntaxElement;
import org.netbeans.editor.ext.html.parser.SyntaxTreeBuilder;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.HtmlSource;

public class XmlSyntaxTreeBuilder
extends SyntaxTreeBuilder {
    public static AstNode makeUncheckedTree(HtmlSource source, List<SyntaxElement> elements) {
        assert (elements != null) : "passed elements list cannot but null";
        int lastEndOffset = source.getSourceCode().length();
        AstNode rootNode = AstNode.createRootNode(0, lastEndOffset, null);
        LinkedList<AstNode> stack = new LinkedList<AstNode>();
        stack.add(rootNode);
        for (SyntaxElement element : elements) {
            if (element.type() == 4) {
                assert (element instanceof SyntaxElement.Tag);
                SyntaxElement.Tag tagElement = (SyntaxElement.Tag)element;
                String tagName = tagElement.getName();
                AstNode lastNode = (AstNode)stack.getLast();
                AstNode openTagNode = new AstNode(tagName, AstNode.NodeType.OPEN_TAG, tagElement.offset(), tagElement.offset() + tagElement.length(), tagElement.isEmpty());
                XmlSyntaxTreeBuilder.setTagAttributes(openTagNode, tagElement);
                if (!tagElement.isEmpty()) {
                    stack.addLast(openTagNode);
                }
                lastNode.addChild(openTagNode);
                continue;
            }
            if (element.type() != 5) continue;
            String tagName = ((SyntaxElement.Named)element).getName();
            AstNode closeTagNode = new AstNode(tagName, AstNode.NodeType.ENDTAG, element.offset(), element.offset() + element.length(), false);
            int matched_index = -1;
            for (int i = stack.size() - 1; i >= 0; --i) {
                AstNode node = (AstNode)stack.get(i);
                if (!tagName.equals(node.name())) continue;
                matched_index = i;
                break;
            }
            assert (matched_index != 0);
            if (matched_index > 0) {
                AstNode match = (AstNode)stack.get(matched_index);
                for (int i = stack.size() - 1; i > matched_index; --i) {
                    AstNode node = (AstNode)stack.get(i);
                    node.setLogicalEndOffset(closeTagNode.startOffset());
                    stack.remove(i);
                }
                AstNode match_parent = (AstNode)stack.get(matched_index - 1);
                match_parent.addChild(closeTagNode);
                match.setMatchingNode(closeTagNode);
                match.setLogicalEndOffset(closeTagNode.endOffset());
                closeTagNode.setMatchingNode(match);
                stack.removeLast();
                continue;
            }
            ((AstNode)stack.getLast()).addChild(closeTagNode);
        }
        for (int i = stack.size() - 1; i > 0; --i) {
            AstNode node = (AstNode)stack.get(i);
            node.setLogicalEndOffset(lastEndOffset);
        }
        return rootNode;
    }
}

