/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.ext.html.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.api.HtmlVersion;
import org.netbeans.editor.ext.html.parser.api.ParseException;
import org.netbeans.editor.ext.html.parser.api.ProblemDescription;
import org.netbeans.editor.ext.html.parser.api.SyntaxAnalyzerResult;
import org.netbeans.editor.ext.html.parser.spi.AstNodeVisitor;
import org.netbeans.html.api.validation.ValidationContext;
import org.netbeans.html.api.validation.ValidationException;
import org.netbeans.html.api.validation.ValidationResult;
import org.netbeans.html.api.validation.Validator;
import org.openide.util.NbBundle;

public class Html4ValidatorImpl
implements Validator {
    @Override
    public ValidationResult validate(ValidationContext context) throws ValidationException {
        assert (this.canValidate(context.getVersion()));
        ArrayList<ProblemDescription> problems = new ArrayList<ProblemDescription>();
        try {
            problems.addAll(this.extractErrorsFromAST(context.getSyntaxAnalyzerResult()));
            problems.addAll(this.findLexicalErrors(context.getSyntaxAnalyzerResult()));
            return new ValidationResult(this, context, problems, problems.isEmpty());
        }
        catch (ParseException ex) {
            throw new ValidationException(ex);
        }
    }

    private List<ProblemDescription> extractErrorsFromAST(SyntaxAnalyzerResult result) throws ParseException {
        final ArrayList<ProblemDescription> _errors = new ArrayList<ProblemDescription>();
        AstNodeVisitor errorsCollector = new AstNodeVisitor(){

            @Override
            public void visit(AstNode node) {
                if (node.type() == AstNode.NodeType.OPEN_TAG || node.type() == AstNode.NodeType.ENDTAG || node.type() == AstNode.NodeType.UNKNOWN_TAG) {
                    for (ProblemDescription desc : node.getDescriptions()) {
                        if (desc.getType() < 1) continue;
                        ProblemDescription pd = ProblemDescription.create(desc.getKey(), desc.getText(), desc.getType(), desc.getFrom(), desc.getTo());
                        _errors.add(pd);
                    }
                }
            }
        };
        AstNodeUtils.visitChildren(result.parseHtml().root(), errorsCollector);
        return _errors;
    }

    private List<ProblemDescription> findLexicalErrors(SyntaxAnalyzerResult result) {
        TokenHierarchy th = result.getSource().getSnapshot().getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(HTMLTokenId.language());
        if (ts == null) {
            return Collections.emptyList();
        }
        ArrayList<ProblemDescription> lexicalErrors = new ArrayList<ProblemDescription>();
        ts.moveStart();
        while (ts.moveNext()) {
            if (ts.token().id() != HTMLTokenId.ERROR) continue;
            String msg = NbBundle.getMessage(Html4ValidatorImpl.class, (String)"MSG_UnexpectedToken", (Object)ts.token().text());
            ProblemDescription pd = ProblemDescription.create("unexpected_token", msg, 2, ts.offset(), ts.offset() + ts.token().length());
            lexicalErrors.add(pd);
        }
        return lexicalErrors;
    }

    @Override
    public String getValidatorName() {
        return "legacy html4 validator";
    }

    @Override
    public boolean canValidate(HtmlVersion version) {
        switch (version) {
            case HTML32: 
            case HTML40_FRAMESET: 
            case HTML40_STRICT: 
            case HTML40_TRANSATIONAL: 
            case HTML41_FRAMESET: 
            case HTML41_STRICT: 
            case HTML41_TRANSATIONAL: 
            case XHTML10_FRAMESET: 
            case XHTML10_TRANSATIONAL: 
            case XHTML10_STICT: 
            case XHTML11: {
                return true;
            }
        }
        return false;
    }
}

