/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.impl.indexing.lucene.LuceneIndexFactory;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class Context {
    private final URL rootURL;
    private final FileObject indexBaseFolder;
    private final FileObject indexFolder;
    private final String indexerName;
    private final int indexerVersion;
    private final boolean followUpJob;
    private final boolean checkForEditorModifications;
    private boolean allFilesJob;
    private final boolean sourceForBinaryRoot;
    private final CancelRequest cancelRequest;
    private FileObject root;
    private IndexingSupport indexingSupport;
    private final IndexFactoryImpl factory;

    Context(FileObject indexBaseFolder, URL rootURL, String indexerName, int indexerVersion, IndexFactoryImpl factory, boolean followUpJob, boolean checkForEditorModifications, boolean sourceForBinaryRoot, CancelRequest cancelRequest) throws IOException {
        assert (indexBaseFolder != null);
        assert (rootURL != null);
        assert (indexerName != null);
        this.indexBaseFolder = indexBaseFolder;
        this.rootURL = rootURL;
        this.indexerName = indexerName;
        this.indexerVersion = indexerVersion;
        this.factory = factory != null ? factory : new LuceneIndexFactory();
        this.followUpJob = followUpJob;
        String path = Context.getIndexerPath(indexerName, indexerVersion);
        this.indexFolder = FileUtil.createFolder((FileObject)this.indexBaseFolder, (String)path);
        this.checkForEditorModifications = checkForEditorModifications;
        this.sourceForBinaryRoot = sourceForBinaryRoot;
        this.cancelRequest = cancelRequest;
    }

    public FileObject getIndexFolder() {
        return this.indexFolder;
    }

    public URL getRootURI() {
        return this.rootURL;
    }

    public FileObject getRoot() {
        if (this.root == null) {
            this.root = URLMapper.findFileObject((URL)this.rootURL);
        }
        return this.root;
    }

    public void addSupplementaryFiles(URL root, Collection<? extends URL> files) {
        Logger repouLogger = Logger.getLogger(RepositoryUpdater.class.getName());
        if (repouLogger.isLoggable(Level.FINE)) {
            repouLogger.fine("addSupplementaryFiles: root=" + root + ", files=" + files);
        }
        RepositoryUpdater.getDefault().addIndexingJob(root, files, true, false, false, true, true);
    }

    public boolean isSupplementaryFilesIndexing() {
        return this.followUpJob;
    }

    public boolean isAllFilesIndexing() {
        return this.allFilesJob;
    }

    public boolean isSourceForBinaryRootIndexing() {
        return this.sourceForBinaryRoot;
    }

    public boolean checkForEditorModifications() {
        return this.checkForEditorModifications;
    }

    public boolean isCancelled() {
        return this.cancelRequest == null ? false : this.cancelRequest.isRaised();
    }

    IndexFactoryImpl getIndexFactory() {
        return this.factory;
    }

    String getIndexerName() {
        return this.indexerName;
    }

    int getIndexerVersion() {
        return this.indexerVersion;
    }

    void attachIndexingSupport(IndexingSupport support) {
        assert (this.indexingSupport == null);
        this.indexingSupport = support;
    }

    IndexingSupport getAttachedIndexingSupport() {
        return this.indexingSupport;
    }

    void clearAttachedIndexingSupport() {
        this.indexingSupport = null;
    }

    void setAllFilesJob(boolean allFilesJob) {
        this.allFilesJob = allFilesJob;
    }

    static String getIndexerPath(String indexerName, int indexerVersion) {
        StringBuilder sb = new StringBuilder();
        sb.append(indexerName);
        sb.append('/');
        sb.append(indexerVersion);
        return sb.toString();
    }
}

