/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policyconv;

import com.sun.xml.ws.security.impl.policyconv.SecurityPolicyUtil;
import com.sun.xml.ws.security.impl.policyconv.SignatureTargetCreator;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.Header;
import com.sun.xml.ws.security.policy.SignedElements;
import com.sun.xml.ws.security.policy.SignedParts;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class IntegrityAssertionProcessor {
    private AlgorithmSuite algorithmSuite = null;
    private boolean contentOnly = false;
    private boolean seenBody = false;
    private boolean seenAttachments = false;
    private HashSet<Header> signParts = new HashSet();
    private boolean allHeaders = false;
    private boolean ENFORCE = false;
    private SignatureTargetCreator targetCreator = null;

    public IntegrityAssertionProcessor(AlgorithmSuite algorithmSuite, boolean contentOnly) {
        this.algorithmSuite = algorithmSuite;
        this.contentOnly = contentOnly;
        this.targetCreator = new SignatureTargetCreator(false, algorithmSuite, contentOnly);
    }

    public SignatureTargetCreator getTargetCreator() {
        return this.targetCreator;
    }

    public void process(SignedParts signedParts, SignaturePolicy.FeatureBinding binding) {
        Iterator tv = signedParts.getHeaders();
        if (SecurityPolicyUtil.isSignedPartsEmpty(signedParts)) {
            SignatureTarget target;
            if (!this.allHeaders) {
                target = this.targetCreator.newURISignatureTarget("");
                this.targetCreator.addTransform(target);
                target.setValue("ALL_MESSAGE_HEADERS");
                target.isSOAPHeadersOnly(true);
                binding.addTargetBinding(target);
                target.setContentOnly(this.contentOnly);
                this.allHeaders = true;
            }
            if (!this.seenBody) {
                target = this.targetCreator.newQNameSignatureTarget(Target.BODY_QNAME);
                this.targetCreator.addTransform(target);
                binding.addTargetBinding(target);
                target.setContentOnly(this.contentOnly);
                this.seenBody = true;
            }
        } else {
            SignatureTarget target;
            while (tv.hasNext()) {
                Header ht = (Header)tv.next();
                if (this.allHeaders || this.seenSignTarget(ht)) continue;
                SignatureTarget target2 = this.targetCreator.newQNameSignatureTarget(new QName(ht.getURI(), ht.getLocalName()));
                this.targetCreator.addTransform(target2);
                target2.isSOAPHeadersOnly(true);
                target2.setContentOnly(this.contentOnly);
                binding.addTargetBinding(target2);
            }
            if (signedParts.hasBody() && !this.seenBody) {
                target = this.targetCreator.newQNameSignatureTarget(Target.BODY_QNAME);
                this.targetCreator.addTransform(target);
                target.setContentOnly(this.contentOnly);
                binding.addTargetBinding(target);
                this.seenBody = true;
            }
            if (signedParts.hasAttachments() && !this.seenAttachments) {
                target = this.targetCreator.newURISignatureTarget("");
                target.setValue("cid:*");
                this.targetCreator.addAttachmentTransform(target, signedParts.attachmentProtectionType());
                binding.addTargetBinding(target);
                this.seenAttachments = true;
            }
        }
    }

    public void process(SignedElements signedElements, SignaturePolicy.FeatureBinding binding) {
        Iterator<String> itr = signedElements.getTargets();
        while (itr.hasNext()) {
            String xpathTarget = itr.next();
            SignatureTarget target = this.targetCreator.newXpathSignatureTarget(xpathTarget);
            this.targetCreator.addTransform(target);
            target.setContentOnly(this.contentOnly);
            binding.addTargetBinding(target);
        }
    }

    private boolean seenSignTarget(Header name) {
        if (this.signParts.contains(name)) {
            return true;
        }
        this.signParts.add(name);
        return false;
    }

    public void process(QName targetName, SignaturePolicy.FeatureBinding binding) {
        SignatureTarget target = this.targetCreator.newQNameSignatureTarget(targetName);
        this.targetCreator.addTransform(target);
        binding.addTargetBinding(target);
    }
}

