/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class CsmReferenceResolver {
    private static final CsmReferenceResolver DEFAULT = new Default();

    protected CsmReferenceResolver() {
    }

    public static CsmReferenceResolver getDefault() {
        return DEFAULT;
    }

    public abstract CsmReference findReference(CsmFile var1, int var2);

    public CsmReference findReference(Node activatedNode) {
        JEditorPane pane;
        assert (activatedNode != null) : "activatedNode must be not null";
        EditorCookie c = (EditorCookie)activatedNode.getCookie(EditorCookie.class);
        if (c != null && (pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)c)) != null) {
            int offset = pane.getSelectionStart();
            CsmFile file = CsmUtilities.getCsmFile((Node)activatedNode, (boolean)false);
            if (file != null) {
                return this.findReference(file, offset);
            }
        }
        return null;
    }

    public CsmReference findReference(Document doc, int offset) {
        CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
        if (file != null) {
            return this.findReference(file, offset);
        }
        return null;
    }

    public abstract Scope fastCheckScope(CsmReference var1);

    public abstract boolean isKindOf(CsmReference var1, Set<CsmReferenceKind> var2);

    public abstract Collection<CsmReference> getReferences(CsmFile var1);

    private static final class Default
    extends CsmReferenceResolver {
        private final Lookup.Result<CsmReferenceResolver> res = Lookup.getDefault().lookupResult(CsmReferenceResolver.class);

        Default() {
        }

        @Override
        public CsmReference findReference(CsmFile file, int offset) {
            for (CsmReferenceResolver resolver : this.res.allInstances()) {
                CsmReference out = resolver.findReference(file, offset);
                if (out == null) continue;
                return out;
            }
            return null;
        }

        @Override
        public CsmReference findReference(Node activatedNode) {
            for (CsmReferenceResolver resolver : this.res.allInstances()) {
                CsmReference out = resolver.findReference(activatedNode);
                if (out == null) continue;
                return out;
            }
            return null;
        }

        @Override
        public CsmReference findReference(Document doc, int offset) {
            for (CsmReferenceResolver resolver : this.res.allInstances()) {
                CsmReference out = resolver.findReference(doc, offset);
                if (out == null) continue;
                return out;
            }
            return null;
        }

        @Override
        public Scope fastCheckScope(CsmReference ref) {
            for (CsmReferenceResolver resolver : this.res.allInstances()) {
                Scope scope = resolver.fastCheckScope(ref);
                if (scope == Scope.UNKNOWN) continue;
                return scope;
            }
            return Scope.UNKNOWN;
        }

        @Override
        public boolean isKindOf(CsmReference ref, Set<CsmReferenceKind> kinds) {
            for (CsmReferenceResolver resolver : this.res.allInstances()) {
                if (!resolver.isKindOf(ref, kinds)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<CsmReference> getReferences(CsmFile file) {
            ArrayList<CsmReference> list = new ArrayList<CsmReference>();
            for (CsmReferenceResolver resolver : this.res.allInstances()) {
                list.addAll(resolver.getReferences(file));
            }
            return list;
        }
    }

    public static enum Scope {
        LOCAL,
        FILE_LOCAL,
        GLOBAL,
        UNKNOWN;

    }
}

