/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import org.apache.lucene.search.BooleanQuery;
import org.netbeans.modules.maven.indexer.api.NBArtifactInfo;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.QueryField;
import org.netbeans.modules.maven.indexer.api.QueryRequest;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.search.OpenArtifactInfo;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.util.RequestProcessor;

public class MavenRepoProvider
implements SearchProvider {
    private static final RequestProcessor RP = new RequestProcessor(MavenRepoProvider.class.getName(), 10);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate(SearchRequest request, SearchResponse response) {
        List loadedRepos = RepositoryQueries.getLoadedContexts();
        if (loadedRepos.isEmpty()) {
            return;
        }
        ArrayList infos = new ArrayList();
        final ArrayList tempInfos = new ArrayList();
        Observer observer = new Observer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void update(Observable o, Object arg) {
                if (null == o || !(o instanceof QueryRequest)) {
                    return;
                }
                List list = tempInfos;
                synchronized (list) {
                    tempInfos.addAll(((QueryRequest)o).getResults());
                }
            }
        };
        final QueryRequest queryRequest = new QueryRequest(this.getQuery(request), loadedRepos.toArray(new RepositoryInfo[0]), observer);
        RequestProcessor.Task searchTask = RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RepositoryQueries.find((QueryRequest)queryRequest);
                }
                catch (BooleanQuery.TooManyClauses exc) {
                    List list = tempInfos;
                    synchronized (list) {
                        tempInfos.clear();
                    }
                }
                catch (OutOfMemoryError oome) {
                    List list = tempInfos;
                    synchronized (list) {
                        tempInfos.clear();
                    }
                }
            }
        });
        try {
            searchTask.waitFinished(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        queryRequest.deleteObserver(observer);
        ArrayList ex = tempInfos;
        synchronized (ex) {
            infos.addAll(tempInfos);
        }
        searchTask.cancel();
        TreeMap<String, ArrayList<NBVersionInfo>> map = new TreeMap<String, ArrayList<NBVersionInfo>>(new Comp(request.getText()));
        for (NBVersionInfo nbvi : infos) {
            String key = nbvi.getGroupId() + " : " + nbvi.getArtifactId();
            ArrayList<NBVersionInfo> get = (ArrayList<NBVersionInfo>)map.get(key);
            if (get == null) {
                get = new ArrayList<NBVersionInfo>();
                map.put(key, get);
            }
            get.add(nbvi);
        }
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            NBArtifactInfo nbai = new NBArtifactInfo((String)entry.getKey());
            nbai.addAllVersionInfos((Collection)entry.getValue());
            if (response.addResult((Runnable)new OpenArtifactInfo(nbai), nbai.getName())) continue;
            return;
        }
    }

    List<QueryField> getQuery(SearchRequest request) {
        ArrayList<QueryField> fq = new ArrayList<QueryField>();
        String q = request.getText();
        String[] splits = q.split(" ");
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("groupId");
        fields.add("artifactId");
        fields.add("name");
        fields.add("description");
        for (String one : splits) {
            for (String fld : fields) {
                QueryField f = new QueryField();
                f.setField(fld);
                f.setValue(one);
                fq.add(f);
            }
        }
        return fq;
    }

    private static class Comp
    implements Comparator<String> {
        private String query;

        public Comp(String q) {
            this.query = q;
        }

        @Override
        public int compare(String s1, String s2) {
            int index1 = s1.indexOf(this.query);
            int index2 = s2.indexOf(this.query);
            if (index1 >= 0 || index2 >= 0) {
                if (index1 < 0) {
                    return 1;
                }
                if (index2 < 0) {
                    return -1;
                }
                return s1.compareTo(s2);
            }
            return s1.compareTo(s2);
        }
    }
}

