/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.netbeans.TopSecurityManager;
import org.netbeans.core.startup.CLIOptions;
import org.netbeans.core.startup.StartLog;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.SAXParseException;

public final class TopLogging {
    private static boolean disabledConsole = !Boolean.getBoolean("netbeans.logger.console");
    private static final PrintStream OLD_ERR = System.err;
    private static final PrintStream DEBUG;
    private static final Pattern unwantedMessages;
    private static String previousUser;
    private static NonClose streamHandler;
    private static NonClose defaultHandler;
    private static final Map<Throwable, Integer> catchIndex;

    public TopLogging() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            String key = (String)e.getKey();
            if ("sun.os.patch.level".equals(key)) continue;
            String v = (String)e.getValue();
            if (!key.endsWith(".level")) continue;
            ps.print(key);
            ps.print('=');
            ps.println(v);
        }
        ps.close();
        try {
            LogManager.getLogManager().readConfiguration(new ByteArrayInputStream(os.toByteArray()));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Logger logger = Logger.getLogger("");
        Handler[] old = logger.getHandlers();
        for (int i = 0; i < old.length; ++i) {
            logger.removeHandler(old[i]);
        }
        logger.addHandler(TopLogging.defaultHandler());
        if (!disabledConsole) {
            logger.addHandler(TopLogging.streamHandler());
        }
        logger.addHandler(new LookupDel());
        StartLog.register();
    }

    public static void initializeQuietly() {
        TopLogging.initialize(false);
    }

    static final void initialize() {
        TopLogging.initialize(true);
    }

    private static void initialize(boolean verbose) {
        block11: {
            if (previousUser == null || previousUser.equals(System.getProperty("netbeans.user"))) {
                streamHandler = null;
                defaultHandler = null;
            }
            if (System.getProperty("java.util.logging.config.file") != null) {
                return;
            }
            String v = System.getProperty("java.util.logging.config.class");
            String p = TopLogging.class.getName();
            if (v != null && !v.equals(p)) {
                return;
            }
            new TopLogging();
            System.setProperty("java.util.logging.config.class", p);
            if (verbose) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(os);
                TopLogging.printSystemInfo(ps);
                ps.close();
                try {
                    Logger logger = Logger.getLogger(TopLogging.class.getName());
                    logger.log(Level.INFO, os.toString("utf-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    if ($assertionsDisabled) break block11;
                    throw new AssertionError();
                }
            }
        }
        if (!Boolean.getBoolean("netbeans.logger.noSystem")) {
            if (!(System.err instanceof LgStream)) {
                System.setErr(new LgStream(Logger.getLogger("stderr")));
                if (DEBUG != null) {
                    DEBUG.println("initializing stderr");
                }
            }
            if (!(System.out instanceof LgStream)) {
                System.setOut(new LgStream(Logger.getLogger("stderr")));
                if (DEBUG != null) {
                    DEBUG.println("initializing stdout");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printSystemInfo(PrintStream ps) {
        String cp;
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, Locale.US);
        Date date = new Date();
        ps.println("-------------------------------------------------------------------------------");
        ps.println(">Log Session: " + df.format(date));
        ps.println(">System Info: ");
        ArrayList<File> clusters = new ArrayList<File>();
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                File dir = FileUtil.normalizeFile((File)new File(tok.nextToken()));
                if (!dir.isDirectory()) continue;
                clusters.add(dir);
            }
        }
        String buildNumber = System.getProperty("netbeans.buildnumber");
        String currentVersion = NbBundle.getMessage(TopLogging.class, (String)"currentVersion", (Object)buildNumber);
        ps.print("  Product Version         = " + currentVersion);
        block6: for (File cluster : clusters) {
            File buildInfo = new File(cluster, "build_info");
            if (!buildInfo.isFile()) continue;
            try {
                FileReader r = new FileReader(buildInfo);
                try {
                    String line;
                    BufferedReader b = new BufferedReader(r);
                    Pattern p = Pattern.compile("Hg ID:    ([0-9a-f]{12})");
                    while ((line = b.readLine()) != null) {
                        Matcher m = p.matcher(line);
                        if (!m.matches()) continue;
                        ps.print(" (#" + m.group(1) + ")");
                        break block6;
                    }
                }
                finally {
                    ((Reader)r).close();
                }
            }
            catch (IOException x) {
                x.printStackTrace(ps);
            }
            break;
        }
        ps.println();
        ps.println("  Operating System        = " + System.getProperty("os.name", "unknown") + " version " + System.getProperty("os.version", "unknown") + " running on " + System.getProperty("os.arch", "unknown"));
        ps.println("  Java; VM; Vendor        = " + System.getProperty("java.version", "unknown") + "; " + System.getProperty("java.vm.name", "unknown") + " " + System.getProperty("java.vm.version", "") + "; " + System.getProperty("java.vendor", "unknown"));
        ps.println("  Runtime                 = " + System.getProperty("java.runtime.name", "unknown") + " " + System.getProperty("java.runtime.version", ""));
        ps.println("  Java Home               = " + System.getProperty("java.home", "unknown"));
        ps.print("  System Locale; Encoding = " + Locale.getDefault());
        String branding = NbBundle.getBranding();
        if (branding != null) {
            ps.print(" (" + branding + ")");
        }
        ps.println("; " + System.getProperty("file.encoding", "unknown"));
        ps.println("  Home Directory          = " + System.getProperty("user.home", "unknown"));
        ps.println("  Current Directory       = " + System.getProperty("user.dir", "unknown"));
        ps.print("  User Directory          = ");
        ps.println(CLIOptions.getUserDir());
        ps.print("  Installation            = ");
        for (File cluster : clusters) {
            ps.print(cluster + "\n                            ");
        }
        ps.println(CLIOptions.getHomeDir());
        ps.println("  Boot & Ext. Classpath   = " + TopLogging.createBootClassPath());
        ClassLoader l = Lookup.class.getClassLoader();
        if (l == ClassLoader.getSystemClassLoader()) {
            cp = System.getProperty("java.class.path", "unknown");
        } else {
            StringBuilder sb = new StringBuilder("loaded by ");
            if (l instanceof URLClassLoader) {
                sb.append("URLClassLoader");
                for (URL u : ((URLClassLoader)l).getURLs()) {
                    sb.append(' ').append(u);
                }
            } else {
                sb.append(l);
            }
            cp = sb.toString();
        }
        ps.println("  Application Classpath   = " + cp);
        ps.println("  Startup Classpath       = " + System.getProperty("netbeans.dynamic.classpath", "unknown"));
        ps.println("-------------------------------------------------------------------------------");
    }

    private static String createBootClassPath() {
        String boot = System.getProperty("sun.boot.class.path");
        StringBuffer sb = boot != null ? new StringBuffer(boot) : new StringBuffer();
        TopLogging.findBootJars(System.getProperty("java.ext.dirs"), sb);
        TopLogging.findBootJars(System.getProperty("java.endorsed.dirs"), sb);
        return sb.toString();
    }

    private static void findBootJars(String extensions, StringBuffer sb) {
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions, File.pathSeparator);
            while (st.hasMoreTokens()) {
                File dir = new File(st.nextToken());
                File[] entries = dir.listFiles();
                if (entries == null) continue;
                for (int i = 0; i < entries.length; ++i) {
                    String name = entries[i].getName().toLowerCase(Locale.US);
                    if (!name.endsWith(".zip") && !name.endsWith(".jar")) continue;
                    if (sb.length() > 0) {
                        sb.append(File.pathSeparatorChar);
                    }
                    sb.append(entries[i].getPath());
                }
            }
        }
    }

    static Handler createStreamHandler(PrintStream pw) {
        StreamHandler s = new StreamHandler(pw, NbFormatter.FORMATTER);
        return new NonClose(s, 50);
    }

    private static synchronized NonClose streamHandler() {
        if (streamHandler == null) {
            StreamHandler sth = new StreamHandler(OLD_ERR, NbFormatter.FORMATTER);
            sth.setLevel(Level.ALL);
            streamHandler = new NonClose(sth, 500);
        }
        return streamHandler;
    }

    private static synchronized NonClose defaultHandler() {
        if (defaultHandler != null) {
            return defaultHandler;
        }
        String home = System.getProperty("netbeans.user");
        if (home != null && !"memory".equals(home) && !CLIOptions.noLogging) {
            try {
                File dir = new File(new File(new File(home), "var"), "log");
                dir.mkdirs();
                File f = new File(dir, "messages.log");
                File f1 = new File(dir, "messages.log.1");
                File f2 = new File(dir, "messages.log.2");
                if (f2.exists()) {
                    f2.delete();
                }
                if (f1.exists()) {
                    f1.renameTo(f2);
                }
                if (f.exists()) {
                    f.renameTo(f1);
                }
                FileOutputStream fout = new FileOutputStream(f, false);
                StreamHandler h = new StreamHandler(fout, NbFormatter.FORMATTER);
                h.setLevel(Level.ALL);
                h.setFormatter(NbFormatter.FORMATTER);
                defaultHandler = new NonClose(h, 5000);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (defaultHandler == null) {
            defaultHandler = TopLogging.streamHandler();
            disabledConsole = true;
        }
        return defaultHandler;
    }

    static void flush(boolean clear) {
        NonClose d;
        System.err.flush();
        NonClose s = streamHandler;
        if (s != null) {
            ((Handler)s).flush();
        }
        if ((d = defaultHandler) != null) {
            ((Handler)d).flush();
        }
        if (clear) {
            streamHandler = null;
            defaultHandler = null;
        }
    }

    static void close() {
        NonClose d;
        NonClose s = streamHandler;
        if (s != null) {
            s.doClose();
        }
        if ((d = defaultHandler) != null) {
            d.doClose();
        }
    }

    static void exit(int exit) {
        TopLogging.flush(false);
        TopSecurityManager.exit((int)exit);
    }

    public static void printStackTrace(Throwable t, PrintWriter pw) {
        TopLogging.doPrintStackTrace(pw, t, null);
    }

    private static void doPrintStackTrace(PrintWriter pw, Throwable t, Throwable higher) {
        int end;
        String suffix;
        Throwable lower;
        block10: {
            try {
                if (t.getClass().getMethod("printStackTrace", PrintWriter.class).getDeclaringClass() != Throwable.class) {
                    t.printStackTrace(pw);
                    return;
                }
            }
            catch (NoSuchMethodException e) {
                if ($assertionsDisabled) break block10;
                throw new AssertionError((Object)e);
            }
        }
        if ((lower = t.getCause()) != null) {
            TopLogging.doPrintStackTrace(pw, lower, t);
            pw.print("Caused: ");
        }
        String summary = t.toString();
        if (lower != null && summary.endsWith(suffix = ": " + lower)) {
            summary = summary.substring(0, summary.length() - suffix.length());
        }
        pw.println(summary);
        StackTraceElement[] trace = t.getStackTrace();
        if (higher != null) {
            int higherEnd;
            StackTraceElement[] higherTrace = higher.getStackTrace();
            for (end = trace.length; end > 0 && (higherEnd = end + higherTrace.length - trace.length) > 0 && higherTrace[higherEnd - 1].equals(trace[end - 1]); --end) {
            }
        }
        Integer caughtIndex = catchIndex.get(t);
        for (int i = 0; i < end; ++i) {
            if (caughtIndex != null && i == caughtIndex) {
                pw.print("[catch] at ");
            } else {
                pw.print("\tat ");
            }
            pw.println(trace[i]);
        }
    }

    static {
        System.setProperty("sun.awt.exception.handler", "org.netbeans.core.startup.TopLogging$AWTHandler");
        PrintStream _D = null;
        String uMS = System.getProperty("TopLogging.unwantedMessages");
        if (uMS != null || Boolean.getBoolean("TopLogging.DEBUG")) {
            try {
                File debugLog = new File(System.getProperty("java.io.tmpdir"), "TopLogging.log");
                System.err.println("Logging sent to: " + debugLog);
                _D = new PrintStream(new FileOutputStream(debugLog), true);
            }
            catch (FileNotFoundException x) {
                x.printStackTrace();
            }
        }
        DEBUG = _D;
        Pattern uMP = null;
        if (uMS != null) {
            try {
                uMP = Pattern.compile(uMS);
                DEBUG.println("On the lookout for log messages matching: " + uMS);
            }
            catch (PatternSyntaxException x) {
                x.printStackTrace();
            }
        }
        unwantedMessages = uMP;
        catchIndex = Collections.synchronizedMap(new WeakHashMap());
    }

    public static final class AWTHandler {
        public static void handle(Throwable t) {
            if (t.getClass().getName().endsWith(".ExitSecurityException")) {
                return;
            }
            Logger g = Logger.getLogger("global");
            g.log(Level.SEVERE, null, t);
        }
    }

    private static final class LookupDel
    extends Handler
    implements LookupListener {
        private Lookup.Result<Handler> handlers = Lookup.getDefault().lookupResult(Handler.class);
        private Collection<? extends Handler> instances = this.handlers.allInstances();

        public LookupDel() {
            this.handlers.addLookupListener((LookupListener)this);
        }

        @Override
        public void publish(LogRecord record) {
            for (Handler handler : this.instances) {
                handler.publish(record);
            }
        }

        @Override
        public void flush() {
            for (Handler handler : this.instances) {
                handler.flush();
            }
        }

        @Override
        public void close() throws SecurityException {
            for (Handler handler : this.instances) {
                handler.close();
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.instances = this.handlers.allInstances();
        }
    }

    private static final class LgStream
    extends PrintStream
    implements Runnable {
        private Logger log;
        private final StringBuilder sb = new StringBuilder();
        private static RequestProcessor RP = new RequestProcessor("StdErr Flush");
        private RequestProcessor.Task flush = RP.create((Runnable)this, true);

        public LgStream(Logger log) {
            super(new ByteArrayOutputStream());
            this.log = log;
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            if (RP.isRequestProcessorThread()) {
                return;
            }
            String s = new String(buf, off, len);
            this.print(s);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int b) {
            if (RP.isRequestProcessorThread()) {
                return;
            }
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                this.sb.append((char)b);
            }
            this.checkFlush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void print(String s) {
            if (unwantedMessages != null && unwantedMessages.matcher(s).find()) {
                new Exception().printStackTrace(DEBUG);
            }
            StringBuilder stringBuilder = this.sb;
            synchronized (stringBuilder) {
                this.sb.append(s);
            }
            if (!Thread.holdsLock(this)) {
                this.checkFlush();
            }
        }

        @Override
        public void println(String x) {
            this.print(x);
            this.print(System.getProperty("line.separator"));
        }

        @Override
        public void println(Object x) {
            String s = String.valueOf(x);
            this.println(s);
        }

        @Override
        public void flush() {
            try {
                this.flush.schedule(0);
                this.flush.waitFinished(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            super.flush();
        }

        private void checkFlush() {
            try {
                this.flush.schedule(100);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block3: while (true) {
                String toLog;
                StringBuilder stringBuilder = this.sb;
                synchronized (stringBuilder) {
                    if (this.sb.length() == 0) {
                        break;
                    }
                    int last = -1;
                    for (int i = this.sb.length() - 1; i >= 0; --i) {
                        if (this.sb.charAt(i) != '\n') continue;
                        last = i;
                        break;
                    }
                    if (last == -1) {
                        break;
                    }
                    toLog = this.sb.substring(0, last + 1);
                    this.sb.delete(0, last + 1);
                }
                int begLine = 0;
                while (true) {
                    if (begLine >= toLog.length()) continue block3;
                    int endLine = toLog.indexOf(10, begLine);
                    this.log.log(Level.INFO, toLog.substring(begLine, endLine + 1));
                    begLine = endLine + 1;
                }
                break;
            }
        }
    }

    private static final class NbFormatter
    extends Formatter {
        private static String lineSeparator = System.getProperty("line.separator");
        static Formatter FORMATTER = new NbFormatter();

        private NbFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            this.print(sb, record, new HashSet<Throwable>());
            String r = sb.toString();
            if (DEBUG != null) {
                DEBUG.print("received: " + r);
            }
            if (unwantedMessages != null && unwantedMessages.matcher(r).find()) {
                new Exception().printStackTrace(DEBUG);
            }
            return r;
        }

        private void print(StringBuilder sb, LogRecord record, Set<Throwable> beenThere) {
            String message = this.formatMessage(record);
            if (message != null && message.indexOf(10) != -1 && record.getThrown() == null) {
                sb.append(message);
                if (message.charAt(message.length() - 1) != '\n') {
                    sb.append(lineSeparator);
                }
                return;
            }
            if ("stderr".equals(record.getLoggerName()) && record.getLevel() == Level.INFO) {
                sb.append(message);
                return;
            }
            sb.append(record.getLevel().getName());
            NbFormatter.addLoggerName(sb, record);
            if (message != null) {
                sb.append(": ");
                sb.append(message);
            }
            sb.append(lineSeparator);
            if (record.getThrown() != null && record.getLevel().intValue() != 1973) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    TopLogging.printStackTrace(record.getThrown(), pw);
                    pw.close();
                    sb.append(sw.toString());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                LogRecord[] arr = NbFormatter.extractDelegates(sb, record.getThrown(), beenThere);
                if (arr != null) {
                    for (LogRecord r : arr) {
                        this.print(sb, r, beenThere);
                    }
                }
                this.specialProcessing(sb, record.getThrown(), beenThere);
            }
        }

        private static void addLoggerName(StringBuilder sb, LogRecord record) {
            String name = record.getLoggerName();
            if (!"".equals(name)) {
                sb.append(" [");
                sb.append(name);
                sb.append(']');
            }
        }

        private static LogRecord[] extractDelegates(StringBuilder sb, Throwable t, Set<Throwable> beenThere) {
            if (!beenThere.add(t)) {
                sb.append("warning: cyclic dependency between annotated throwables");
                return null;
            }
            if (t instanceof Callable) {
                Object rec = null;
                try {
                    rec = ((Callable)((Object)t)).call();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (rec instanceof LogRecord[]) {
                    return rec;
                }
            }
            if (t == null) {
                return null;
            }
            return NbFormatter.extractDelegates(sb, t.getCause(), beenThere);
        }

        private void specialProcessing(StringBuilder sb, Throwable t, Set<Throwable> beenThere) {
            if (t instanceof MissingResourceException) {
                String k;
                MissingResourceException mre = (MissingResourceException)t;
                String cn = mre.getClassName();
                if (cn != null) {
                    LogRecord rec = new LogRecord(Level.CONFIG, null);
                    rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    rec.setMessage("EXC_MissingResourceException_class_name");
                    rec.setParameters(new Object[]{cn});
                    this.print(sb, rec, beenThere);
                }
                if ((k = mre.getKey()) != null) {
                    LogRecord rec = new LogRecord(Level.CONFIG, null);
                    rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    rec.setMessage("EXC_MissingResourceException_key");
                    rec.setParameters(new Object[]{k});
                    this.print(sb, rec, beenThere);
                }
            }
            if (t instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)t;
                String pubid = spe.getPublicId();
                String sysid = spe.getSystemId();
                if (pubid != null || sysid != null) {
                    Object[] param;
                    String msg;
                    int col = spe.getColumnNumber();
                    int line = spe.getLineNumber();
                    if (col != -1 || line != -1) {
                        msg = "EXC_sax_parse_col_line";
                        param = new Object[]{String.valueOf(pubid), String.valueOf(sysid), col, line};
                    } else {
                        msg = "EXC_sax_parse";
                        param = new Object[]{String.valueOf(pubid), String.valueOf(sysid)};
                    }
                    LogRecord rec = new LogRecord(Level.CONFIG, null);
                    rec.setResourceBundle(NbBundle.getBundle(TopLogging.class));
                    rec.setMessage(msg);
                    rec.setParameters(param);
                    this.print(sb, rec, beenThere);
                }
            }
        }
    }

    private static final class NonClose
    extends Handler
    implements Runnable {
        private static RequestProcessor RP = new RequestProcessor("Logging Flush", 1, false, false);
        private static ThreadLocal<Boolean> FLUSHING = new ThreadLocal();
        private final Handler delegate;
        private final BlockingQueue<LogRecord> queue = new LinkedBlockingQueue<LogRecord>(1000);
        private RequestProcessor.Task flush;
        private int delay;

        public NonClose(Handler h, int delay) {
            this.delegate = h;
            this.flush = RP.create((Runnable)this, true);
            this.flush.setPriority(1);
            this.delay = delay;
        }

        @Override
        public void publish(LogRecord record) {
            Throwable t;
            if (RP.isRequestProcessorThread()) {
                return;
            }
            if (!this.queue.offer(record)) {
                while (true) {
                    try {
                        if (!this.schedule(0)) {
                            return;
                        }
                        this.queue.put(record);
                        Thread.yield();
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    break;
                }
            }
            if ((t = record.getThrown()) != null) {
                StackTraceElement[] tStack = t.getStackTrace();
                StackTraceElement[] hereStack = new Throwable().getStackTrace();
                for (int i = 1; i <= Math.min(tStack.length, hereStack.length); ++i) {
                    if (tStack[tStack.length - i].equals(hereStack[hereStack.length - i])) continue;
                    catchIndex.put(t, tStack.length - i);
                    break;
                }
            }
            this.schedule(this.delay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean schedule(int d) {
            if (!Boolean.TRUE.equals(FLUSHING.get())) {
                try {
                    FLUSHING.set(true);
                    this.flush.schedule(d);
                }
                finally {
                    FLUSHING.set(false);
                }
                return true;
            }
            return false;
        }

        @Override
        public void flush() {
            this.flush.cancel();
            this.flush.waitFinished();
            this.run();
        }

        @Override
        public void close() throws SecurityException {
            this.flush();
            this.delegate.flush();
        }

        public void doClose() throws SecurityException {
            this.flush();
            this.delegate.close();
        }

        @Override
        public Formatter getFormatter() {
            return this.delegate.getFormatter();
        }

        static Handler getInternal(Handler h) {
            if (h instanceof NonClose) {
                return ((NonClose)h).delegate;
            }
            return h;
        }

        @Override
        public void run() {
            LogRecord r;
            while ((r = (LogRecord)this.queue.poll()) != null) {
                this.delegate.publish(r);
            }
            this.delegate.flush();
        }
    }
}

