/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tomcat5.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.tomcat5.TomcatManager;
import org.netbeans.modules.tomcat5.util.LogSupport;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class ServerLog
extends Thread {
    private final InputOutput io;
    private final OutputWriter writer;
    private final OutputWriter errorWriter;
    private final BufferedReader inReader;
    private final BufferedReader errReader;
    private final boolean autoFlush;
    private final boolean takeFocus;
    private volatile boolean done = false;
    private final ServerLogSupport logSupport;
    private final TomcatManager tomcatManager;

    public ServerLog(TomcatManager tomcatManager, String displayName, Reader in, Reader err, boolean autoFlush, boolean takeFocus) {
        super(displayName + " ServerLog - Thread");
        this.setDaemon(true);
        this.inReader = new BufferedReader(in);
        this.errReader = new BufferedReader(err);
        this.autoFlush = autoFlush;
        this.takeFocus = takeFocus;
        this.tomcatManager = tomcatManager;
        this.io = UISupport.getServerIO((String)tomcatManager.getUri());
        try {
            this.io.getOut().reset();
        }
        catch (IOException e) {
            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, e);
        }
        this.writer = this.io.getOut();
        this.errorWriter = this.io.getErr();
        this.io.select();
        this.logSupport = new ServerLogSupport();
    }

    private void processLine(String line) {
        LogSupport.LineInfo lineInfo = this.logSupport.analyzeLine(line);
        if (lineInfo.isError()) {
            if (lineInfo.isAccessible()) {
                try {
                    this.errorWriter.println(line, (OutputListener)this.logSupport.getLink(lineInfo.message(), lineInfo.path(), lineInfo.line()));
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.errorWriter.println(line);
            }
        } else {
            this.writer.println(line);
            if (line.startsWith("SEVERE: WSSERVLET11: failed to parse runtime descriptor: java.lang.LinkageError:")) {
                File jaxwsApi = InstalledFileLocator.getDefault().locate("modules/ext/jaxws21/api/jaxws-api.jar", null, false);
                File jaxbApi = InstalledFileLocator.getDefault().locate("modules/ext/jaxb/api/jaxb-api.jar", null, false);
                File endoresedDir = this.tomcatManager.getTomcatProperties().getJavaEndorsedDir();
                if (jaxwsApi != null && jaxbApi != null) {
                    this.writer.println(NbBundle.getMessage(ServerLog.class, (String)"MSG_WSSERVLET11", (Object)jaxwsApi.getParent(), (Object)jaxbApi.getParent(), (Object)endoresedDir));
                } else {
                    this.writer.println(NbBundle.getMessage(ServerLog.class, (String)"MSG_WSSERVLET11_NOJAR", (Object)endoresedDir));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.done) {
                boolean isInReaderReady = false;
                boolean isErrReaderReady = false;
                boolean updated = false;
                int count = 0;
                while (((isInReaderReady = this.inReader.ready()) || (isErrReaderReady = this.errReader.ready())) && count++ < 1024) {
                    String line;
                    if (this.done) {
                        return;
                    }
                    updated = true;
                    if (isInReaderReady) {
                        line = this.inReader.readLine();
                        if (line == null) {
                            return;
                        }
                        this.processLine(line);
                    }
                    if (!isErrReaderReady) continue;
                    line = this.errReader.readLine();
                    if (line == null) {
                        return;
                    }
                    this.processLine(line);
                }
                if (updated) {
                    if (this.autoFlush) {
                        this.writer.flush();
                        this.errorWriter.flush();
                    }
                    if (this.takeFocus) {
                        this.io.select();
                    }
                }
                ServerLog.sleep(100L);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, ex);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.logSupport.detachAnnotation();
            this.writer.close();
            this.errorWriter.close();
        }
    }

    public boolean isRunning() {
        return !this.done;
    }

    public void takeFocus() {
        this.io.select();
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.done = true;
    }

    static class ServerLogSupport
    extends LogSupport {
        private String prevMessage;
        private GlobalPathRegistry globalPathRegistry = GlobalPathRegistry.getDefault();

        ServerLogSupport() {
        }

        public LogSupport.LineInfo analyzeLine(String logLine) {
            String path = null;
            int line = -1;
            String message = null;
            boolean error = false;
            boolean accessible = false;
            logLine = logLine.trim();
            int lineLenght = logLine.length();
            if (logLine.startsWith("/")) {
                error = true;
                int colonIdx = logLine.indexOf(58);
                if (colonIdx > -1) {
                    int nextColonIdx;
                    path = logLine.substring(0, colonIdx);
                    accessible = true;
                    if (lineLenght > colonIdx && (nextColonIdx = logLine.indexOf(58, colonIdx + 1)) > -1) {
                        String lineNum = logLine.substring(colonIdx + 1, nextColonIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, nfe);
                        }
                        if (lineLenght > nextColonIdx) {
                            message = logLine.substring(nextColonIdx + 1, lineLenght);
                        }
                    }
                }
            } else if (lineLenght > 3 && Character.isLetter(logLine.charAt(0)) && logLine.charAt(1) == ':' && logLine.charAt(2) == '\\') {
                error = true;
                int secondColonIdx = logLine.indexOf(58, 2);
                if (secondColonIdx > -1) {
                    int thirdColonIdx;
                    path = logLine.substring(0, secondColonIdx);
                    accessible = true;
                    if (lineLenght > secondColonIdx && (thirdColonIdx = logLine.indexOf(58, secondColonIdx + 1)) > -1) {
                        String lineNum = logLine.substring(secondColonIdx + 1, thirdColonIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, nfe);
                        }
                        if (lineLenght > thirdColonIdx) {
                            message = logLine.substring(thirdColonIdx + 1, lineLenght);
                        }
                    }
                }
            } else if (logLine.startsWith("at ") && lineLenght > 3) {
                String classWithMethod;
                int lastDotIdx;
                error = true;
                int parenthIdx = logLine.indexOf(40);
                if (parenthIdx > -1 && (lastDotIdx = (classWithMethod = logLine.substring(3, parenthIdx)).lastIndexOf(46)) > -1) {
                    int firstDolarIdx;
                    int lastParenthIdx = logLine.lastIndexOf(41);
                    int lastColonIdx = logLine.lastIndexOf(58);
                    if (lastParenthIdx > -1 && lastColonIdx > -1) {
                        String lineNum = logLine.substring(lastColonIdx + 1, lastParenthIdx);
                        try {
                            line = Integer.valueOf(lineNum);
                        }
                        catch (NumberFormatException nfe) {
                            Logger.getLogger(ServerLog.class.getName()).log(Level.INFO, null, nfe);
                        }
                        message = this.prevMessage;
                    }
                    String className = classWithMethod.substring(0, (firstDolarIdx = classWithMethod.indexOf(36)) > -1 ? firstDolarIdx : lastDotIdx);
                    path = className.replace('.', '/') + ".java";
                    accessible = this.globalPathRegistry.findResource(path) != null;
                }
            } else {
                this.prevMessage = logLine;
            }
            return new LogSupport.LineInfo(path, line, message, error, accessible);
        }
    }
}

