/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.j2ee;

import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.j2ee.deployment.common.api.J2eeLibraryTypeProvider;
import org.netbeans.modules.j2ee.deployment.common.api.Version;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibrary;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerLibraryDependency;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl2;
import org.netbeans.modules.j2ee.deployment.plugins.spi.support.LookupProviderSupport;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.WLPluginProperties;
import org.netbeans.modules.j2ee.weblogic9.config.WLServerLibrarySupport;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WLJ2eePlatformFactory
extends J2eePlatformFactory {
    private static final Logger LOGGER = Logger.getLogger(WLJ2eePlatformFactory.class.getName());
    private static final String OPENJPA_JPA_PROVIDER = "org.apache.openjpa.persistence.PersistenceProviderImpl";
    private static final String ECLIPSELINK_JPA_PROVIDER = "org.eclipse.persistence.jpa.PersistenceProvider";
    private static final Pattern JAVAX_PERSISTENCE_PATTERN = Pattern.compile("^.*javax\\.persistence.*_1-\\d+-\\d+\\.jar$");
    private static final Pattern JAVAX_PERSISTENCE_2_PATTERN = Pattern.compile("^.*javax\\.persistence.*_2-\\d+-\\d+\\.jar$");
    private static final Pattern OEPE_CONTRIBUTIONS_PATTERN = Pattern.compile("^.*oepe-contributions\\.jar.*$");
    private static final FilenameFilter DWP_LIBRARY_FILTER = new PrefixesFilter("javax.", "glassfish.jsf", "glassfish.jstl", "org.eclipse.persistence");
    private static final FilenameFilter PATCH_DIR_FILTER = new PrefixesFilter("patch_wls");

    public J2eePlatformImpl getJ2eePlatformImpl(DeploymentManager dm) {
        assert (WLDeploymentManager.class.isAssignableFrom(dm.getClass())) : (Object)((Object)this) + " cannot create platform for unknown deployment manager:" + dm;
        return ((WLDeploymentManager)dm).getJ2eePlatformImpl();
    }

    public static List<URL> getWLSClassPath(@NonNull File platformRoot, @NullAllowed File mwHome, @NullAllowed J2eePlatformImplImpl j2eePlatform) {
        ArrayList<URL> list = new ArrayList<URL>();
        try {
            File[] patchDirCandidates;
            File apiFile;
            File weblogicFile = new File(platformRoot, "server/lib/weblogic.jar");
            if (weblogicFile.exists()) {
                list.add(WLJ2eePlatformFactory.fileToUrl(weblogicFile));
            }
            if ((apiFile = new File(platformRoot, "server/lib/api.jar")).exists()) {
                list.add(WLJ2eePlatformFactory.fileToUrl(apiFile));
                list.addAll(WLJ2eePlatformFactory.getJarClassPath(apiFile));
            }
            if (mwHome != null && (patchDirCandidates = mwHome.listFiles(PATCH_DIR_FILTER)) != null) {
                for (File candidate : patchDirCandidates) {
                    File jarFile = FileUtil.normalizeFile((File)new File(candidate, "profiles/default/sys_manifest_classpath/weblogic_patch.jar"));
                    if (!jarFile.exists()) continue;
                    list.add(WLJ2eePlatformFactory.fileToUrl(jarFile));
                    List<URL> deps = WLJ2eePlatformFactory.getJarClassPath(jarFile);
                    list.addAll(deps);
                    for (URL dep : deps) {
                        List<URL> innerDeps = WLJ2eePlatformFactory.getJarClassPath(dep);
                        list.addAll(innerDeps);
                        for (URL innerDep : innerDeps) {
                            if (!innerDep.getPath().contains("patch_jars")) continue;
                            list.addAll(WLJ2eePlatformFactory.getJarClassPath(innerDep));
                        }
                    }
                }
            }
            if (weblogicFile.exists()) {
                List<URL> cp = WLJ2eePlatformFactory.getJarClassPath(weblogicFile);
                URL oepe = null;
                for (URL cpElem : cp) {
                    if (!OEPE_CONTRIBUTIONS_PATTERN.matcher(cpElem.getPath()).matches()) continue;
                    oepe = cpElem;
                    break;
                }
                if (oepe != null) {
                    list.addAll(WLJ2eePlatformFactory.getJarClassPath(oepe));
                }
            }
            WLJ2eePlatformFactory.addPersistenceLibrary(list, mwHome, j2eePlatform);
            list.add(WLJ2eePlatformFactory.fileToUrl(new File(platformRoot, "server/lib/wls-api.jar")));
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.WARNING, null, e);
        }
        return list;
    }

    static URL fileToUrl(File file) throws MalformedURLException {
        URL url = file.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        }
        return url;
    }

    static List<URL> getJarClassPath(URL url) {
        File file;
        FileObject fo;
        URL fileUrl = FileUtil.getArchiveFile((URL)url);
        if (fileUrl != null && (fo = URLMapper.findFileObject((URL)fileUrl)) != null && (file = FileUtil.toFile((FileObject)fo)) != null) {
            return WLJ2eePlatformFactory.getJarClassPath(file);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<URL> getJarClassPath(File jarFile) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            JarFile file = new JarFile(jarFile);
            try {
                Manifest manifest = file.getManifest();
                Attributes attrs = manifest.getMainAttributes();
                String value = attrs.getValue("Class-Path");
                if (value != null) {
                    String[] values = value.split("\\s+");
                    File parent = FileUtil.normalizeFile((File)jarFile).getParentFile();
                    if (parent != null) {
                        for (String cpElement : values) {
                            if ("".equals(cpElement.trim())) continue;
                            File f = new File(cpElement);
                            if (!f.isAbsolute()) {
                                f = new File(parent, cpElement);
                            }
                            if (!(f = FileUtil.normalizeFile((File)f)).exists()) continue;
                            urls.add(WLJ2eePlatformFactory.fileToUrl(f));
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, "Could not read WebLogic JAR", ex);
            }
            finally {
                file.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Could not open WebLogic JAR", ex);
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addPersistenceLibrary(List<URL> list, @NullAllowed File middleware, @NullAllowed J2eePlatformImplImpl j2eePlatform) throws MalformedURLException {
        File[] persistenceCandidates;
        File modules;
        boolean foundJpa2 = false;
        boolean foundJpa1 = false;
        Object it = list.iterator();
        while (it.hasNext()) {
            URL archiveUrl = FileUtil.getArchiveFile((URL)it.next());
            if (archiveUrl == null) continue;
            if (JAVAX_PERSISTENCE_2_PATTERN.matcher(archiveUrl.getPath()).matches()) {
                foundJpa2 = true;
                break;
            }
            if (!JAVAX_PERSISTENCE_PATTERN.matcher(archiveUrl.getPath()).matches()) continue;
            foundJpa1 = true;
            break;
        }
        if (j2eePlatform != null) {
            it = j2eePlatform;
            synchronized (it) {
                j2eePlatform.jpa2Available = foundJpa2;
            }
        }
        if (foundJpa2 || foundJpa1) {
            return;
        }
        if (middleware != null && (modules = new File(middleware, "modules")).exists() && modules.isDirectory() && (persistenceCandidates = modules.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return JAVAX_PERSISTENCE_PATTERN.matcher(name).matches();
            }
        })).length > 0) {
            for (File candidate : persistenceCandidates) {
                list.add(WLJ2eePlatformFactory.fileToUrl(candidate));
            }
            if (persistenceCandidates.length > 1) {
                LOGGER.log(Level.INFO, "Multiple javax.persistence JAR candidates");
            }
        }
    }

    private static class PrefixesFilter
    implements FilenameFilter {
        private final String[] prefixes;

        public PrefixesFilter(String ... prefixes) {
            this.prefixes = prefixes;
        }

        @Override
        public boolean accept(File dir, String name) {
            for (String prefix : this.prefixes) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
    }

    private static class JPAHandler
    extends DefaultHandler {
        private String defaultJPAProvider;
        private String value;
        private boolean start;

        @Override
        public void startElement(String uri, String localName, String qName, org.xml.sax.Attributes attributes) throws SAXException {
            this.value = null;
            if ("default-jpa-provider".equals(qName)) {
                this.start = true;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (!this.start) {
                return;
            }
            if ("default-jpa-provider".equals(qName)) {
                this.defaultJPAProvider = this.value;
                this.start = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.value = new String(ch, start, length);
        }

        public String getDefaultJPAProvider() {
            return this.defaultJPAProvider;
        }
    }

    private static class DomainChangeListener
    implements ChangeListener {
        private final J2eePlatformImplImpl platform;
        private Set<WLServerLibrarySupport.WLServerLibrary> oldLibraries = Collections.emptySet();

        public DomainChangeListener(J2eePlatformImplImpl platform) {
            this.platform = platform;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            J2eePlatformImplImpl j2eePlatformImplImpl = this.platform;
            synchronized (j2eePlatformImplImpl) {
                this.platform.defaultJpaProvider = null;
            }
            Set<WLServerLibrarySupport.WLServerLibrary> tmpNewLibraries = new WLServerLibrarySupport(this.platform.dm).getDeployedLibraries();
            HashSet<WLServerLibrarySupport.WLServerLibrary> tmpOldLibraries = null;
            DomainChangeListener domainChangeListener = this;
            synchronized (domainChangeListener) {
                tmpOldLibraries = new HashSet<WLServerLibrarySupport.WLServerLibrary>(this.oldLibraries);
                this.oldLibraries = tmpNewLibraries;
            }
            if (this.fireChange(tmpOldLibraries, tmpNewLibraries)) {
                LOGGER.log(Level.FINE, "Firing server libraries change");
                this.platform.firePropertyChange("serverLibraries", null, null);
            }
        }

        private boolean fireChange(Set<WLServerLibrarySupport.WLServerLibrary> paramOldLibraries, Set<WLServerLibrarySupport.WLServerLibrary> paramNewLibraries) {
            if (paramOldLibraries.size() != paramNewLibraries.size()) {
                return true;
            }
            HashSet<WLServerLibrarySupport.WLServerLibrary> newLibraries = new HashSet<WLServerLibrarySupport.WLServerLibrary>(paramNewLibraries);
            Iterator it = newLibraries.iterator();
            block0: while (it.hasNext()) {
                WLServerLibrarySupport.WLServerLibrary newLib = (WLServerLibrarySupport.WLServerLibrary)it.next();
                for (WLServerLibrarySupport.WLServerLibrary oldLib : paramOldLibraries) {
                    if (!WLServerLibrarySupport.sameLibraries(newLib, oldLib)) continue;
                    it.remove();
                    continue block0;
                }
            }
            return !newLibraries.isEmpty();
        }
    }

    public static class J2eePlatformImplImpl
    extends J2eePlatformImpl2 {
        private static final String ICON = "org/netbeans/modules/j2ee/weblogic9/resources/16x16.gif";
        private static final String J2EE_API_DOC = "docs/javaee6-doc-api.zip";
        private final Set<J2eeModule.Type> moduleTypes = new HashSet<J2eeModule.Type>();
        private final Set<Profile> profiles = new HashSet<Profile>();
        private final WLDeploymentManager dm;
        private final ChangeListener domainChangeListener;
        private String platformRoot;
        private LibraryImplementation[] libraries = null;
        private String defaultJpaProvider;
        private boolean jpa2Available;

        public J2eePlatformImplImpl(WLDeploymentManager dm) {
            this.dm = dm;
            this.moduleTypes.add(J2eeModule.Type.WAR);
            if (!dm.isWebProfile()) {
                this.moduleTypes.add(J2eeModule.Type.EJB);
                this.moduleTypes.add(J2eeModule.Type.EAR);
            }
            this.profiles.add(Profile.J2EE_14);
            Version version = dm.getDomainVersion();
            if (version != null) {
                if (version.isAboveOrEqual(WLDeploymentFactory.VERSION_10)) {
                    this.profiles.add(Profile.JAVA_EE_5);
                }
                if (version.isAboveOrEqual(WLDeploymentFactory.VERSION_11)) {
                    if (!dm.isWebProfile()) {
                        this.profiles.add(Profile.JAVA_EE_6_FULL);
                    }
                    this.profiles.add(Profile.JAVA_EE_6_WEB);
                }
            }
            this.domainChangeListener = new DomainChangeListener(this);
            dm.addDomainChangeListener(WeakListeners.change((ChangeListener)this.domainChangeListener, (Object)dm));
        }

        public boolean isToolSupported(String toolName) {
            if ("wsgen".equals(toolName) || "wsimport".equals(toolName)) {
                return true;
            }
            if ("jsr109".equals(toolName)) {
                return false;
            }
            if ("defaultPersistenceProviderJavaEE5".equals(toolName)) {
                return true;
            }
            if ("jpaversionverification".equals(toolName)) {
                return true;
            }
            if ("jpa1.0".equals(toolName)) {
                return true;
            }
            if ("jpa2.0".equals(toolName)) {
                return this.isJpa2Available();
            }
            if (!("openJpaPersistenceProviderIsDefault1.0".equals(toolName) || "eclipseLinkPersistenceProviderIsDefault".equals(toolName) || WLJ2eePlatformFactory.OPENJPA_JPA_PROVIDER.equals(toolName) || WLJ2eePlatformFactory.ECLIPSELINK_JPA_PROVIDER.equals(toolName))) {
                return false;
            }
            String currentDefaultJpaProvider = this.getDefaultJpaProvider();
            if ("openJpaPersistenceProviderIsDefault1.0".equals(toolName)) {
                return currentDefaultJpaProvider.equals(WLJ2eePlatformFactory.OPENJPA_JPA_PROVIDER);
            }
            if ("eclipseLinkPersistenceProviderIsDefault".equals(toolName)) {
                return currentDefaultJpaProvider.equals(WLJ2eePlatformFactory.ECLIPSELINK_JPA_PROVIDER);
            }
            return WLJ2eePlatformFactory.OPENJPA_JPA_PROVIDER.equals(toolName) || WLJ2eePlatformFactory.ECLIPSELINK_JPA_PROVIDER.equals(toolName);
        }

        public File[] getToolClasspathEntries(String toolName) {
            File weblogicJar;
            File[] cp = new File[]{};
            if (("wsgen".equals(toolName) || "wsimport".equals(toolName)) && (weblogicJar = WLPluginProperties.getWeblogicJar(this.dm)) != null) {
                cp = new File[]{weblogicJar};
            }
            return cp;
        }

        public Set<Profile> getSupportedProfiles() {
            return this.profiles;
        }

        public Set<J2eeModule.Type> getSupportedTypes() {
            return this.moduleTypes;
        }

        public Set getSupportedJavaPlatformVersions() {
            HashSet<String> versions = new HashSet<String>();
            versions.add("1.4");
            versions.add("1.5");
            return versions;
        }

        public JavaPlatform getJavaPlatform() {
            return null;
        }

        public File[] getPlatformRoots() {
            File server = this.getServerHome();
            File domain = this.getDomainHome();
            File middleware = this.getMiddlewareHome();
            if (middleware != null) {
                return new File[]{server, domain, middleware};
            }
            return new File[]{server, domain};
        }

        public File getDomainHome() {
            File domain = new File(this.dm.getInstanceProperties().getProperty("domainRoot"));
            assert (domain.isAbsolute());
            return domain;
        }

        public File getServerHome() {
            File server = new File(this.getPlatformRoot());
            assert (server.isAbsolute());
            return server;
        }

        public File getMiddlewareHome() {
            return WLPluginProperties.getMiddlewareHome(this.getServerHome());
        }

        public synchronized LibraryImplementation[] getLibraries() {
            if (this.libraries != null) {
                return this.libraries;
            }
            if (this.dm.isWebProfile()) {
                this.initLibrariesForDWP();
            } else {
                this.initLibrariesForWLS();
            }
            return this.libraries;
        }

        public LibraryImplementation[] getLibraries(Set<ServerLibraryDependency> libraries) {
            String domainDir = this.dm.getInstanceProperties().getProperty("domainRoot");
            assert (domainDir != null);
            String serverDir = this.dm.getInstanceProperties().getProperty("serverRoot");
            assert (serverDir != null);
            WLServerLibrarySupport support = new WLServerLibrarySupport(new File(serverDir), new File(domainDir));
            Map<ServerLibrary, List<File>> serverLibraries = null;
            try {
                serverLibraries = support.getClasspathEntries(libraries);
            }
            catch (ConfigurationException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            if (serverLibraries == null || serverLibraries.isEmpty()) {
                return this.getLibraries();
            }
            ArrayList<LibraryImplementation> serverImpl = new ArrayList<LibraryImplementation>();
            for (Map.Entry<ServerLibrary, List<File>> entry : serverLibraries.entrySet()) {
                LibraryImplementation library = new J2eeLibraryTypeProvider().createLibrary();
                ServerLibrary lib = entry.getKey();
                if (lib.getSpecificationTitle() == null && lib.getName() == null) {
                    library.setName(NbBundle.getMessage(WLJ2eePlatformFactory.class, (String)"UNKNOWN_SERVER_LIBRARY_NAME"));
                } else {
                    library.setName(NbBundle.getMessage(WLJ2eePlatformFactory.class, (String)"SERVER_LIBRARY_NAME", (Object[])new Object[]{lib.getSpecificationTitle() == null ? lib.getName() : lib.getSpecificationTitle(), lib.getSpecificationVersion() == null ? "" : lib.getSpecificationVersion()}));
                }
                ArrayList<URL> cp = new ArrayList<URL>();
                for (File file : entry.getValue()) {
                    try {
                        cp.add(WLJ2eePlatformFactory.fileToUrl(file));
                    }
                    catch (MalformedURLException ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                }
                library.setContent("classpath", cp);
                serverImpl.add(library);
            }
            serverImpl.addAll(Arrays.asList(this.getLibraries()));
            return serverImpl.toArray(new LibraryImplementation[serverImpl.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyLibrariesChange() {
            J2eePlatformImplImpl j2eePlatformImplImpl = this;
            synchronized (j2eePlatformImplImpl) {
                this.libraries = null;
            }
            this.firePropertyChange("libraries", null, this.getLibraries());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initLibrariesForWLS() {
            LibraryImplementation library = new J2eeLibraryTypeProvider().createLibrary();
            library.setName(NbBundle.getMessage(WLJ2eePlatformFactory.class, (String)"LIBRARY_NAME"));
            try {
                ArrayList<URL> list = new ArrayList<URL>();
                list.addAll(WLJ2eePlatformFactory.getWLSClassPath(this.getServerHome(), this.getMiddlewareHome(), this));
                library.setContent("classpath", list);
                File j2eeDoc = InstalledFileLocator.getDefault().locate(J2EE_API_DOC, null, false);
                if (j2eeDoc != null) {
                    list = new ArrayList();
                    list.add(WLJ2eePlatformFactory.fileToUrl(j2eeDoc));
                    library.setContent("javadoc", list);
                }
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            J2eePlatformImplImpl j2eePlatformImplImpl = this;
            synchronized (j2eePlatformImplImpl) {
                this.libraries = new LibraryImplementation[1];
                this.libraries[0] = library;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initLibrariesForDWP() {
            LibraryImplementation library = new J2eeLibraryTypeProvider().createLibrary();
            library.setName(NbBundle.getMessage(WLJ2eePlatformFactory.class, (String)"LIBRARY_NAME"));
            try {
                File[] apis;
                File modules;
                ArrayList<URL> list = new ArrayList<URL>();
                File middleware = this.getMiddlewareHome();
                if (middleware != null && (modules = new File(middleware, "modules")).exists() && modules.isDirectory() && (apis = modules.listFiles(DWP_LIBRARY_FILTER)) != null) {
                    for (File file : apis) {
                        list.add(WLJ2eePlatformFactory.fileToUrl(file));
                    }
                }
                library.setContent("classpath", list);
                File j2eeDoc = InstalledFileLocator.getDefault().locate(J2EE_API_DOC, null, false);
                if (j2eeDoc != null) {
                    list = new ArrayList();
                    list.add(WLJ2eePlatformFactory.fileToUrl(j2eeDoc));
                    library.setContent("javadoc", list);
                }
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            J2eePlatformImplImpl j2eePlatformImplImpl = this;
            synchronized (j2eePlatformImplImpl) {
                this.libraries = new LibraryImplementation[1];
                this.libraries[0] = library;
            }
        }

        public synchronized boolean isJpa2Available() {
            if (this.libraries != null) {
                return this.jpa2Available;
            }
            this.getLibraries();
            return this.jpa2Available;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDefaultJpaProvider() {
            J2eePlatformImplImpl j2eePlatformImplImpl = this;
            synchronized (j2eePlatformImplImpl) {
                if (this.defaultJpaProvider != null) {
                    return this.defaultJpaProvider;
                }
            }
            String newDefaultJpaProvider = null;
            FileObject config = WLPluginProperties.getDomainConfigFileObject(this.dm);
            if (config != null) {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser parser = factory.newSAXParser();
                    JPAHandler handler = new JPAHandler();
                    BufferedInputStream is = new BufferedInputStream(config.getInputStream());
                    try {
                        parser.parse((InputStream)is, (DefaultHandler)handler);
                        newDefaultJpaProvider = handler.getDefaultJPAProvider();
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
                catch (ParserConfigurationException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
                catch (SAXException ex) {
                    LOGGER.log(Level.INFO, null, ex);
                }
            }
            if (newDefaultJpaProvider == null) {
                newDefaultJpaProvider = WLJ2eePlatformFactory.OPENJPA_JPA_PROVIDER;
            }
            J2eePlatformImplImpl j2eePlatformImplImpl2 = this;
            synchronized (j2eePlatformImplImpl2) {
                this.defaultJpaProvider = newDefaultJpaProvider;
                return this.defaultJpaProvider;
            }
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)ICON);
        }

        public String getDisplayName() {
            return NbBundle.getMessage(WLJ2eePlatformFactory.class, (String)"PLATFORM_NAME");
        }

        private String getPlatformRoot() {
            if (this.platformRoot == null) {
                this.platformRoot = this.dm.getInstanceProperties().getProperty("serverRoot");
            }
            return this.platformRoot;
        }

        public Lookup getLookup() {
            Lookup baseLookup = Lookups.fixed((Object[])new Object[]{new File(this.getPlatformRoot())});
            return LookupProviderSupport.createCompositeLookup((Lookup)baseLookup, (String)"J2EE/DeploymentPlugins/WebLogic9/Lookup");
        }
    }
}

