/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class ConfigUtil {
    private ConfigUtil() {
    }

    public static void writefile(final File file, final BaseBean bean) throws ConfigurationException {
        try {
            FileObject cfolder = FileUtil.toFileObject((File)file.getParentFile());
            if (cfolder == null) {
                File parentFile = file.getParentFile();
                try {
                    cfolder = FileUtil.createFolder((File)parentFile);
                }
                catch (IOException ioe) {
                    String msg = NbBundle.getMessage(ConfigUtil.class, (String)"MSG_FailedToCreateConfigFolder", (Object)parentFile.getPath());
                    throw new ConfigurationException(msg, (Throwable)ioe);
                }
            }
            final FileObject folder = cfolder;
            FileSystem fs = folder.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    String name = file.getName();
                    FileObject configFO = FileUtil.createData((FileObject)folder, (String)name);
                    FileLock lock = configFO.lock();
                    try {
                        BufferedOutputStream os = new BufferedOutputStream(configFO.getOutputStream(lock), 4086);
                        try {
                            if (bean != null) {
                                bean.write((OutputStream)os);
                            }
                        }
                        finally {
                            ((OutputStream)os).close();
                        }
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
            });
        }
        catch (IOException e) {
            String msg = NbBundle.getMessage(ConfigUtil.class, (String)"MSG_writeToFileFailed", (Object)file.getPath());
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }
}

