/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.debug.CndDiagnosticProvider;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmStandaloneFileProviderImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileSnapshot;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.trace.ASTFrameEx;
import org.openide.util.Lookup;

public final class CodeModelDiagnostic {

    public static final class ProjectReferencesTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Project References";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            CsmProject csmProject2;
            Object object;
            ArrayList<CsmProject> arrayList = new ArrayList<CsmProject>(lookup.lookupAll(CsmProject.class));
            if (arrayList.isEmpty() && (object = (CsmFile)lookup.lookup(CsmFile.class)) != null && (csmProject2 = object.getProject()) != null) {
                arrayList.add(csmProject2);
            }
            printWriter.println("References:");
            for (CsmProject csmProject2 : arrayList) {
                printWriter.print(csmProject2.getName() + " : ");
                int n = 0;
                for (CsmFile csmFile : csmProject2.getAllFiles()) {
                    n += ((FileImpl)csmFile).getReferences().size();
                }
                printWriter.println(n);
            }
        }
    }

    public static final class ModelTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Project Code Model (Huge size)";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            CsmProject csmProject2;
            CsmFile csmFile;
            ArrayList<CsmProject> arrayList = new ArrayList<CsmProject>(lookup.lookupAll(CsmProject.class));
            if (arrayList.isEmpty() && (csmFile = (CsmFile)lookup.lookup(CsmFile.class)) != null && (csmProject2 = csmFile.getProject()) != null) {
                arrayList.add(csmProject2);
            }
            for (CsmProject csmProject2 : arrayList) {
                new CsmTracer((Writer)printWriter).dumpModel(csmProject2);
            }
        }
    }

    public static final class ProjectDeclarationsTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Project Declaration Containers (Huge size)";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            CsmProject csmProject;
            PrintStream printStream;
            ArrayList<CsmProject> arrayList = new ArrayList<CsmProject>(lookup.lookupAll(CsmProject.class));
            if (arrayList.isEmpty() && (printStream = (CsmFile)lookup.lookup(CsmFile.class)) != null && (csmProject = printStream.getProject()) instanceof ProjectBase) {
                arrayList.add(csmProject);
            }
            printStream = CsmTracer.toPrintStream((Writer)printWriter);
            for (CsmProject csmProject2 : arrayList) {
                if (!(csmProject2 instanceof ProjectBase)) continue;
                ((ProjectBase)csmProject2).traceProjectContainers(printStream);
            }
        }
    }

    public static final class FileImplASTTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "File AST";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            Collection collection = lookup.lookupAll(CsmFile.class);
            for (CsmFile csmFile : collection) {
                if (!(csmFile instanceof FileImpl)) continue;
                ASTFrameEx aSTFrameEx = new ASTFrameEx(((Object)csmFile.getName()).toString(), ((FileImpl)csmFile).debugParse());
                aSTFrameEx.setVisible(true);
            }
        }
    }

    public static final class FileImplModelTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "File Code Model";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            Collection collection = lookup.lookupAll(CsmFile.class);
            for (CsmFile csmFile : collection) {
                new CsmTracer((Writer)printWriter).dumpModel(csmFile);
            }
        }
    }

    public static final class ModelProjectsContainers
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Model Projects File Containers";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            printWriter.printf("====ModelImpl:\n", new Object[0]);
            ModelImpl.instance().dumpInfo(printWriter, true);
            printWriter.printf("====Libraries:\n", new Object[0]);
            LibraryManager.getInstance().dumpInfo(printWriter, true);
        }
    }

    public static final class ModelProjectsTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Model Projects";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            printWriter.printf("====ModelImpl:\n", new Object[0]);
            ModelImpl.instance().dumpInfo(printWriter, false);
            printWriter.printf("====Libraries:\n", new Object[0]);
            LibraryManager.getInstance().dumpInfo(printWriter, false);
        }
    }

    public static final class PPStatesTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Preprocessor States";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            printWriter.printf("====Files info:\nGlobal ParseCount=%d\n", FileImpl.getLongParseCount());
            Collection collection = lookup.lookupAll(CsmFile.class);
            for (CsmFile csmFile : collection) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpPPStates(printWriter);
                    continue;
                }
                printWriter.printf("UKNOWN FOR ME [%s] %s\n", csmFile.getClass().getName(), csmFile.toString());
            }
        }
    }

    public static final class FileTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "General File Information";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            printWriter.printf("====Files info:\nGlobal ParseCount=%d\n", FileImpl.getLongParseCount());
            Collection collection = lookup.lookupAll(CsmFile.class);
            for (CsmFile csmFile : collection) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpInfo(printWriter);
                    continue;
                }
                if (csmFile instanceof FileSnapshot) {
                    ((FileSnapshot)csmFile).dumpInfo(printWriter);
                    continue;
                }
                printWriter.printf("UKNOWN FOR ME [%s] %s\n", csmFile.getClass().getName(), csmFile.toString());
            }
        }
    }

    public static final class StandAloneProviderTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Standalone Files Information";
        }

        public void dumpInfo(Lookup lookup, PrintWriter printWriter) {
            printWriter.printf("====CsmStandaloneFileProviders info:\n", new Object[0]);
            for (CsmStandaloneFileProvider csmStandaloneFileProvider : Lookup.getDefault().lookupAll(CsmStandaloneFileProvider.class)) {
                if (csmStandaloneFileProvider instanceof CsmStandaloneFileProviderImpl) {
                    ((CsmStandaloneFileProviderImpl)csmStandaloneFileProvider).dumpInfo(printWriter);
                    continue;
                }
                printWriter.printf("UKNOWN FOR ME [%s] %s\n", csmStandaloneFileProvider.getClass().getName(), csmStandaloneFileProvider.toString());
            }
        }
    }
}

