/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.IOException;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTAbstractWalker;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;

public class APTWalkerTest
extends APTAbstractWalker {
    private long resolvingTime = 0L;
    private long lastTime = 0L;

    public APTWalkerTest(APTFile aPTFile, APTPreprocHandler aPTPreprocHandler) {
        super(aPTFile, aPTPreprocHandler, null);
    }

    public long getIncludeResolvingTime() {
        return this.resolvingTime;
    }

    protected void onInclude(APT aPT) {
        this.lastTime = System.currentTimeMillis();
        super.onInclude(aPT);
    }

    protected void onIncludeNext(APT aPT) {
        this.lastTime = System.currentTimeMillis();
        super.onIncludeNext(aPT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean include(ResolvedPath resolvedPath, APTInclude aPTInclude, PostIncludeData postIncludeData) {
        this.resolvingTime += System.currentTimeMillis() - this.lastTime;
        if (resolvedPath != null && this.getIncludeHandler().pushInclude(resolvedPath.getPath(), aPTInclude, resolvedPath.getIndex()) == APTIncludeHandler.IncludeState.Success) {
            try {
                APTFile aPTFile = APTDriver.findAPTLight((APTFileBuffer)ModelSupport.createFileBuffer(resolvedPath.getFileObject()));
                APTWalkerTest aPTWalkerTest = new APTWalkerTest(aPTFile, this.getPreprocHandler());
                aPTWalkerTest.visit();
                this.resolvingTime += aPTWalkerTest.resolvingTime;
            }
            catch (IOException iOException) {
                DiagnosticExceptoins.register(iOException);
                APTUtils.LOG.log(Level.SEVERE, "error on include " + resolvedPath, iOException);
            }
            finally {
                this.getIncludeHandler().popInclude();
            }
            return postIncludeData == null || !postIncludeData.hasPostIncludeMacroState();
        }
        return false;
    }

    protected boolean hasIncludeActionSideEffects() {
        return true;
    }
}

