/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.project.NativeProjectSettings;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryEvent;
import org.netbeans.modules.cnd.modelimpl.platform.FileBufferDoc;
import org.netbeans.modules.cnd.modelimpl.spi.LowMemoryAlerter;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ModelSupport
implements PropertyChangeListener {
    private static final ModelSupport instance = new ModelSupport();
    private ModelImpl theModel;
    private final Set<Lookup.Provider> openedProjects = new HashSet<Lookup.Provider>();
    private final ModifiedObjectsChangeListener modifiedListener = new ModifiedObjectsChangeListener();
    private FileChangeListener fileChangeListener;
    private static final boolean TRACE_STARTUP = Boolean.getBoolean("cnd.modelsupport.startup.trace");
    private volatile boolean postponeParse = false;
    private final RequestProcessor.Task openProjectsTask = new RequestProcessor("ModelSupport processor", 1).create(new Runnable(){

        @Override
        public void run() {
            ModelSupport.this.openProjects();
        }
    });
    private volatile boolean closed = false;

    private ModelSupport() {
    }

    public static ModelSupport instance() {
        return instance;
    }

    public static int getTabSize() {
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(ModelImpl modelImpl) {
        this.theModel = modelImpl;
        ModelSupport modelSupport = this;
        synchronized (modelSupport) {
            if (this.fileChangeListener != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)this.fileChangeListener);
                this.fileChangeListener = null;
            }
            if (modelImpl != null) {
                this.fileChangeListener = new ExternalUpdateListener();
                FileUtil.addFileChangeListener((FileChangeListener)this.fileChangeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startup() {
        this.modifiedListener.clean();
        DataObject.getRegistry().addChangeListener((ChangeListener)this.modifiedListener);
        Set<Lookup.Provider> set = this.openedProjects;
        synchronized (set) {
            this.closed = false;
        }
        if (!CndUtils.isStandalone()) {
            this.openedProjects.clear();
            if (TRACE_STARTUP) {
                System.out.println("Model support: Inited");
            }
            if (TopComponent.getRegistry().getOpened().size() > 0) {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Open projects in Init");
                }
                this.postponeParse = false;
                NativeProjectRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                this.openProjectsTask.schedule(0);
            } else {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Postpone open projects");
                }
                this.postponeParse = true;
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        if (TRACE_STARTUP) {
                            System.out.println("Model support: invoked after ready UI");
                        }
                        ModelSupport.this.postponeParse = false;
                        NativeProjectRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)ModelSupport.this);
                        ModelSupport.this.openProjectsTask.schedule(0);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        DataObject.getRegistry().removeChangeListener((ChangeListener)this.modifiedListener);
        this.modifiedListener.clean();
        ModelImpl modelImpl = this.theModel;
        if (modelImpl != null) {
            Set<Lookup.Provider> set = this.openedProjects;
            synchronized (set) {
                this.closed = true;
            }
            modelImpl.shutdown();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            if (TRACE_STARTUP) {
                System.out.println("Model support event:" + propertyChangeEvent.getPropertyName() + " postponeParse=" + this.postponeParse);
            }
            if (propertyChangeEvent.getPropertyName().equals("openNativeProjects") && !this.postponeParse) {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Open projects on OpenProjects.PROPERTY_OPEN_PROJECTS");
                }
                this.openProjectsTask.schedule(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProjects() {
        Collection collection = NativeProjectRegistry.getDefault().getOpenProjects();
        if (TRACE_STARTUP) {
            System.out.println("Model support: openProjects size=" + collection.size() + " modelState=" + CsmModelAccessor.getModelState());
        }
        Set<Lookup.Provider> set = this.openedProjects;
        synchronized (set) {
            Lookup.Provider provider2;
            Object object2;
            if (this.closed) {
                return;
            }
            if (TRACE_STARTUP) {
                System.out.println("Model support: openProjects new=" + collection.size() + " now=" + this.openedProjects.size());
            }
            HashSet<Lookup.Provider> hashSet = new HashSet<Lookup.Provider>();
            for (Object object2 : collection) {
                provider2 = object2.getProject();
                hashSet.add(provider2);
                if (this.openedProjects.contains(provider2)) continue;
                this.addProject(provider2);
            }
            HashSet hashSet2 = new HashSet();
            for (Lookup.Provider provider2 : this.openedProjects) {
                if (hashSet.contains(provider2)) continue;
                hashSet2.add(provider2);
            }
            object2 = hashSet2.iterator();
            while (object2.hasNext()) {
                provider2 = (Lookup.Provider)object2.next();
                this.closeProject(provider2);
            }
        }
    }

    public static void trace(NativeFileItem nativeFileItem) {
        try {
            Diagnostic.trace("  native file item" + nativeFileItem.getAbsolutePath());
            Diagnostic.trace("    user includes: " + nativeFileItem.getUserIncludePaths());
            Diagnostic.trace("    user macros: " + nativeFileItem.getUserMacroDefinitions());
            Diagnostic.trace("    system includes: " + nativeFileItem.getSystemIncludePaths());
            Diagnostic.trace("    system macros: " + nativeFileItem.getSystemMacroDefinitions());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public static void dumpNativeProject(NativeProject nativeProject) {
        System.err.println("\n\n\nDumping project " + nativeProject.getProjectDisplayName());
        System.err.println("\nSystem include paths");
        Object object = nativeProject.getSystemIncludePaths().iterator();
        while (object.hasNext()) {
            System.err.println("    " + object.next());
        }
        System.err.println("\nUser include paths");
        object = nativeProject.getUserIncludePaths().iterator();
        while (object.hasNext()) {
            System.err.println("    " + object.next());
        }
        System.err.println("\nSystem macros");
        object = nativeProject.getSystemMacroDefinitions().iterator();
        while (object.hasNext()) {
            System.err.println("    " + (String)object.next());
        }
        System.err.println("\nUser macros");
        object = nativeProject.getUserMacroDefinitions().iterator();
        while (object.hasNext()) {
            System.err.println("    " + (String)object.next());
        }
        object = new ArrayList();
        ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
        for (NativeFileItem nativeFileItem : nativeProject.getAllFiles()) {
            if (nativeFileItem.isExcluded()) continue;
            switch (nativeFileItem.getLanguage()) {
                case C: 
                case CPP: 
                case FORTRAN: {
                    object.add(nativeFileItem);
                    break;
                }
                case C_HEADER: {
                    arrayList.add(nativeFileItem);
                    break;
                }
            }
        }
        System.err.println("\nSources: (" + object.size() + " files )");
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            NativeFileItem nativeFileItem;
            nativeFileItem = (NativeFileItem)iterator.next();
            System.err.println(nativeFileItem.getAbsolutePath());
        }
        System.err.println("\nHeaders: (" + arrayList.size() + " files )");
        for (NativeFileItem nativeFileItem : arrayList) {
            System.err.println(nativeFileItem.getAbsolutePath());
        }
        System.err.println("End of project dump\n\n\n");
    }

    public static NativeProject getNativeProject(Object object) {
        NativeProject nativeProject;
        NativeProject nativeProject2 = nativeProject = object instanceof NativeProject ? (NativeProject)object : null;
        if (object instanceof Project) {
            Project project = (Project)object;
            nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
        }
        return nativeProject;
    }

    private String toString(Lookup.Provider provider) {
        StringBuilder stringBuilder = new StringBuilder();
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)((Project)provider));
        if (projectInformation != null) {
            stringBuilder.append(" Name=").append(projectInformation.getName());
            stringBuilder.append(" DisplayName=").append(projectInformation.getDisplayName());
        }
        return stringBuilder.toString();
    }

    private void addProject(final Lookup.Provider provider) {
        NativeProject nativeProject;
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("### ModelSupport.addProject: " + this.toString(provider));
        }
        if ((nativeProject = (NativeProject)provider.getLookup().lookup(NativeProject.class)) != null) {
            CsmModelAccessor.getModel();
            final ModelImpl modelImpl = this.theModel;
            if (modelImpl == null) {
                return;
            }
            this.openedProjects.add(provider);
            if (TraceFlags.DEBUG) {
                this.dumpProjectFiles(nativeProject);
            }
            String string = NbBundle.getMessage(this.getClass(), (String)"MSG_CodeAssistanceInitializationTask", (Object)nativeProject.getProjectDisplayName());
            NamedRunnable namedRunnable = new NamedRunnable(string){

                protected void runImpl() {
                    NativeProjectSettings nativeProjectSettings = (NativeProjectSettings)provider.getLookup().lookup(NativeProjectSettings.class);
                    boolean bl = nativeProjectSettings == null ? true : nativeProjectSettings.isCodeAssistanceEnabled();
                    modelImpl.addProject(nativeProject, nativeProject.getProjectDisplayName(), bl);
                }
            };
            nativeProject.runOnProjectReadiness(namedRunnable);
        }
    }

    private void dumpProjectFiles(NativeProject nativeProject) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("+++ Sources:");
            ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
            ArrayList<NativeFileItem> arrayList2 = new ArrayList<NativeFileItem>();
            for (NativeFileItem nativeFileItem : nativeProject.getAllFiles()) {
                if (nativeFileItem.isExcluded()) continue;
                switch (nativeFileItem.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: {
                        arrayList.add(nativeFileItem);
                        break;
                    }
                    case C_HEADER: {
                        arrayList2.add(nativeFileItem);
                        break;
                    }
                }
            }
            for (NativeFileItem nativeFileItem : arrayList) {
                ModelSupport.trace(nativeFileItem);
            }
            Diagnostic.trace("+++ Headers:");
            for (NativeFileItem nativeFileItem : arrayList2) {
                ModelSupport.trace(nativeFileItem);
            }
        }
    }

    private void closeProject(Lookup.Provider provider) {
        ModelImpl modelImpl;
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("### ModelSupport.closeProject: " + this.toString(provider));
        }
        if ((modelImpl = this.theModel) == null || modelImpl.getState() != CsmModelState.ON) {
            return;
        }
        NativeProject nativeProject = (NativeProject)provider.getLookup().lookup(NativeProject.class);
        if (nativeProject != null) {
            modelImpl.closeProject(nativeProject);
        }
        this.openedProjects.remove(provider);
    }

    private static FileBuffer createFileBuffer(DataObject dataObject) {
        StyledDocument styledDocument;
        EditorCookie editorCookie;
        FileObject fileObject = dataObject.getPrimaryFile();
        if (fileObject.isValid() && dataObject.isModified() && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null && (styledDocument = editorCookie.getDocument()) != null) {
            return new FileBufferDoc(fileObject, styledDocument);
        }
        return new FileBufferFile(fileObject);
    }

    public static FileBuffer createFileBuffer(FileObject fileObject) {
        FileSystem fileSystem;
        Parameters.notNull((CharSequence)"null file object", (Object)fileObject);
        if (fileObject.isValid()) {
            try {
                StyledDocument styledDocument;
                EditorCookie editorCookie;
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject.isModified() && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null && (styledDocument = editorCookie.getDocument()) != null) {
                    return new FileBufferDoc(fileObject, styledDocument);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
            return new FileBufferFile(fileObject);
        }
        try {
            fileSystem = fileObject.getFileSystem();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            fileSystem = InvalidFileObjectSupport.getDummyFileSystem();
        }
        return new FileBufferFile(InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fileSystem, (CharSequence)fileObject.getPath()));
    }

    public void onMemoryLow(LowMemoryEvent lowMemoryEvent, boolean bl) {
        LowMemoryAlerter lowMemoryAlerter = (LowMemoryAlerter)Lookup.getDefault().lookup(LowMemoryAlerter.class);
        if (lowMemoryAlerter != null) {
            lowMemoryAlerter.alert(lowMemoryEvent, bl);
        }
    }

    public static void traceDataObjectRegistryStateChanged(ChangeEvent changeEvent) {
        Diagnostic.trace("state of registry changed:");
        Diagnostic.indent();
        if (changeEvent != null) {
            DataObject[] dataObjectArray = DataObject.getRegistry().getModified();
            if (dataObjectArray.length == 0) {
                Diagnostic.trace("all objects are saved");
            } else {
                Diagnostic.trace("set of edited objects:");
                for (int i = 0; i < dataObjectArray.length; ++i) {
                    Object object2;
                    DataObject dataObject = dataObjectArray[i];
                    Diagnostic.trace("object " + i + ":" + dataObject.getName());
                    Diagnostic.indent();
                    Diagnostic.trace("with file: " + dataObject.getPrimaryFile());
                    NativeFileItemSet nativeFileItemSet = (NativeFileItemSet)dataObject.getNodeDelegate().getLookup().lookup(NativeFileItemSet.class);
                    if (nativeFileItemSet == null) {
                        Diagnostic.trace("NativeFileItemSet == null");
                    } else {
                        Diagnostic.trace("NativeFileItemSet:");
                        for (Object object2 : nativeFileItemSet.getItems()) {
                            Diagnostic.trace("\t" + object2.getNativeProject().getProjectDisplayName());
                        }
                    }
                    EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                    Diagnostic.trace("has editor support: " + editorCookie);
                    object2 = editorCookie != null ? editorCookie.getDocument() : null;
                    Diagnostic.trace("with document: " + object2);
                    Diagnostic.unindent();
                }
            }
        } else {
            Diagnostic.trace("no additional info from event object");
        }
        Diagnostic.unindent();
    }

    private class ExternalUpdateListener
    extends FileChangeAdapter
    implements Runnable {
        private boolean isRunning;
        private final Map<FileObject, Boolean> changedFileObjects = new HashMap<FileObject, Boolean>();
        private final Map<FileObject, Long> eventTimes = new WeakHashMap<FileObject, Long>();

        private ExternalUpdateListener() {
        }

        public void fileChanged(FileEvent fileEvent) {
            FileObject fileObject;
            ModelImpl modelImpl;
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                System.err.printf("External updates: fileChanged %s\n", fileEvent);
            }
            if ((modelImpl = ModelSupport.this.theModel) != null && this.isCOrCpp(fileObject = fileEvent.getFile())) {
                this.scheduleUpdate(fileObject, fileEvent.getTime(), false);
            }
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject;
            ModelImpl modelImpl;
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                System.err.printf("External updates: fileDataCreated %s\n", fileEvent);
            }
            if ((modelImpl = ModelSupport.this.theModel) != null && this.isCOrCpp(fileObject = fileEvent.getFile())) {
                this.scheduleUpdate(fileObject, fileEvent.getTime(), true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleUpdate(FileObject fileObject, long l, boolean bl) {
            ModelImpl modelImpl = ModelSupport.this.theModel;
            if (modelImpl != null) {
                ExternalUpdateListener externalUpdateListener = this;
                synchronized (externalUpdateListener) {
                    Long l2 = this.eventTimes.get(fileObject);
                    if (l2 != null && l - l2 <= 500L) {
                        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                            System.err.printf("External updates: SKIP EVENT By oldT:%s and newT:%d\n", l2, l);
                        }
                        return;
                    }
                    this.eventTimes.put(fileObject, l);
                    if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                        System.err.printf("External updates: scheduling update for %s\n", fileObject);
                    }
                    if (!this.changedFileObjects.containsKey(fileObject)) {
                        this.changedFileObjects.put(fileObject, bl);
                    }
                    if (!this.isRunning) {
                        this.isRunning = true;
                        modelImpl.enqueueModelTask(this, "External File Updater");
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @Override
        public void run() {
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                System.err.printf("External updates: running update task\n", new Object[0]);
            }
            block5: while (true) {
                var3_3 /* !! */  = this;
                synchronized (var3_3 /* !! */ ) {
                    if (this.changedFileObjects.isEmpty()) {
                        this.isRunning = false;
                        break;
                    }
                    var4_4 = this.changedFileObjects.entrySet().iterator();
                    var5_7 = var4_4.next();
                    var1_1 = var5_7.getKey();
                    var2_2 = var5_7.getValue();
                    var4_4.remove();
                }
                if (var1_1 == null) continue;
                if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                    System.err.printf("Updating for %s\n", new Object[]{var1_1});
                }
                if (var2_2) {
                    var3_3 /* !! */  = (ProjectBase)CsmUtilities.getCsmProject((FileObject)var1_1);
                    if (var3_3 /* !! */  != null) {
                        var3_3 /* !! */ .onFileExternalCreate(var1_1);
                        continue;
                    }
                    CndFileUtils.clearFileExistenceCache();
                    continue;
                }
                try {
                    var3_3 /* !! */  = CsmUtilities.getCsmFiles((DataObject)DataObject.find((FileObject)var1_1), (boolean)false, (boolean)false);
                }
                catch (DataObjectNotFoundException var4_5) {
                    var3_3 /* !! */  = new CsmFile[]{};
                }
                var4_6 = 0;
                while (true) {
                    if (var4_6 < var3_3 /* !! */ .length) ** break;
                    continue block5;
                    var5_7 = (FileImpl)var3_3 /* !! */ [var4_6];
                    var6_8 = var5_7.getProjectImpl(true);
                    var6_8.onFileExternalChange((FileImpl)var5_7);
                    ++var4_6;
                }
                break;
            }
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                System.err.printf("External updates: update task finished\n", new Object[0]);
            }
        }

        private boolean isCOrCpp(FileObject fileObject) {
            String string = fileObject.getMIMEType();
            if (string == null) {
                string = FileUtil.getMIMEType((FileObject)fileObject);
                if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                    System.err.printf("MIME resolved: %s\n", string);
                }
            }
            return MIMENames.isFortranOrHeaderOrCppOrC((String)string);
        }
    }

    private class ModifiedObjectsChangeListener
    implements ChangeListener {
        private final Map<DataObject, Collection<BufAndProj>> buffers = new HashMap<DataObject, Collection<BufAndProj>>();

        private ModifiedObjectsChangeListener() {
        }

        private Collection<BufAndProj> getBufNP(DataObject dataObject) {
            Collection<BufAndProj> collection = this.buffers.get(dataObject);
            return collection == null ? Collections.emptyList() : collection;
        }

        private void addBufNP(DataObject dataObject, BufAndProj bufAndProj) {
            Collection<BufAndProj> collection = this.buffers.get(dataObject);
            if (collection == null) {
                collection = new ArrayList<BufAndProj>();
                this.buffers.put(dataObject, collection);
            }
            collection.add(bufAndProj);
        }

        private void editStart(DataObject dataObject) {
            ModelImpl modelImpl = ModelSupport.this.theModel;
            if (modelImpl == null) {
                return;
            }
            if (!dataObject.isValid()) {
                return;
            }
            NativeFileItemSet nativeFileItemSet = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
            if (nativeFileItemSet == null) {
                nativeFileItemSet = this.findCanonicalSet(dataObject);
            }
            if (nativeFileItemSet != null && !nativeFileItemSet.isEmpty()) {
                StyledDocument styledDocument;
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                StyledDocument styledDocument2 = styledDocument = editorCookie != null ? editorCookie.getDocument() : null;
                if (styledDocument.getProperty("cnd.refactoring.modification.event") != Boolean.TRUE) {
                    FileObject fileObject = dataObject.getPrimaryFile();
                    long l = fileObject.lastModified().getTime();
                    FileBufferDoc fileBufferDoc = new FileBufferDoc(fileObject, styledDocument);
                    for (NativeFileItem nativeFileItem : nativeFileItemSet.getItems()) {
                        ProjectBase projectBase = (ProjectBase)modelImpl.getProject(nativeFileItem.getNativeProject());
                        if (projectBase == null) continue;
                        this.addBufNP(dataObject, new BufAndProj(fileBufferDoc, projectBase, nativeFileItem, l));
                        projectBase.onFileEditStart(fileBufferDoc, nativeFileItem);
                    }
                }
            }
        }

        private boolean isCndDataObject(FileObject fileObject) {
            String string = fileObject.getMIMEType();
            return MIMENames.isFortranOrHeaderOrCppOrC((String)string);
        }

        private NativeFileItemSet findCanonicalSet(DataObject dataObject) {
            FileObject fileObject = dataObject.getPrimaryFile();
            if (fileObject != null && this.isCndDataObject(fileObject)) {
                try {
                    fileObject = CndFileUtils.getCanonicalFileObject((FileObject)fileObject);
                    dataObject = DataObject.find((FileObject)fileObject);
                    return (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return null;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (TraceFlags.DEBUG) {
                ModelSupport.traceDataObjectRegistryStateChanged(changeEvent);
            }
            if (changeEvent != null) {
                Object[] objectArray = DataObject.getRegistry().getModified();
                HashSet<DataObject> hashSet = new HashSet<DataObject>();
                for (DataObject dataObject : this.buffers.keySet()) {
                    if (this.contains(objectArray, dataObject)) continue;
                    for (BufAndProj bufAndProj : this.getBufNP(dataObject)) {
                        if (bufAndProj != null) {
                            FileBuffer fileBuffer = ModelSupport.createFileBuffer(dataObject);
                            long l = fileBuffer.lastModified();
                            bufAndProj.project.onFileEditEnd(fileBuffer, bufAndProj.nativeFile, bufAndProj.lastModified == l);
                            continue;
                        }
                        System.err.println("no buffer for " + dataObject);
                    }
                    hashSet.add(dataObject);
                }
                Iterator<Object> iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    this.buffers.remove(iterator.next());
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    if (this.buffers.containsKey(objectArray[i])) continue;
                    this.editStart((DataObject)objectArray[i]);
                }
            }
        }

        private boolean contains(Object[] objectArray, Object object) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!objectArray[i].equals(object)) continue;
                return true;
            }
            return false;
        }

        private void clean() {
            this.buffers.clear();
        }
    }

    private static final class BufAndProj {
        public final FileBuffer buffer;
        public final ProjectBase project;
        public final NativeFileItem nativeFile;
        public final long lastModified;

        public BufAndProj(FileBuffer fileBuffer, ProjectBase projectBase, NativeFileItem nativeFileItem, long l) {
            assert (fileBuffer != null) : "null buffer";
            this.buffer = fileBuffer;
            assert (projectBase != null) : "null project";
            this.project = projectBase;
            assert (nativeFileItem != null) : "null nativeFile";
            this.nativeFile = nativeFileItem;
            this.lastModified = l;
        }
    }
}

